/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.mimic.model;

import artifacts.Artifacts;
import artifacts.entity.MimicEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;

public class MimicModel
extends EntityModel<MimicEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Artifacts.id("mimic"), "mimic");
    protected final ModelPart bottom;
    protected final ModelPart lid;

    public MimicModel(ModelPart part) {
        this.bottom = part.getChild("bottom");
        this.lid = part.getChild("lid");
    }

    public void setupAnim(MimicEntity mimic, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void prepareMobModel(MimicEntity mimic, float limbSwing, float limbSwingAmount, float partialTicks) {
        MimicModel.setChestRotations(mimic, partialTicks, this.lid, this.bottom);
    }

    protected static void setChestRotations(MimicEntity mimic, float partialTicks, ModelPart lid, ModelPart bottom) {
        if (mimic.ticksInAir > 0) {
            lid.xRot = Math.max(-60.0f, ((float)(mimic.ticksInAir - 1) + partialTicks) * -6.0f) * 0.0174533f;
            bottom.xRot = Math.min(30.0f, ((float)(mimic.ticksInAir - 1) + partialTicks) * 3.0f) * 0.0174533f;
        } else {
            lid.xRot = 0.0f;
            bottom.xRot = 0.0f;
        }
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.lid.render(matrixStack, buffer, packedLight, packedOverlay, color);
        this.bottom.render(matrixStack, buffer, packedLight, packedOverlay, color);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        mesh.getRoot().addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 15).addBox(-6.0f, -4.0f, -13.0f, 12.0f, 3.0f, 12.0f).texOffs(36, 15).addBox(-6.0f, -1.0f, -13.0f, 12.0f, 0.0f, 12.0f, new CubeDeformation(0.02f)), PartPose.offset((float)0.0f, (float)15.0f, (float)7.0f));
        mesh.getRoot().addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, 0.0f, -13.0f, 12.0f, 3.0f, 12.0f).texOffs(24, 0).addBox(-6.0f, 0.0f, -13.0f, 12.0f, 0.0f, 12.0f, new CubeDeformation(0.02f)), PartPose.offset((float)0.0f, (float)15.0f, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }
}

