/*
 * Decompiled with CFR 0.152.
 */
package com.mars.laserbridges;

import com.mars.deimos.config.DeimosConfig;
import com.mars.laserbridges.LasersConfig;
import com.mars.laserbridges.blocks.BridgeSourceBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class CommonClass {
    public static void init() {
        DeimosConfig.init((String)"laserbridges", LasersConfig.class);
        OptionalDispenseItemBehavior dyeBehavior = new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource blockSource, ItemStack stack) {
                ServerLevel serverLevel = blockSource.level();
                Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockPos = blockSource.pos().relative(direction);
                BlockState blockState = serverLevel.getBlockState(blockPos);
                Block block = blockState.getBlock();
                if (block.equals(BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"laserbridges", (String)"laser_source_block"))) || block.equals(BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"laserbridges", (String)"laser_fence_source_block")))) {
                    Item item = stack.getItem();
                    int col = ((DyeItem)item).getDyeColor().getId();
                    serverLevel.setBlock(blockPos, (BlockState)blockState.setValue((Property)BridgeSourceBlock.COLOR, (Comparable)Integer.valueOf(col)), 2);
                    stack.shrink(1);
                    serverLevel.gameEvent((Entity)null, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
                    this.setSuccess(true);
                    return stack;
                }
                return super.execute(blockSource, stack);
            }
        };
        DispenserBlock.registerBehavior((ItemLike)Items.WHITE_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.ORANGE_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.MAGENTA_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.LIGHT_BLUE_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.YELLOW_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.LIME_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.PINK_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.GRAY_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.LIGHT_GRAY_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.CYAN_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.PURPLE_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.BLUE_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.BROWN_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.GREEN_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.RED_DYE, (DispenseItemBehavior)dyeBehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.BLACK_DYE, (DispenseItemBehavior)dyeBehavior);
    }
}

