/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.level;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.common.world.chunk.TicketHelper;
import net.neoforged.neoforge.common.world.chunk.TicketSet;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.common.device.TileFluxDevice;

public class FluxChunkLoading {
    public static final TicketController CONTROLLER = new TicketController(FluxNetworks.location("device"), FluxChunkLoading::forceloadChunks);

    public static void forceloadChunks(ServerLevel level, TicketHelper helper) {
        if (!FluxConfig.enableChunkLoading) {
            helper.getBlockTickets().keySet().forEach(arg_0 -> ((TicketHelper)helper).removeAllTickets(arg_0));
            FluxNetworks.LOGGER.info("Removed all chunk loaders because chunk loading is disabled");
        } else {
            int chunks = 0;
            for (Map.Entry entry : helper.getBlockTickets().entrySet()) {
                BlockEntity blockEntity = level.getBlockEntity((BlockPos)entry.getKey());
                if (blockEntity instanceof TileFluxDevice) {
                    TileFluxDevice e = (TileFluxDevice)blockEntity;
                    e.setForcedLoading(true);
                    TicketSet pair = (TicketSet)entry.getValue();
                    int count = 0;
                    if ((count += pair.nonTicking().size() + pair.ticking().size()) != 1) {
                        FluxNetworks.LOGGER.warn("{} in {} didn't load just one chunk {}", entry.getValue(), (Object)level.dimension().location(), (Object)pair);
                    }
                    chunks += count;
                    continue;
                }
                helper.removeAllTickets((BlockPos)entry.getKey());
            }
            FluxNetworks.LOGGER.info("Loaded {} chunks by {} flux devices in {}", (Object)chunks, (Object)helper.getBlockTickets().size(), (Object)level.dimension().location());
        }
    }
}

