/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.datagen;

import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.StrippableLog;
import com.hollingsworth.arsnouveau.common.items.AnimBlockItem;
import java.util.HashSet;
import lyrellion.ars_elemancy.ArsElemancy;
import lyrellion.ars_elemancy.api.item.SpellPrismLens;
import lyrellion.ars_elemancy.datagen.Datagen;
import lyrellion.ars_elemancy.registry.ModItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class AEItemModelProvider
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = ResourceLocation.withDefaultNamespace((String)"item/generated");
    private static final ResourceLocation HANDHELD = ResourceLocation.withDefaultNamespace((String)"item/handheld");
    private static final ResourceLocation SPAWN_EGG = ResourceLocation.withDefaultNamespace((String)"item/template_spawn_egg");

    public AEItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "ars_elemancy", existingFileHelper);
    }

    protected void registerModels() {
        HashSet items = new HashSet(ModItems.ITEMS.getEntries());
        Datagen.takeAll(items, i -> i.get() instanceof AnimBlockItem).forEach(this::blockItem);
        Datagen.takeAll(items, i -> i.get() instanceof SpellPrismLens);
        Datagen.takeAll(items, i -> {
            BlockItem bi;
            Object patt0$temp = i.get();
            return patt0$temp instanceof BlockItem && (bi = (BlockItem)patt0$temp).getBlock() instanceof ArchfruitPod;
        }).forEach(this::generatedItem);
        Datagen.takeAll(items, i -> {
            BlockItem bi;
            Object patt0$temp = i.get();
            return patt0$temp instanceof BlockItem && (bi = (BlockItem)patt0$temp).getBlock() instanceof FenceBlock;
        }).forEach(this::fenceBlockItem);
        Datagen.takeAll(items, i -> {
            BlockItem bi;
            Object patt0$temp = i.get();
            return patt0$temp instanceof BlockItem && (bi = (BlockItem)patt0$temp).getBlock() instanceof SaplingBlock;
        }).forEach(this::blockGeneratedItem);
        Datagen.takeAll(items, i -> i.get() instanceof BlockItem).forEach(this::blockItem);
        Datagen.takeAll(items, i -> i.get() instanceof DiggerItem).forEach(this::handheldItem);
        Datagen.takeAll(items, i -> i.get() instanceof SpawnEggItem).forEach(this::spawnEgg);
        items.forEach(this::generatedItem);
    }

    private void spawnEgg(DeferredHolder<Item, ? extends Item> i) {
        String name = BuiltInRegistries.ITEM.getKey((Object)((Item)i.get())).getPath();
        try {
            this.withExistingParent(name, SPAWN_EGG);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Failed to generate model {}", (Object)name, (Object)e);
        }
    }

    private void handheldItem(DeferredHolder<Item, ? extends Item> i) {
        String name = BuiltInRegistries.ITEM.getKey((Object)((Item)i.get())).getPath();
        try {
            ((ItemModelBuilder)this.withExistingParent(name, HANDHELD)).texture("layer0", ArsElemancy.prefix("item/" + name));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Failed to generate model {}", (Object)name, (Object)e);
        }
    }

    private void generatedItem(DeferredHolder<Item, ? extends Item> i) {
        String name = BuiltInRegistries.ITEM.getKey((Object)((Item)i.get())).getPath();
        try {
            ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", ArsElemancy.prefix("item/" + name));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Failed to generate model {}", (Object)name, (Object)e);
        }
    }

    private void focusModel(DeferredHolder<Item, ? extends Item> i) {
        String name = BuiltInRegistries.ITEM.getKey((Object)((Item)i.get())).getPath();
        try {
            ((ItemModelBuilder)this.withExistingParent("item/focus/" + name, GENERATED)).texture("layer0", ArsElemancy.prefix("item/" + name));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Failed to generate model {}", (Object)name, (Object)e);
        }
    }

    private void blockGeneratedItem(DeferredHolder<Item, ? extends Item> i) {
        String name = BuiltInRegistries.ITEM.getKey((Object)((Item)i.get())).getPath();
        try {
            ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", ArsElemancy.prefix("block/" + name));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Failed to generate model {}", (Object)name, (Object)e);
        }
    }

    private void blockItem(DeferredHolder<Item, ? extends Item> i) {
        BlockItem bi;
        String name = BuiltInRegistries.ITEM.getKey((Object)((Item)i.get())).getPath();
        String root = "block/";
        Object object = i.get();
        if (object instanceof BlockItem && ((bi = (BlockItem)object).getBlock() instanceof RotatedPillarBlock || bi.getBlock() instanceof LeavesBlock || bi.getBlock() instanceof StrippableLog)) {
            root = "block/archwood/";
        }
        try {
            ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(ArsElemancy.prefix(root + name)));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Failed to generate model {}", (Object)name, (Object)e);
        }
    }

    private void fenceBlockItem(DeferredHolder<Item, ? extends Item> i) {
        String name = BuiltInRegistries.ITEM.getKey((Object)((Item)i.get())).getPath();
        String baseName = name.substring(0, name.length() - 6);
        try {
            this.fenceInventory(name, ArsElemancy.prefix("block/" + baseName));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Failed to generate model {}", (Object)name, (Object)e);
        }
    }

    @NotNull
    public String getName() {
        return "Ars Elemancy Item Models";
    }
}

