/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.common.items.armor;

import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import lyrellion.ars_elemancy.common.items.armor.ElemancyArmor;
import lyrellion.ars_elemancy.registry.ModItems;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ArmorSet {
    private final String name;
    DeferredHolder<Item, ElemancyArmor> head;
    DeferredHolder<Item, ElemancyArmor> chest;
    DeferredHolder<Item, ElemancyArmor> legs;
    DeferredHolder<Item, ElemancyArmor> feet;

    public String getName() {
        return this.name;
    }

    public ArmorSet(String name, SpellSchool element) {
        this.name = name;
        this.head = ModItems.ITEMS.register(name + "_hat", () -> new ElemancyArmor(ArmorItem.Type.HELMET, element, ModItems.armorProps()));
        this.chest = ModItems.ITEMS.register(name + "_robes", () -> new ElemancyArmor(ArmorItem.Type.CHESTPLATE, element, ModItems.armorProps()));
        this.legs = ModItems.ITEMS.register(name + "_leggings", () -> new ElemancyArmor(ArmorItem.Type.LEGGINGS, element, ModItems.armorProps()));
        this.feet = ModItems.ITEMS.register(name + "_boots", () -> new ElemancyArmor(ArmorItem.Type.BOOTS, element, ModItems.armorProps()));
    }

    public Item getHat() {
        return (Item)this.head.get();
    }

    public Item getChest() {
        return (Item)this.chest.get();
    }

    public Item getLegs() {
        return (Item)this.legs.get();
    }

    public Item getBoots() {
        return (Item)this.feet.get();
    }

    public Item getArmorFromSlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.CHEST -> this.getChest();
            case EquipmentSlot.LEGS -> this.getLegs();
            case EquipmentSlot.FEET -> this.getBoots();
            default -> this.getHat();
        };
    }

    public String getTranslationKey() {
        return "ars_elemancy.armor_set." + this.name;
    }
}

