/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.enchantments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.Optionull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.phys.Vec3;

public record CatalyzeEnvironment(boolean dropXp) implements EnchantmentEntityEffect
{
    public static final MapCodec<CatalyzeEnvironment> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("drop_xp").forGetter(CatalyzeEnvironment::dropXp)).apply((Applicative)instance, CatalyzeEnvironment::new));

    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3 origin) {
        LivingEntity target;
        if (entity instanceof LivingEntity && (target = (LivingEntity)entity).isDeadOrDying() && !target.wasExperienceConsumed()) {
            int i;
            SculkSpreader spreader = SculkSpreader.createLevelSpreader();
            Entity attacker = (Entity)Optionull.map((Object)target.getLastDamageSource(), DamageSource::getEntity);
            if (!(attacker instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)attacker;
            BlockPos pos = new BlockPos((int)origin.x, (int)origin.y, (int)origin.z);
            for (i = 0; i < 3 * enchantmentLevel; ++i) {
                spreader.addCursors(pos, target.getExperienceReward(level, attacker));
            }
            for (i = 0; i < 8 * enchantmentLevel; ++i) {
                spreader.updateCursors((LevelAccessor)level, pos, level.getRandom(), true);
            }
            if (!this.dropXp) {
                target.skipDropExperience();
            }
            CriteriaTriggers.KILL_MOB_NEAR_SCULK_CATALYST.trigger(serverPlayer, (Entity)target, target.damageSources().playerAttack((Player)serverPlayer));
        }
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

