/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.blocks;

import com.kyanite.deeperdarker.content.DDBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class BloomingStemBlock
extends Block {
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    private static final VoxelShape[] shapes = new VoxelShape[]{Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Block.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0), Block.box((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Block.box((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0), Block.box((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0)};

    public BloomingStemBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState belowState = level.getBlockState(pos.below());
        BlockState northState = level.getBlockState(pos.north());
        BlockState eastState = level.getBlockState(pos.east());
        BlockState southState = level.getBlockState(pos.south());
        BlockState westState = level.getBlockState(pos.west());
        if (this.checkState(belowState) || belowState.is((Block)DDBlocks.BLOOMING_SCULK_STONE.get())) {
            return this.defaultBlockState();
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(this.checkState(belowState) || belowState.is((Block)DDBlocks.BLOOMING_SCULK_STONE.get())))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.checkState(northState)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.checkState(eastState)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.checkState(southState)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.checkState(westState)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = shapes[0];
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)shapes[1], (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)shapes[2], (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)shapes[3], (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)shapes[4], (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)shapes[5], (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)shapes[6], (BooleanOp)BooleanOp.OR);
        }
        return shape;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
            return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
        }
        if (direction == Direction.DOWN && neighborState.is((Block)DDBlocks.BLOOMING_SCULK_STONE.get())) {
            return (BlockState)state.setValue((Property)DOWN, (Comparable)Boolean.valueOf(true));
        }
        if (direction.getAxis().isHorizontal() && this.checkState(neighborState) && this.canSurvive(level.getBlockState(neighborPos.below()))) {
            return state;
        }
        return (BlockState)state.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.checkState(neighborState)));
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        if (itemAbility == ItemAbilities.AXE_STRIP && state.is((Block)DDBlocks.BLOOMING_STEM.get())) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)DDBlocks.STRIPPED_BLOOMING_STEM.get()).defaultBlockState().setValue((Property)UP, (Comparable)((Boolean)state.getValue((Property)UP)))).setValue((Property)DOWN, (Comparable)((Boolean)state.getValue((Property)DOWN)))).setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)WEST)));
        }
        return super.getToolModifiedState(state, context, itemAbility, simulate);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.getBlockState(pos.below());
        if (this.canSurvive(below)) {
            return true;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos relativePos = pos.relative(direction);
            BlockState relativeState = level.getBlockState(relativePos);
            if (!this.checkState(relativeState) || !((Boolean)state.getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction))).booleanValue() || !this.canSurvive(level.getBlockState(pos.below()))) continue;
            return true;
        }
        return false;
    }

    private boolean canSurvive(BlockState state) {
        return this.checkState(state) || state.is((Block)DDBlocks.BLOOMING_SCULK_STONE.get());
    }

    private boolean checkState(BlockState state) {
        return state.is((Block)DDBlocks.BLOOMING_STEM.get()) || state.is((Block)DDBlocks.STRIPPED_BLOOMING_STEM.get());
    }
}

