/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.mixins;

import com.leobeliik.extremesoundmuffler.CommonConfig;
import com.leobeliik.extremesoundmuffler.gui.MufflerScreen;
import com.leobeliik.extremesoundmuffler.gui.buttons.PlaySoundButton;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import java.util.Locale;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SoundEngine.class})
public abstract class SoundMixin
implements ISoundLists {
    @Unique
    @Nullable
    private SoundInstance esmSound;

    @Inject(at={@At(value="HEAD")}, method={"calculateVolume(Lnet/minecraft/client/resources/sounds/SoundInstance;)F"})
    private void esm_captureSoundVolume(SoundInstance sound, CallbackInfoReturnable<Float> cir) {
        this.esmSound = sound;
    }

    @Inject(at={@At(value="HEAD")}, method={"play"})
    private void esm_captureTickableSoundVolume(SoundInstance sound, CallbackInfo ci) {
        this.esmSound = sound;
    }

    @ModifyArg(index=0, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(FFF)F"), method={"calculateVolume(FLnet/minecraft/sounds/SoundSource;)F"})
    private float esm_setVolume(float volume) {
        if (!MufflerScreen.isMuffling()) {
            return volume;
        }
        SoundInstance tempSound = this.esmSound;
        if (tempSound != null && tempSound.getSound() != null && !PlaySoundButton.isFromPSB()) {
            Anchor anchor;
            ResourceLocation soundResourceLocation = tempSound.getLocation();
            if (!SoundMixin.esm_isForbidden(tempSound)) {
                recentSoundsList.remove(soundResourceLocation);
                recentSoundsList.add(soundResourceLocation);
            }
            float tempVolume = tempSound.getVolume();
            String soundName = soundResourceLocation.getPath();
            String modName = soundResourceLocation.getNamespace();
            if (soundName.contains("entity.lightning_bolt.thunder") || soundName.contains("entity.ender_dragon.growl")) {
                tempVolume = 1.0f;
            }
            if (muffledSounds.containsKey(soundResourceLocation)) {
                return (float)((double)tempVolume * (Double)muffledSounds.get(soundResourceLocation));
            }
            if (!CommonConfig.get().disableAnchors().get().booleanValue() && (anchor = Anchor.getAnchor(tempSound)) != null) {
                int maxAnchorRange = CommonConfig.get().maxAnchorRange().get();
                double radius = anchor.getRadius();
                if (radius > (double)maxAnchorRange) {
                    anchor.setRadius((int)Math.min(radius, (double)maxAnchorRange));
                }
                return (float)((double)tempVolume * (Double)anchor.getMuffledSounds().get(soundResourceLocation));
            }
            for (String mod : modsMuffled) {
                if (!mod.contains(modName.toLowerCase(Locale.ROOT))) continue;
                return tempVolume * Float.parseFloat(mod.split(":")[1]);
            }
        }
        return volume;
    }

    @Inject(at={@At(value="RETURN")}, method={"calculateVolume(Lnet/minecraft/client/resources/sounds/SoundInstance;)F"})
    private void esm_clearTickableSound(SoundInstance sound, CallbackInfoReturnable<Float> cir) {
        this.esmSound = null;
    }

    @Inject(at={@At(value="RETURN")}, method={"play"})
    private void esm_clearSound(SoundInstance sound, CallbackInfo ci) {
        this.esmSound = null;
    }

    @Unique
    private static boolean esm_isForbidden(SoundInstance sound) {
        return forbiddenSounds.stream().anyMatch(fs -> sound.getLocation().toString().contains((CharSequence)fs));
    }
}

