/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class Inventories {
    public static boolean areItemStacksIdentical(ItemStack a, ItemStack b) {
        return a.getItem() == b.getItem() && ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
    }

    public static boolean areItemStacksDifferent(ItemStack a, ItemStack b) {
        return a.getItem() != b.getItem() || !ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
    }

    public static boolean areItemStacksIdenticalIgnoreDamage(ItemStack a, ItemStack b) {
        if (a.getItem() != b.getItem()) {
            return false;
        }
        if (!a.isDamageableItem()) {
            return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
        }
        DataComponentMap bc = b.getComponents();
        return a.getComponents().stream().allMatch(a_tdc -> {
            if (!bc.has(a_tdc.type())) {
                return false;
            }
            if (a_tdc.value().equals(bc.get(a_tdc.type()))) {
                return true;
            }
            return a_tdc.type().equals((Object)DataComponents.DAMAGE);
        });
    }

    public static boolean isItemStackableOn(ItemStack a, ItemStack b) {
        return !a.isEmpty() && a.isStackable() && ItemStack.isSameItem((ItemStack)a, (ItemStack)b);
    }

    public static ItemStack extract(Player player, @Nullable ItemStack match, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        InventoryRange ir = InventoryRange.fromPlayerInventory(player);
        if (match == null) {
            return ir.extract(amount, false, simulate);
        }
        ItemStack mstack = match.copy();
        mstack.setCount(amount);
        return ir.extract(mstack, simulate);
    }

    public static ItemStack insert(Player player, ItemStack stack, boolean simulate) {
        return InventoryRange.fromPlayerInventory(player).insert(stack, simulate);
    }

    private static ItemStack checked(ItemStack stack) {
        return stack.isEmpty() ? ItemStack.EMPTY : stack;
    }

    public static Container copyOf(Container src) {
        int size = src.getContainerSize();
        SimpleContainer dst = new SimpleContainer(size);
        for (int i = 0; i < size; ++i) {
            dst.setItem(i, src.getItem(i).copy());
        }
        return dst;
    }

    public static ItemStack insert(InventoryRange[] to_ranges, ItemStack stack) {
        ItemStack remaining = stack.copy();
        for (InventoryRange range : to_ranges) {
            if (!(remaining = range.insert(remaining, false, 0, false, true)).isEmpty()) continue;
            return remaining;
        }
        return remaining;
    }

    public static void give(Player entity, ItemStack stack) {
        entity.getInventory().placeItemBackInInventory(stack);
    }

    public static class InventoryRange
    implements Container,
    Iterable<ItemStack> {
        protected final Container inventory_;
        protected final int offset_;
        protected final int size_;
        protected final int num_rows;
        protected int max_stack_size_ = 64;
        protected BiPredicate<Integer, ItemStack> validator_ = (index, stack) -> true;

        public static InventoryRange fromPlayerHotbar(Player player) {
            return new InventoryRange((Container)player.getInventory(), 0, 9, 1);
        }

        public static InventoryRange fromPlayerStorage(Player player) {
            return new InventoryRange((Container)player.getInventory(), 9, 27, 3);
        }

        public static InventoryRange fromPlayerInventory(Player player) {
            return new InventoryRange((Container)player.getInventory(), 0, 36, 4);
        }

        public InventoryRange(Container inventory, int offset, int size, int num_rows) {
            this.inventory_ = inventory;
            this.offset_ = Mth.clamp((int)offset, (int)0, (int)(inventory.getContainerSize() - 1));
            this.size_ = Mth.clamp((int)size, (int)0, (int)(inventory.getContainerSize() - this.offset_));
            this.num_rows = num_rows;
        }

        public InventoryRange(Container inventory, int offset, int size) {
            this(inventory, offset, size, 1);
        }

        public InventoryRange(Container inventory) {
            this(inventory, 0, inventory.getContainerSize(), 1);
        }

        public final Container inventory() {
            return this.inventory_;
        }

        public final int size() {
            return this.size_;
        }

        public final int offset() {
            return this.offset_;
        }

        public final ItemStack get(int index) {
            return this.inventory_.getItem(this.offset_ + index);
        }

        public final void set(int index, ItemStack stack) {
            this.inventory_.setItem(this.offset_ + index, stack);
        }

        public final InventoryRange setValidator(BiPredicate<Integer, ItemStack> validator) {
            this.validator_ = validator;
            return this;
        }

        public final BiPredicate<Integer, ItemStack> getValidator() {
            return this.validator_;
        }

        public final InventoryRange setMaxStackSize(int count) {
            this.max_stack_size_ = Math.max(count, 1);
            return this;
        }

        public void clearContent() {
            for (int i = 0; i < this.size_; ++i) {
                this.setItem(i, ItemStack.EMPTY);
            }
        }

        public int getContainerSize() {
            return this.size_;
        }

        public boolean isEmpty() {
            for (int i = 0; i < this.size_; ++i) {
                if (this.inventory_.getItem(this.offset_ + i).isEmpty()) continue;
                return false;
            }
            return true;
        }

        public ItemStack getItem(int index) {
            return this.inventory_.getItem(this.offset_ + index);
        }

        public ItemStack removeItem(int index, int count) {
            return this.inventory_.removeItem(this.offset_ + index, count);
        }

        public ItemStack removeItemNoUpdate(int index) {
            return this.inventory_.removeItemNoUpdate(this.offset_ + index);
        }

        public void setItem(int index, ItemStack stack) {
            this.inventory_.setItem(this.offset_ + index, stack);
        }

        public int getMaxStackSize() {
            return Math.min(this.max_stack_size_, this.inventory_.getMaxStackSize());
        }

        public void setChanged() {
            this.inventory_.setChanged();
        }

        public boolean stillValid(Player player) {
            return this.inventory_.stillValid(player);
        }

        public void startOpen(Player player) {
            this.inventory_.startOpen(player);
        }

        public void stopOpen(Player player) {
            this.inventory_.stopOpen(player);
        }

        public boolean canPlaceItem(int index, ItemStack stack) {
            return this.validator_.test(this.offset_ + index, stack) && this.inventory_.canPlaceItem(this.offset_ + index, stack);
        }

        public boolean iterate(BiPredicate<Integer, ItemStack> fn) {
            for (int i = 0; i < this.size_; ++i) {
                if (!fn.test(i, this.getItem(i))) continue;
                return true;
            }
            return false;
        }

        public boolean contains(ItemStack stack) {
            for (int i = 0; i < this.size_; ++i) {
                if (!Inventories.areItemStacksIdentical(stack, this.getItem(i))) continue;
                return true;
            }
            return false;
        }

        public int indexOf(ItemStack stack) {
            for (int i = 0; i < this.size_; ++i) {
                if (!Inventories.areItemStacksIdentical(stack, this.getItem(i))) continue;
                return i;
            }
            return -1;
        }

        public <T> Optional<T> find(BiFunction<Integer, ItemStack, Optional<T>> fn) {
            for (int i = 0; i < this.size_; ++i) {
                Optional<T> r = fn.apply(i, this.getItem(i));
                if (!r.isPresent()) continue;
                return r;
            }
            return Optional.empty();
        }

        public <T> List<T> collect(BiFunction<Integer, ItemStack, Optional<T>> fn) {
            ArrayList data = new ArrayList();
            for (int i = 0; i < this.size_; ++i) {
                fn.apply(i, this.getItem(i)).ifPresent(data::add);
            }
            return data;
        }

        public Stream<ItemStack> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public Iterator<ItemStack> iterator() {
            return new InventoryRangeIterator(this);
        }

        public int stackMatchCount(ItemStack ref_stack) {
            int n = 0;
            for (int i = 0; i < this.size_; ++i) {
                if (!Inventories.areItemStacksIdentical(ref_stack, this.getItem(i))) continue;
                ++n;
            }
            return n;
        }

        public int totalMatchingItemCount(ItemStack ref_stack) {
            int n = 0;
            for (int i = 0; i < this.size_; ++i) {
                ItemStack stack = this.getItem(i);
                if (!Inventories.areItemStacksIdentical(ref_stack, stack)) continue;
                n += stack.getCount();
            }
            return n;
        }

        public ItemStack insert(ItemStack input_stack, boolean only_fillup, int limit, boolean reverse, boolean force_group_stacks) {
            int nmax;
            ItemStack stack;
            int sno;
            int i;
            ItemStack mvstack = input_stack.copy();
            if (mvstack.isEmpty()) {
                return Inventories.checked(mvstack);
            }
            int limit_left = limit > 0 ? Math.min(limit, mvstack.getMaxStackSize()) : mvstack.getMaxStackSize();
            boolean[] matches = new boolean[this.size_];
            boolean[] empties = new boolean[this.size_];
            int num_matches = 0;
            for (i = 0; i < this.size_; ++i) {
                sno = reverse ? this.size_ - 1 - i : i;
                stack = this.getItem(sno);
                if (stack.isEmpty()) {
                    empties[sno] = true;
                    continue;
                }
                if (!Inventories.areItemStacksIdentical(stack, mvstack)) continue;
                matches[sno] = true;
                ++num_matches;
            }
            for (i = 0; i < this.size_; ++i) {
                int n = sno = reverse ? this.size_ - 1 - i : i;
                if (empties[sno] || !matches[sno]) continue;
                stack = this.getItem(sno);
                nmax = Math.min(limit_left, stack.getMaxStackSize() - stack.getCount());
                if (mvstack.getCount() <= nmax) {
                    stack.setCount(stack.getCount() + mvstack.getCount());
                    this.setItem(sno, stack);
                    return ItemStack.EMPTY;
                }
                mvstack.shrink(nmax);
                limit_left -= nmax;
                stack.grow(nmax);
                this.setItem(sno, stack);
            }
            if (only_fillup) {
                return Inventories.checked(mvstack);
            }
            if (num_matches > 0 && (force_group_stacks || this.inventory_ instanceof Inventory)) {
                int sno2;
                int i2;
                int insert_start = -1;
                int insert_end = -1;
                for (i2 = 1; i2 < this.size_ - 1; ++i2) {
                    int n = sno2 = reverse ? this.size_ - 1 - i2 : i2;
                    if (insert_start < 0) {
                        if (!matches[sno2]) continue;
                        insert_start = sno2;
                        continue;
                    }
                    if (!matches[sno2]) continue;
                    insert_end = sno2;
                }
                for (i2 = insert_start; i2 < insert_end; ++i2) {
                    int n = sno2 = reverse ? this.size_ - 1 - i2 : i2;
                    if (!empties[sno2] || !this.canPlaceItem(sno2, mvstack)) continue;
                    int nmax2 = Math.min(limit_left, mvstack.getCount());
                    ItemStack moved = mvstack.copy();
                    moved.setCount(nmax2);
                    mvstack.shrink(nmax2);
                    this.setItem(sno2, moved);
                    return Inventories.checked(mvstack);
                }
                for (i = 1; i < this.size_ - 1; ++i) {
                    int ii;
                    int n = sno = reverse ? this.size_ - 1 - i : i;
                    if (!matches[sno]) continue;
                    int n2 = empties[sno - 1] ? sno - 1 : (ii = empties[sno + 1] ? sno + 1 : -1);
                    if (ii < 0 || !this.canPlaceItem(ii, mvstack)) continue;
                    nmax = Math.min(limit_left, mvstack.getCount());
                    ItemStack moved = mvstack.copy();
                    moved.setCount(nmax);
                    mvstack.shrink(nmax);
                    this.setItem(ii, moved);
                    return Inventories.checked(mvstack);
                }
            }
            for (i = 0; i < this.size_; ++i) {
                int n = sno = reverse ? this.size_ - 1 - i : i;
                if (!empties[sno] || !this.canPlaceItem(sno, mvstack)) continue;
                int nmax3 = Math.min(limit_left, mvstack.getCount());
                ItemStack placed = mvstack.copy();
                placed.setCount(nmax3);
                mvstack.shrink(nmax3);
                this.setItem(sno, placed);
                return Inventories.checked(mvstack);
            }
            return Inventories.checked(mvstack);
        }

        public ItemStack insert(ItemStack input_stack, boolean simulate) {
            if (input_stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (!simulate) {
                return this.insert(input_stack);
            }
            input_stack = input_stack.copy();
            for (ItemStack stack : this) {
                if (stack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                int nleft = stack.getCount() - stack.getMaxStackSize();
                if (nleft <= 0 || !Inventories.isItemStackableOn(stack, input_stack)) continue;
                if (nleft >= input_stack.getCount()) {
                    return ItemStack.EMPTY;
                }
                input_stack.shrink(nleft);
            }
            return input_stack;
        }

        public ItemStack insert(ItemStack stack_to_move) {
            return this.insert(stack_to_move, false, 0, false, true);
        }

        public ItemStack insert(int index, ItemStack stack_to_move) {
            if (stack_to_move.isEmpty()) {
                return stack_to_move;
            }
            ItemStack stack = this.getItem(index);
            int limit = Math.min(this.getMaxStackSize(), stack.getMaxStackSize());
            if (stack.isEmpty()) {
                this.setItem(index, stack_to_move.copy());
                return ItemStack.EMPTY;
            }
            if (stack.getCount() >= limit || !Inventories.areItemStacksIdentical(stack, stack_to_move)) {
                return stack_to_move;
            }
            int amount = Math.min(limit - stack.getCount(), stack_to_move.getCount());
            ItemStack remaining = stack_to_move.copy();
            remaining.shrink(amount);
            stack.grow(amount);
            return remaining.isEmpty() ? ItemStack.EMPTY : remaining;
        }

        public ItemStack extract(int amount) {
            return this.extract(amount, false);
        }

        public ItemStack extract(int amount, boolean random) {
            return this.extract(amount, false, false);
        }

        public ItemStack extract(int amount, boolean random, boolean simulate) {
            ItemStack out_stack = ItemStack.EMPTY;
            int offset = random ? (int)(Math.random() * (double)this.size_) : 0;
            for (int k = 0; k < this.size_; ++k) {
                int i = (offset + k) % this.size_;
                ItemStack stack = this.getItem(i);
                if (stack.isEmpty()) continue;
                if (out_stack.isEmpty()) {
                    if (stack.getCount() < amount) {
                        out_stack = stack;
                        if (!simulate) {
                            this.setItem(i, ItemStack.EMPTY);
                        }
                        if (!out_stack.isStackable()) break;
                        amount -= out_stack.getCount();
                        continue;
                    }
                    if (!simulate) {
                        out_stack = stack.split(amount);
                        break;
                    }
                    out_stack = stack.copy();
                    out_stack.setCount(amount);
                    break;
                }
                if (!Inventories.areItemStacksIdentical(stack, out_stack)) continue;
                if (stack.getCount() <= amount) {
                    out_stack.grow(stack.getCount());
                    amount -= stack.getCount();
                    if (simulate) continue;
                    this.setItem(i, ItemStack.EMPTY);
                    continue;
                }
                out_stack.grow(amount);
                if (simulate) break;
                stack.shrink(amount);
                if (!stack.isEmpty()) break;
                this.setItem(i, ItemStack.EMPTY);
                break;
            }
            if (!out_stack.isEmpty() && !simulate) {
                this.setChanged();
            }
            return out_stack;
        }

        public ItemStack extract(ItemStack request_stack) {
            return this.extract(request_stack, false);
        }

        public ItemStack extract(ItemStack request_stack, boolean simulate) {
            ItemStack stack;
            if (request_stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            ArrayList<ItemStack> matches = new ArrayList<ItemStack>();
            for (int i = 0; i < this.size_; ++i) {
                stack = this.getItem(i);
                if (stack.isEmpty() || !Inventories.areItemStacksIdenticalIgnoreDamage(stack, request_stack)) continue;
                matches.add(stack);
            }
            matches.sort(Comparator.comparingInt(ItemStack::getCount));
            if (matches.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (!simulate) {
                ItemStack stack2;
                int n_left = request_stack.getCount();
                ItemStack fetched_stack = ((ItemStack)matches.get(0)).split(n_left);
                n_left -= fetched_stack.getCount();
                for (int i = 1; i < matches.size() && n_left > 0; n_left -= stack2.getCount(), ++i) {
                    stack2 = ((ItemStack)matches.get(i)).split(n_left);
                    fetched_stack.grow(stack2.getCount());
                }
                return Inventories.checked(fetched_stack);
            }
            int amount = 0;
            for (ItemStack match : matches) {
                amount += match.getCount();
            }
            if (amount == 0) {
                return ItemStack.EMPTY;
            }
            stack = request_stack.copy();
            if (amount < stack.getCount()) {
                stack.setCount(amount);
            }
            return stack;
        }

        public boolean move(int index, InventoryRange target_range, boolean all_identical_stacks, boolean only_fillup, boolean reverse, boolean force_group_stacks) {
            ItemStack source_stack = this.getItem(index);
            if (source_stack.isEmpty()) {
                return false;
            }
            if (!all_identical_stacks) {
                ItemStack remaining = target_range.insert(source_stack, only_fillup, 0, reverse, force_group_stacks);
                this.setItem(index, remaining);
                return remaining.getCount() != source_stack.getCount();
            }
            ItemStack remaining = source_stack.copy();
            this.setItem(index, ItemStack.EMPTY);
            ItemStack ref_stack = remaining.copy();
            ref_stack.setCount(ref_stack.getMaxStackSize());
            for (int i = this.size_; i > 0 && !remaining.isEmpty() && (remaining = target_range.insert(remaining, only_fillup, 0, reverse, force_group_stacks)).isEmpty(); --i) {
                remaining = this.extract(ref_stack);
            }
            if (!remaining.isEmpty()) {
                this.setItem(index, remaining);
            }
            return remaining.getCount() != source_stack.getCount();
        }

        public boolean move(int index, InventoryRange target_range) {
            return this.move(index, target_range, false, false, false, true);
        }

        public boolean move(InventoryRange target_range, boolean only_fillup, boolean reverse, boolean force_group_stacks) {
            boolean changed = false;
            for (int i = 0; i < this.size_; ++i) {
                changed |= this.move(i, target_range, false, only_fillup, reverse, force_group_stacks);
            }
            return changed;
        }

        public boolean move(InventoryRange target_range, boolean only_fillup) {
            return this.move(target_range, only_fillup, false, true);
        }

        public boolean move(InventoryRange target_range) {
            return this.move(target_range, false, false, true);
        }

        public static class InventoryRangeIterator
        implements Iterator<ItemStack> {
            private final InventoryRange parent_;
            private int index = 0;

            public InventoryRangeIterator(InventoryRange range) {
                this.parent_ = range;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.parent_.size_;
            }

            @Override
            public ItemStack next() {
                if (this.index >= this.parent_.size_) {
                    throw new NoSuchElementException();
                }
                return this.parent_.getItem(this.index++);
            }
        }
    }
}

