/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import wile.redstonepen.libmc.Auxiliaries;

public class ExtendedShapelessRecipe
implements CraftingRecipe {
    private final String group;
    private final CraftingBookCategory category;
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients;
    private final CompoundTag aspects;
    public static final Serializer SERIALIZER = new Serializer();

    public ExtendedShapelessRecipe(String group, CraftingBookCategory cat, ItemStack output, NonNullList<Ingredient> ingredients, CompoundTag aspects) {
        this.group = group;
        this.category = cat;
        this.result = output;
        this.ingredients = ingredients;
        this.aspects = aspects;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public String getGroup() {
        return this.group;
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    public CompoundTag getAspects() {
        return this.aspects.copy();
    }

    public boolean isSpecial() {
        return this.isRepair() || this.aspects.getBoolean("dynamic");
    }

    public ItemStack getResultItem(HolderLookup.Provider ra) {
        return this.isSpecial() ? ItemStack.EMPTY : this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= this.ingredients.size();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        if (this.isRepair()) {
            NonNullList remaining = (NonNullList)this.getRepaired(inv).getB();
            for (int i = 0; i < remaining.size(); ++i) {
                ItemStack rem_stack = (ItemStack)remaining.get(i);
                ItemStack inv_stack = inv.getItem(i);
                if (inv_stack.isEmpty() || !rem_stack.isEmpty() && !inv.getItem(i).is(rem_stack.getItem())) continue;
                remaining.set(i, (Object)ItemStack.EMPTY);
                if (!rem_stack.isEmpty()) {
                    rem_stack.grow(1);
                }
                inv_stack.setCount(rem_stack.getCount());
            }
            return remaining;
        }
        String tool_name = this.aspects.getString("tool");
        int tool_damage = this.getToolDamage();
        NonNullList remaining = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (Auxiliaries.getResourceLocation(stack.getItem()).toString().equals(tool_name)) {
                if (!stack.isDamageableItem()) {
                    remaining.set(i, (Object)stack);
                    continue;
                }
                ItemStack rstack = stack.copy();
                rstack.setDamageValue(rstack.getDamageValue() + tool_damage);
                if (rstack.getDamageValue() >= rstack.getMaxDamage()) continue;
                remaining.set(i, (Object)rstack);
                continue;
            }
            if (!stack.getItem().hasCraftingRemainingItem()) continue;
            remaining.set(i, (Object)new ItemStack((ItemLike)stack.getItem().getCraftingRemainingItem(), stack.getCount()));
        }
        return remaining;
    }

    public boolean matches(CraftingInput input, Level world) {
        StackedContents stacked = new StackedContents();
        int i = 0;
        for (int j = 0; j < input.size(); ++j) {
            ItemStack ingr = input.getItem(j);
            if (ingr.isEmpty()) continue;
            stacked.accountStack(ingr, 1);
            ++i;
        }
        return i == this.ingredients.size() && stacked.canCraft((Recipe)this, null);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider ra) {
        int dmg;
        if (this.isRepair()) {
            return (ItemStack)this.getRepaired(inv).getA();
        }
        ItemStack rstack = this.result.copy();
        if (rstack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (this.aspects.getInt("initial_durability") > 0) {
            int dmg2 = Math.max(0, rstack.getMaxDamage() - this.aspects.getInt("initial_durability"));
            if (dmg2 > 0) {
                rstack.setDamageValue(dmg2);
            }
        } else if (this.aspects.getInt("initial_damage") > 0 && (dmg = Math.min(this.aspects.getInt("initial_damage"), rstack.getMaxDamage())) > 0) {
            rstack.setDamageValue(dmg);
        }
        return rstack;
    }

    private int getToolDamage() {
        if (this.aspects.contains("tool_repair")) {
            return -Mth.clamp((int)this.aspects.getInt("tool_repair"), (int)0, (int)4096);
        }
        if (this.aspects.contains("tool_damage")) {
            return Mth.clamp((int)this.aspects.getInt("tool_damage"), (int)1, (int)1024);
        }
        return 0;
    }

    private boolean isRepair() {
        return this.getToolDamage() < 0;
    }

    private Tuple<ItemStack, NonNullList<ItemStack>> getRepaired(CraftingInput inv) {
        ItemStack stack;
        int i;
        String tool_name = this.aspects.getString("tool");
        HashMap<Item, Integer> repair_items = new HashMap<Item, Integer>();
        NonNullList remaining = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        ItemStack tool_item = ItemStack.EMPTY;
        for (int i2 = 0; i2 < inv.size(); ++i2) {
            ItemStack stack2 = inv.getItem(i2);
            if (stack2.isEmpty()) continue;
            if (Auxiliaries.getResourceLocation(stack2.getItem()).toString().equals(tool_name)) {
                tool_item = stack2.copy();
                continue;
            }
            remaining.set(i2, (Object)stack2.copy());
            repair_items.put(stack2.getItem(), stack2.getCount() + repair_items.getOrDefault(stack2.getItem(), 0));
        }
        if (tool_item.isEmpty()) {
            return new Tuple((Object)ItemStack.EMPTY, (Object)remaining);
        }
        if (!tool_item.isDamageableItem()) {
            Auxiliaries.logWarn("Repairing '" + String.valueOf(Auxiliaries.getResourceLocation(tool_item.getItem())) + "' can't work, the item is not damageable.");
            return new Tuple((Object)ItemStack.EMPTY, (Object)remaining);
        }
        int dmg = tool_item.getDamageValue();
        if (dmg <= 0 && !this.aspects.getBoolean("over_repair")) {
            return new Tuple((Object)ItemStack.EMPTY, (Object)remaining);
        }
        int min_repair_item_count = repair_items.values().stream().mapToInt(Integer::intValue).min().orElse(0);
        if (min_repair_item_count <= 0) {
            return new Tuple((Object)ItemStack.EMPTY, (Object)remaining);
        }
        int single_repair_dur = this.aspects.getBoolean("relative_repair_damage") ? Math.max(1, -this.getToolDamage() * tool_item.getMaxDamage() / 100) : Math.max(1, -this.getToolDamage());
        int num_repairs = dmg / single_repair_dur;
        if (num_repairs * single_repair_dur < dmg) {
            ++num_repairs;
        }
        num_repairs = Math.min(num_repairs, min_repair_item_count);
        for (Item ki : repair_items.keySet()) {
            repair_items.put(ki, num_repairs);
        }
        tool_item.setDamageValue(Math.max(dmg - single_repair_dur * num_repairs, 0));
        for (i = 0; i < remaining.size(); ++i) {
            stack = inv.getItem(i);
            if (stack.isEmpty() || Auxiliaries.getResourceLocation(stack.getItem()).toString().equals(tool_name)) continue;
            remaining.set(i, (Object)(stack.getItem().hasCraftingRemainingItem() ? new ItemStack((ItemLike)stack.getItem().getCraftingRemainingItem(), stack.getCount()) : stack.copy()));
        }
        for (i = 0; i < remaining.size(); ++i) {
            stack = (ItemStack)remaining.get(i);
            Item item = stack.getItem();
            if (!repair_items.containsKey(item)) continue;
            int n = (Integer)repair_items.get(item);
            if (stack.getCount() >= n) {
                stack.shrink(n);
                repair_items.remove(item);
                continue;
            }
            repair_items.put(item, n - stack.getCount());
            remaining.set(i, (Object)ItemStack.EMPTY);
        }
        if (tool_item.getItem() instanceof IRepairableToolItem) {
            tool_item = ((IRepairableToolItem)tool_item.getItem()).onShapelessRecipeRepaired(tool_item, dmg, tool_item.getDamageValue());
        }
        return new Tuple((Object)tool_item, (Object)remaining);
    }

    public static class Serializer
    implements RecipeSerializer<ExtendedShapelessRecipe> {
        private static final MapCodec<ExtendedShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(r -> r.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(r -> r.category), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (Ingredient[])list.stream().filter(ing -> !ing.isEmpty()).toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "no ingredients");
            }
            if (ingredients.length > 9) {
                return DataResult.error(() -> "too many ingredients");
            }
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(r -> r.ingredients), (App)CompoundTag.CODEC.optionalFieldOf("aspects", (Object)new CompoundTag()).forGetter(r -> r.aspects)).apply((Applicative)instance, ExtendedShapelessRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ExtendedShapelessRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ExtendedShapelessRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ExtendedShapelessRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ExtendedShapelessRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            String group = buf.readUtf();
            CraftingBookCategory cat = (CraftingBookCategory)buf.readEnum(CraftingBookCategory.class);
            int size = buf.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            ingredients.replaceAll(ingr -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
            ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            CompoundTag aspects = buf.readNbt();
            return new ExtendedShapelessRecipe(group, cat, stack, (NonNullList<Ingredient>)ingredients, aspects);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, ExtendedShapelessRecipe recipe) {
            buf.writeUtf(recipe.group);
            buf.writeEnum((Enum)recipe.category);
            buf.writeVarInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
            buf.writeNbt((Tag)recipe.getAspects());
        }
    }

    public static interface IRepairableToolItem {
        public ItemStack onShapelessRecipeRepaired(ItemStack var1, int var2, int var3);
    }
}

