/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import wile.redstonepen.libmc.Auxiliaries;

public class BasicLever {

    public static class BasicLeverBlock
    extends LeverBlock {
        public final Config config;

        public BasicLeverBlock(Config conf, BlockBehaviour.Properties properties) {
            super(properties);
            this.config = conf;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
            Auxiliaries.Tooltip.addInformation(stack, ctx, tooltip, flag, true);
        }

        public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult brh) {
            if (world.isClientSide) {
                BlockState new_state = (BlockState)state.cycle((Property)POWERED);
                if (((Boolean)new_state.getValue((Property)POWERED)).booleanValue()) {
                    BasicLeverBlock.makeParticle(new_state, (LevelAccessor)world, pos, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            BlockState new_state = (BlockState)state.cycle((Property)POWERED);
            world.setBlock(pos, new_state, 3);
            world.updateNeighborsAt(pos, (Block)this);
            world.updateNeighborsAt(pos.relative(LeverBlock.getConnectedDirection((BlockState)new_state).getOpposite()), (Block)this);
            world.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, (Boolean)new_state.getValue((Property)POWERED) != false ? this.config.sound_pitch_powered() : this.config.sound_pitch_unpowered());
            world.gameEvent((Entity)player, (Holder)((Boolean)new_state.getValue((Property)POWERED) != false ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), pos);
            return InteractionResult.CONSUME;
        }

        private static void makeParticle(BlockState state, LevelAccessor world, BlockPos pos, float f) {
            for (int i = 0; i < 2; ++i) {
                Vec3 vpos = Vec3.atCenterOf((Vec3i)pos).add(Vec3.atBottomCenterOf((Vec3i)((Direction)state.getValue((Property)FACING)).getOpposite().getNormal()).scale(0.1)).add(Vec3.atLowerCornerOf((Vec3i)LeverBlock.getConnectedDirection((BlockState)state).getOpposite().getNormal()).scale(0.2));
                world.addParticle((ParticleOptions)new DustParticleOptions(DustParticleOptions.REDSTONE_PARTICLE_COLOR, f), vpos.x(), vpos.y(), vpos.z(), 0.0, 0.0, 0.0);
            }
        }

        public record Config(float sound_pitch_unpowered, float sound_pitch_powered) {
        }
    }
}

