/*
 * Decompiled with CFR 0.152.
 */
package com.ofekn.crafting_on_a_stick.integration;

import com.ofekn.crafting_on_a_stick.api.Ref;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class COASCurios {
    private static final String MODID = "curios";

    public static boolean hasMod() {
        return ModList.get().isLoaded(MODID);
    }

    public static void getCuriosInventory(Player player, List<Ref<ItemStack>> result) {
        if (COASCurios.hasMod()) {
            Integrator.getCuriosInventory(player, result);
        }
    }

    private static final class Integrator {
        private Integrator() {
        }

        private static void getCuriosInventory(Player player, List<Ref<ItemStack>> result) {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(itemHandler -> {
                for (ICurioStacksHandler stackHandler : itemHandler.getCurios().values()) {
                    IDynamicStackHandler stacks = stackHandler.getStacks();
                    Ref.forEveryIndex(arg_0 -> ((IDynamicStackHandler)stacks).getStackInSlot(arg_0), (arg_0, arg_1) -> ((IDynamicStackHandler)stacks).setStackInSlot(arg_0, arg_1), stacks.getSlots(), result);
                }
            });
        }
    }
}

