/*
 * Decompiled with CFR 0.152.
 */
package com.ofekn.crafting_on_a_stick.client;

import com.ofekn.crafting_on_a_stick.client.WheelLayoutSupplier;
import com.ofekn.crafting_on_a_stick.client.WheelPolygon;
import org.joml.Math;
import org.joml.Vector2f;

public enum RoundWheelLayout implements WheelLayoutSupplier
{
    INSTANCE;

    private static final float GAP = 2.0f;
    private static final float R1 = 32.0f;
    private static final float R3 = 64.0f;
    private static final float R0 = 28.0f;
    private static final float R2 = 48.0f;
    private static final int N_CENTRAL_POINTS = 360;
    private static final int N_HALF_AROUND_POINTS = 360;

    @Override
    public WheelPolygon[] apply(int numOptions) {
        if (numOptions == 0) {
            return new WheelPolygon[0];
        }
        int numAround = numOptions - 1;
        WheelPolygon[] result = new WheelPolygon[numOptions];
        result[0] = RoundWheelLayout.createCenter();
        for (int index = 0; index < numAround; ++index) {
            result[index + 1] = RoundWheelLayout.createAround(index, numAround);
        }
        return result;
    }

    private static WheelPolygon createCenter() {
        Vector2f[] firstPoints = new Vector2f[360];
        for (int i = 0; i < 360; ++i) {
            firstPoints[i] = RoundWheelLayout.angleDistance((float)(-i) / 360.0f, 28.0f);
        }
        return new WheelPolygon(firstPoints, new Vector2f(0.0f, 0.0f));
    }

    private static WheelPolygon createAround(int index, int numAround) {
        float gap1 = numAround == 1 ? 0.0f : Math.asin((float)0.0625f) / ((float)java.lang.Math.PI * 2);
        float gap3 = numAround == 1 ? 0.0f : Math.asin((float)0.03125f) / ((float)java.lang.Math.PI * 2);
        float alpha1 = ((float)index - 0.5f) / (float)numAround + gap1;
        float beta1 = ((float)index + 0.5f) / (float)numAround - gap1;
        float alpha3 = ((float)index - 0.5f) / (float)numAround + gap3;
        float beta3 = ((float)index + 0.5f) / (float)numAround - gap3;
        Vector2f[] polygonPoints = new Vector2f[720];
        for (int j = 0; j < 360; ++j) {
            float t = (float)j / 359.0f;
            polygonPoints[j] = RoundWheelLayout.angleDistance(Math.lerp((float)alpha1, (float)beta1, (float)t), 32.0f);
            polygonPoints[polygonPoints.length - j - 1] = RoundWheelLayout.angleDistance(Math.lerp((float)alpha3, (float)beta3, (float)t), 64.0f);
        }
        Vector2f center = RoundWheelLayout.angleDistance((float)index / (float)numAround, 48.0f);
        return new WheelPolygon(polygonPoints, center);
    }

    private static Vector2f angleDistance(float angleRatio, float distance) {
        float rad = (float)java.lang.Math.PI * 2 * angleRatio;
        float dx = Math.sin((float)rad);
        float dy = -Math.cos((float)rad);
        return new Vector2f(distance * dx, distance * dy);
    }

    public String getSerializedName() {
        return "round";
    }
}

