/*
 * Decompiled with CFR 0.152.
 */
package com.ofekn.crafting_on_a_stick;

import com.ofekn.crafting_on_a_stick.EntityContainerLevelAccess;
import com.ofekn.crafting_on_a_stick.MinecraftMenuBuilder;
import com.ofekn.crafting_on_a_stick.api.IWheelItem;
import com.ofekn.crafting_on_a_stick.api.Ref;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemOnAStick
extends Item
implements IWheelItem {
    private static final Item.Properties PROP = new Item.Properties().stacksTo(1);
    private final String registryPath;
    private final MenuProvider menuProvider;

    public ItemOnAStick(String registryPath, String containerName, MinecraftMenuBuilder builder) {
        super(PROP);
        this.registryPath = registryPath;
        this.menuProvider = new SimpleMenuProvider((id, inv, player) -> builder.create(id, inv, new EntityContainerLevelAccess((Entity)player)), (Component)Component.translatable((String)("container." + containerName)));
    }

    private MenuProvider createMenuProviderWrapper(final @Nullable ItemContainerContents contents) {
        if (contents == null) {
            return this.menuProvider;
        }
        return new MenuProvider(){

            public Component getDisplayName() {
                return ItemOnAStick.this.menuProvider.getDisplayName();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
                AbstractContainerMenu result = ItemOnAStick.this.menuProvider.createMenu(containerId, playerInventory, player);
                if (result == null) {
                    return null;
                }
                for (int i = 0; i < contents.getSlots(); ++i) {
                    if (!result.isValidSlotIndex(i)) continue;
                    result.setItem(i, 0, contents.getStackInSlot(i));
                }
                return result;
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return ItemOnAStick.this.menuProvider.shouldTriggerClientSideContainerClosingOnOpen();
            }
        };
    }

    public ItemStack openContainer(Player player, ItemStack stack) {
        ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        stack = stack.copy();
        stack.remove(DataComponents.CONTAINER);
        player.openMenu(this.createMenuProviderWrapper(contents));
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.success((Object)this.openContainer(player, stack));
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId(stack), (Object[])new Object[]{Component.translatable((String)"gui.crafting_on_a_stick.prefix"), Component.translatable((String)("block.minecraft." + this.registryPath)), Component.translatable((String)"gui.crafting_on_a_stick.suffix")});
    }

    @Override
    public void onWheelAction(Player player, Ref<ItemStack> stackRef) {
        stackRef.set(this.openContainer(player, stackRef.get()));
    }
}

