/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.blockentities;

import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.items.components.DimStorageComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockEntityFrequencyOwner
extends BlockEntity
implements MenuProvider {
    private Frequency frequency = new Frequency();
    private boolean locked = false;
    private int changeCount;

    public BlockEntityFrequencyOwner(BlockEntityType<? extends BlockEntityFrequencyOwner> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BlockEntityFrequencyOwner blockentity) {
        if (blockentity.getStorage().getChangeCount() > blockentity.changeCount) {
            level.updateNeighbourForOutputSignal(blockentity.worldPosition, blockentity.getBlockState().getBlock());
            blockentity.changeCount = blockentity.getStorage().getChangeCount();
        }
        blockentity.onServerTick(level, pos, state);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BlockEntityFrequencyOwner blockentity) {
        blockentity.onClientTick(level, pos, state);
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Frequency frequency) {
        this.frequency = frequency;
        this.invalidateCapabilities();
        this.setChanged();
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
    }

    public void swapOwner(Player player) {
        if (this.frequency.hasOwner()) {
            this.setFrequency(this.frequency.setPublic());
        } else {
            this.setFrequency(this.frequency.setOwner(player));
        }
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.setChanged();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void swapLocked() {
        this.setLocked(!this.locked);
    }

    public boolean canAccess(Player player) {
        return this.frequency.canAccess(player);
    }

    public abstract AbstractDimStorage getStorage();

    public abstract void onServerTick(Level var1, BlockPos var2, BlockState var3);

    public abstract void onClientTick(Level var1, BlockPos var2, BlockState var3);

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.frequency = Frequency.deserializeNBT(tag.getCompound("frequency"));
        this.locked = tag.getBoolean("locked");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("frequency", (Tag)this.frequency.serializeNBT());
        tag.putBoolean("locked", this.locked);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        Frequency frequency = (Frequency)componentInput.get(DimStorageComponents.FREQUENCY);
        if (frequency != null) {
            this.setFrequency(frequency);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(DimStorageComponents.FREQUENCY, (Object)this.frequency);
    }

    public ItemInteractionResult useItemOn(ServerPlayer player, Level level, BlockPos pos, InteractionHand hand) {
        if (this.canAccess((Player)player)) {
            player.openMenu((MenuProvider)this, buf -> buf.writeBlockPos(this.getBlockPos()).writeBoolean(false));
        } else {
            player.displayClientMessage((Component)Component.literal((String)"Access Denied!").withStyle(ChatFormatting.RED), false);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.put("frequency", (Tag)this.frequency.serializeNBT());
        tag.putBoolean("locked", this.locked);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.setFrequency(Frequency.deserializeNBT(tag.getCompound("frequency")));
        this.locked = tag.getBoolean("locked");
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }
}

