/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.util.BytesRef;
import java.util.Objects;

public record TermStatistics(BytesRef term, long docFreq, long totalTermFreq) {
    public TermStatistics {
        Objects.requireNonNull(term);
        if (docFreq <= 0L) {
            throw new IllegalArgumentException("docFreq must be positive, docFreq: " + docFreq);
        }
        if (totalTermFreq <= 0L) {
            throw new IllegalArgumentException("totalTermFreq must be positive, totalTermFreq: " + totalTermFreq);
        }
        if (totalTermFreq < docFreq) {
            throw new IllegalArgumentException("totalTermFreq must be at least docFreq, totalTermFreq: " + totalTermFreq + ", docFreq: " + docFreq);
        }
    }
}

