/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.hunspell;

import guideme.internal.shaded.lucene.analysis.hunspell.FlyweightEntry;
import guideme.internal.shaded.lucene.analysis.hunspell.WordCase;
import guideme.internal.shaded.lucene.analysis.hunspell.WordStorage;
import guideme.internal.shaded.lucene.internal.hppc.IntObjectHashMap;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.CharsRef;
import guideme.internal.shaded.lucene.util.IntsRef;
import java.util.function.Consumer;

class SuggestibleEntryCache {
    private static final short LOWER_CASE = (short)WordCase.LOWER.ordinal();
    private static final short NEUTRAL_CASE = (short)WordCase.NEUTRAL.ordinal();
    private static final short TITLE_CASE = (short)WordCase.TITLE.ordinal();
    private final Section[] sections;

    private SuggestibleEntryCache(IntObjectHashMap<SectionBuilder> builders, int maxLength) {
        this.sections = new Section[maxLength + 1];
        for (int i = 0; i < this.sections.length; ++i) {
            SectionBuilder builder = builders.get(i);
            this.sections[i] = builder == null ? null : builder.build(i);
        }
    }

    static SuggestibleEntryCache buildCache(WordStorage storage) {
        var consumer = new Consumer<FlyweightEntry>(){
            final IntObjectHashMap<SectionBuilder> builders = new IntObjectHashMap();
            int maxLength;

            @Override
            public void accept(FlyweightEntry entry) {
                SectionBuilder builder;
                int index;
                CharsRef root = entry.root();
                if (root.length > Short.MAX_VALUE) {
                    throw new UnsupportedOperationException("Too long dictionary entry, please report this to dev@lucene.apache.org");
                }
                if (root.length > this.maxLength) {
                    this.maxLength = root.length;
                }
                if ((index = this.builders.indexOf(root.length)) < 0) {
                    builder = new SectionBuilder();
                    this.builders.indexInsert(index, root.length, builder);
                } else {
                    builder = this.builders.indexGet(index);
                }
                builder.add(entry);
            }
        };
        storage.processSuggestibleWords(1, Integer.MAX_VALUE, consumer);
        return new SuggestibleEntryCache(consumer.builders, consumer.maxLength);
    }

    private static boolean hasUpperCase(short rootCase) {
        return rootCase != LOWER_CASE && rootCase != NEUTRAL_CASE;
    }

    void processSuggestibleWords(int minLength, int maxLength, Consumer<FlyweightEntry> processor) {
        maxLength = Math.min(maxLength, this.sections.length - 1);
        for (int i = Math.min(minLength, this.sections.length); i <= maxLength; ++i) {
            Section section = this.sections[i];
            if (section == null) continue;
            section.processWords(processor);
        }
    }

    private record Section(int rootLength, short[] meta, char[] roots, char[] lowRoots, int[] formData) {
        void processWords(Consumer<FlyweightEntry> processor) {
            final CharsRef chars = new CharsRef(this.roots, 0, Math.min(this.rootLength, this.roots.length));
            final CharsRef lowerChars = new CharsRef(this.lowRoots, 0, this.rootLength);
            final IntsRef forms = new IntsRef(this.formData, 0, 0);
            var entry = new FlyweightEntry(this){
                short wordCase;

                @Override
                CharsRef root() {
                    return SuggestibleEntryCache.hasUpperCase(this.wordCase) ? chars : lowerChars;
                }

                @Override
                boolean hasTitleCase() {
                    return this.wordCase == TITLE_CASE;
                }

                @Override
                CharSequence lowerCaseRoot() {
                    return lowerChars;
                }

                @Override
                IntsRef forms() {
                    return forms;
                }
            };
            for (int i = 0; i < this.meta.length; i += 2) {
                int formDataLength = this.meta[i];
                short wordCase = this.meta[i + 1];
                forms.length = formDataLength;
                entry.wordCase = wordCase;
                processor.accept(entry);
                lowerChars.offset += this.rootLength;
                if (SuggestibleEntryCache.hasUpperCase(wordCase)) {
                    chars.offset += this.rootLength;
                }
                forms.offset += formDataLength;
            }
        }
    }

    private static class SectionBuilder {
        final StringBuilder roots = new StringBuilder();
        final StringBuilder lowRoots = new StringBuilder();
        short[] meta = new short[10];
        int[] formData = new int[10];
        int metaOffset;
        int formDataOffset;

        private SectionBuilder() {
        }

        void add(FlyweightEntry entry) {
            CharsRef root = entry.root();
            if (root.length > Short.MAX_VALUE) {
                throw new UnsupportedOperationException("Too long dictionary entry, please report this to dev@lucene.apache.org");
            }
            IntsRef forms = entry.forms();
            short rootCase = (short)WordCase.caseOf(root).ordinal();
            this.meta = ArrayUtil.grow(this.meta, this.metaOffset + 2);
            this.meta[this.metaOffset] = (short)forms.length;
            this.meta[this.metaOffset + 1] = rootCase;
            this.metaOffset += 2;
            this.lowRoots.append(entry.lowerCaseRoot());
            if (SuggestibleEntryCache.hasUpperCase(rootCase)) {
                this.roots.append(root.chars, root.offset, root.length);
            }
            this.formData = ArrayUtil.grow(this.formData, this.formDataOffset + forms.length);
            System.arraycopy(forms.ints, forms.offset, this.formData, this.formDataOffset, forms.length);
            this.formDataOffset += forms.length;
        }

        Section build(int rootLength) {
            return new Section(rootLength, ArrayUtil.copyOfSubArray(this.meta, 0, this.metaOffset), this.roots.toString().toCharArray(), this.lowRoots.toString().toCharArray(), ArrayUtil.copyOfSubArray(this.formData, 0, this.formDataOffset));
        }
    }
}

