/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.BlockImpl;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.reg.IColorProvidingBlock;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;

public class BlockGoldPowder
extends BlockImpl
implements IColorProvidingBlock,
ICustomBlockState,
ICustomItemModel {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.NORTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.EAST_REDSTONE;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.SOUTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.WEST_REDSTONE;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), Block.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)13.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)};

    public BlockGoldPowder() {
        super("gold_powder", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_WIRE));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, (Comparable)RedstoneSide.NONE)).setValue(EAST, (Comparable)RedstoneSide.NONE)).setValue(SOUTH, (Comparable)RedstoneSide.NONE)).setValue(WEST, (Comparable)RedstoneSide.NONE));
    }

    private static int getShapeIndex(BlockState state) {
        boolean w;
        int i = 0;
        boolean n = state.getValue(NORTH) != RedstoneSide.NONE;
        boolean e = state.getValue(EAST) != RedstoneSide.NONE;
        boolean s = state.getValue(SOUTH) != RedstoneSide.NONE;
        boolean bl = w = state.getValue(WEST) != RedstoneSide.NONE;
        if (n || s && !n && !e && !w) {
            i |= 1 << Direction.NORTH.get2DDataValue();
        }
        if (e || w && !n && !e && !s) {
            i |= 1 << Direction.EAST.get2DDataValue();
        }
        if (s || n && !e && !s && !w) {
            i |= 1 << Direction.SOUTH.get2DDataValue();
        }
        if (w || e && !n && !s && !w) {
            i |= 1 << Direction.WEST.get2DDataValue();
        }
        return i;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST});
    }

    @Override
    public BlockColor getBlockColor() {
        return (state, levelIn, pos, tintIndex) -> 16042818;
    }

    public VoxelShape getShape(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return SHAPES[BlockGoldPowder.getShapeIndex(state)];
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level iblockreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(WEST, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.WEST))).setValue(EAST, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.EAST))).setValue(NORTH, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.NORTH))).setValue(SOUTH, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.SOUTH));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor levelIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        return facing == Direction.UP ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.setValue(WEST, (Comparable)this.getSide((BlockGetter)levelIn, currentPos, Direction.WEST))).setValue(EAST, (Comparable)this.getSide((BlockGetter)levelIn, currentPos, Direction.EAST))).setValue(NORTH, (Comparable)this.getSide((BlockGetter)levelIn, currentPos, Direction.NORTH))).setValue(SOUTH, (Comparable)this.getSide((BlockGetter)levelIn, currentPos, Direction.SOUTH)) : (BlockState)stateIn.setValue((Property)RedStoneWireBlock.PROPERTY_BY_DIRECTION.get(facing), (Comparable)this.getSide((BlockGetter)levelIn, currentPos, facing));
    }

    private RedstoneSide getSide(BlockGetter levelIn, BlockPos pos, Direction face) {
        BlockPos blockpos = pos.relative(face);
        BlockState blockstate = levelIn.getBlockState(blockpos);
        BlockPos blockpos1 = pos.above();
        BlockState blockstate1 = levelIn.getBlockState(blockpos1);
        if (!blockstate1.isCollisionShapeFullBlock(levelIn, blockpos1)) {
            boolean flag;
            boolean bl = flag = blockstate.isFaceSturdy(levelIn, blockpos, Direction.UP) || blockstate.getBlock() == Blocks.HOPPER;
            if (flag && this.canConnectTo(levelIn.getBlockState(blockpos.above()))) {
                if (blockstate.isCollisionShapeFullBlock(levelIn, blockpos)) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        return !this.canConnectTo(blockstate) && (blockstate.isCollisionShapeFullBlock(levelIn, blockpos) || !this.canConnectTo(levelIn.getBlockState(blockpos.below()))) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    protected boolean canConnectTo(BlockState blockState) {
        Block block = blockState.getBlock();
        return block == this;
    }

    public boolean canSurvive(BlockState state, LevelReader levelIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = levelIn.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)levelIn, blockpos, Direction.UP) || blockstate.getBlock() == Blocks.HOPPER;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public void onPlace(BlockState state, Level levelIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.getBlock() != state.getBlock() && !levelIn.isClientSide) {
            for (Direction direction : Direction.Plane.VERTICAL) {
                levelIn.updateNeighborsAt(pos.relative(direction), (Block)this);
            }
            for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(levelIn, pos.relative(direction1));
            }
            for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.relative(direction2);
                if (levelIn.getBlockState(blockpos).isCollisionShapeFullBlock((BlockGetter)levelIn, blockpos)) {
                    this.notifyWireNeighborsOfStateChange(levelIn, blockpos.above());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(levelIn, blockpos.below());
            }
        }
    }

    public void onRemove(BlockState state, Level levelIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.getBlock() != newState.getBlock()) {
            super.onRemove(state, levelIn, pos, newState, isMoving);
            if (!levelIn.isClientSide) {
                for (Direction direction : Direction.values()) {
                    levelIn.updateNeighborsAt(pos.relative(direction), (Block)this);
                }
                for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                    this.notifyWireNeighborsOfStateChange(levelIn, pos.relative(direction1));
                }
                for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                    BlockPos blockpos = pos.relative(direction2);
                    if (levelIn.getBlockState(blockpos).isCollisionShapeFullBlock((BlockGetter)levelIn, blockpos)) {
                        this.notifyWireNeighborsOfStateChange(levelIn, blockpos.above());
                        continue;
                    }
                    this.notifyWireNeighborsOfStateChange(levelIn, blockpos.below());
                }
            }
        }
    }

    public void neighborChanged(BlockState state, Level levelIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!levelIn.isClientSide && !state.canSurvive((LevelReader)levelIn, pos)) {
            Block.dropResources((BlockState)state, (Level)levelIn, (BlockPos)pos);
            levelIn.removeBlock(pos, false);
        }
    }

    public void updateIndirectNeighbourShapes(BlockState state, LevelAccessor levelIn, BlockPos pos, int flags, int recursionLeft) {
        BlockPos.MutableBlockPos pool = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.getValue((Property)RedStoneWireBlock.PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == RedstoneSide.NONE || levelIn.getBlockState((BlockPos)pool.set((Vec3i)pos).move(direction)).getBlock() == this) continue;
            pool.move(Direction.DOWN);
            BlockState blockstate = levelIn.getBlockState((BlockPos)pool);
            if (blockstate.getBlock() != Blocks.OBSERVER) {
                BlockPos blockpos = pool.relative(direction.getOpposite());
                BlockState blockstate1 = blockstate.updateShape(direction.getOpposite(), levelIn.getBlockState(blockpos), levelIn, (BlockPos)pool, blockpos);
                Block.updateOrDestroy((BlockState)blockstate, (BlockState)blockstate1, (LevelAccessor)levelIn, (BlockPos)pool, (int)flags);
            }
            pool.set((Vec3i)pos).move(direction).move(Direction.UP);
            BlockState blockstate3 = levelIn.getBlockState((BlockPos)pool);
            if (blockstate3.getBlock() == Blocks.OBSERVER) continue;
            BlockPos blockpos1 = pool.relative(direction.getOpposite());
            BlockState blockstate2 = blockstate3.updateShape(direction.getOpposite(), levelIn.getBlockState(blockpos1), levelIn, (BlockPos)pool, blockpos1);
            Block.updateOrDestroy((BlockState)blockstate3, (BlockState)blockstate2, (LevelAccessor)levelIn, (BlockPos)pool, (int)flags);
        }
    }

    private void notifyWireNeighborsOfStateChange(Level levelIn, BlockPos pos) {
        if (levelIn.getBlockState(pos).getBlock() == this) {
            levelIn.updateNeighborsAt(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                levelIn.updateNeighborsAt(pos.relative(direction), (Block)this);
            }
        }
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/generated")).texture("layer0", "item/" + this.getBaseName());
    }
}

