/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.util;

import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidStackKey {
    public final Holder<Fluid> fluid;
    public final DataComponentPatch dataComponents;
    private final int hash;

    public FluidStackKey(FluidStack stack, boolean compareNBT) {
        this.fluid = stack.getFluidHolder();
        this.dataComponents = compareNBT ? stack.getComponentsPatch() : DataComponentPatch.EMPTY;
        this.hash = Objects.hash(this.fluid, this.dataComponents);
    }

    public FluidStack getStack() {
        return new FluidStack(this.fluid, 1, this.dataComponents);
    }

    public FluidStack getStack(int amt) {
        return new FluidStack(this.fluid, amt, this.dataComponents);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FluidStackKey) {
            return ((FluidStackKey)obj).fluid == this.fluid && Objects.equals(((FluidStackKey)obj).dataComponents, this.dataComponents);
        }
        return false;
    }
}

