/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items;

import com.direwolf20.laserio.common.blockentities.LaserConnectorAdvBE;
import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.common.blocks.baseblocks.BaseLaserBlock;
import com.direwolf20.laserio.setup.LaserIODataComponents;
import com.direwolf20.laserio.util.MiscTools;
import com.direwolf20.laserio.util.VectorHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

public class LaserWrench
extends Item {
    public static int maxDistance = 8;

    public LaserWrench() {
        super(new Item.Properties().stacksTo(1));
    }

    public static GlobalPos storeConnectionPos(ItemStack wrench, Level level, BlockPos pos) {
        GlobalPos globalPos = new GlobalPos(level.dimension(), pos);
        wrench.set(LaserIODataComponents.BOUND_GLOBAL_POS, (Object)globalPos);
        return globalPos;
    }

    public static GlobalPos getConnectionPos(ItemStack wrench, Level level) {
        if (level == null) {
            return null;
        }
        if (!wrench.has(LaserIODataComponents.BOUND_GLOBAL_POS)) {
            return LaserWrench.storeConnectionPos(wrench, level, BlockPos.ZERO);
        }
        return (GlobalPos)wrench.get(LaserIODataComponents.BOUND_GLOBAL_POS);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack wrench = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return InteractionResultHolder.success((Object)wrench);
        }
        int range = 10;
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, ClipContext.Fluid.NONE, range);
        if ((lookingAt == null || !(level.getBlockState(VectorHelper.getLookingAt(player, wrench, range).getBlockPos()).getBlock() instanceof BaseLaserBlock)) && player.isShiftKeyDown()) {
            LaserWrench.storeConnectionPos(wrench, level, BlockPos.ZERO);
            return InteractionResultHolder.pass((Object)wrench);
        }
        BlockPos targetPos = lookingAt.getBlockPos();
        BlockEntity targetBE = level.getBlockEntity(targetPos);
        if (!(targetBE instanceof BaseLaserBE)) {
            return InteractionResultHolder.pass((Object)wrench);
        }
        if (player.isShiftKeyDown()) {
            if (targetPos.equals((Object)LaserWrench.getConnectionPos(wrench, level))) {
                LaserWrench.storeConnectionPos(wrench, level, BlockPos.ZERO);
                return InteractionResultHolder.pass((Object)wrench);
            }
            LaserWrench.storeConnectionPos(wrench, level, targetPos);
            return InteractionResultHolder.pass((Object)wrench);
        }
        GlobalPos sourceDimPos = LaserWrench.getConnectionPos(wrench, level);
        BlockEntity sourceBE = MiscTools.getLevel(level.getServer(), sourceDimPos).getBlockEntity(sourceDimPos.pos());
        if (!(sourceBE instanceof BaseLaserBE)) {
            LaserWrench.storeConnectionPos(wrench, level, BlockPos.ZERO);
            return InteractionResultHolder.pass((Object)wrench);
        }
        if (targetBE instanceof LaserConnectorAdvBE) {
            LaserConnectorAdvBE targetAdv = (LaserConnectorAdvBE)targetBE;
            if (sourceBE instanceof LaserConnectorAdvBE) {
                LaserConnectorAdvBE sourceAdv = (LaserConnectorAdvBE)sourceBE;
                targetAdv.handleAdvancedConnection(sourceAdv);
                return InteractionResultHolder.success((Object)wrench);
            }
        }
        if (!targetPos.closerThan((Vec3i)sourceDimPos.pos(), (double)maxDistance) || !level.equals(MiscTools.getLevel(level.getServer(), sourceDimPos))) {
            player.displayClientMessage((Component)Component.translatable((String)"message.laserio.wrenchrange", (Object[])new Object[]{maxDistance}), true);
            return InteractionResultHolder.pass((Object)wrench);
        }
        ((BaseLaserBE)targetBE).handleConnection((BaseLaserBE)sourceBE);
        return InteractionResultHolder.success((Object)wrench);
    }
}

