/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.LaserGuiGraphics;
import com.direwolf20.laserio.client.screens.LaserGuiGraphicsChemical;
import com.direwolf20.laserio.client.screens.LaserGuiGraphicsFluid;
import com.direwolf20.laserio.client.screens.widgets.ChannelButton;
import com.direwolf20.laserio.client.screens.widgets.NumberButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.containers.customhandler.FilterBasicHandler;
import com.direwolf20.laserio.common.containers.customslot.CardHolderSlot;
import com.direwolf20.laserio.common.containers.customslot.CardItemSlot;
import com.direwolf20.laserio.common.containers.customslot.CardOverclockSlot;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.items.CardHolder;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardItem;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterMod;
import com.direwolf20.laserio.common.items.filters.FilterNBT;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.common.network.data.GhostSlotPayload;
import com.direwolf20.laserio.common.network.data.OpenFilterPayload;
import com.direwolf20.laserio.common.network.data.OpenNodePayload;
import com.direwolf20.laserio.common.network.data.UpdateCardPayload;
import com.direwolf20.laserio.common.network.data.UpdateFilterPayload;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

public class CardItemScreen
extends AbstractContainerScreen<CardItemContainer> {
    private final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/itemcard.png");
    protected final CardItemContainer container;
    protected byte currentMode;
    protected byte currentChannel;
    protected byte currentRedstoneChannel;
    protected byte currentItemExtractAmt;
    protected short currentPriority;
    protected byte currentSneaky;
    protected int currentTicks;
    protected boolean currentExact;
    protected int currentRoundRobin;
    protected boolean currentRegulate;
    protected boolean currentAndMode;
    protected int isAllowList = -1;
    protected int isCompareNBT = -1;
    protected boolean showFilter;
    protected boolean showAllow;
    protected boolean showNBT;
    protected final ItemStack card;
    public ItemStack filter;
    protected Map<String, Button> buttons = new HashMap<String, Button>();
    protected byte currentRedstoneMode;
    protected boolean renderFluids = false;
    protected boolean renderChemicals = false;
    private boolean showCardHolderUI;
    protected final String[] sneakyNames = new String[]{"screen.laserio.default", "screen.laserio.down", "screen.laserio.up", "screen.laserio.north", "screen.laserio.south", "screen.laserio.west", "screen.laserio.east"};

    public CardItemScreen(CardItemContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.card = container.cardItem;
        this.filter = ((Slot)container.slots.get(0)).getItem();
        this.showCardHolderUI = container.cardHolder.isEmpty();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Button andButton;
        Button nbtButton;
        Button allowList;
        Button speedButton;
        Button exact;
        Button redstoneMode;
        Button roundrobin;
        Button regulate;
        Button amountButton;
        Button sneakyButton;
        Button redstoneChannelButton;
        Button channelButton;
        this.validateHolder();
        this.toggleFilterSlots();
        guiGraphics = this.renderChemicals ? new LaserGuiGraphicsChemical(Minecraft.getInstance(), guiGraphics.bufferSource(), this) : (this.renderFluids ? new LaserGuiGraphicsFluid(Minecraft.getInstance(), guiGraphics.bufferSource(), this) : new LaserGuiGraphics(Minecraft.getInstance(), guiGraphics.bufferSource()));
        if (this.showFilter) {
            this.updateItemCounts();
        }
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        Button modeButton = this.buttons.get("mode");
        if (MiscTools.inBounds(modeButton.getX(), modeButton.getY(), modeButton.getWidth(), modeButton.getHeight(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.translatable((String)"screen.laserio.insert"), Component.translatable((String)"screen.laserio.extract"), Component.translatable((String)"screen.laserio.stock"), Component.translatable((String)"screen.laserio.sensor")};
            guiGraphics.renderTooltip(this.font, (Component)translatableComponents[this.currentMode], mouseX, mouseY);
        }
        if (MiscTools.inBounds((channelButton = this.buttons.get("channel")).getX(), channelButton.getY(), channelButton.getWidth(), channelButton.getHeight(), mouseX, mouseY) && this.currentMode != 3) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.channel").append(String.valueOf(this.currentChannel)), mouseX, mouseY);
        }
        if (MiscTools.inBounds((redstoneChannelButton = this.buttons.get("redstoneChannel")).getX(), redstoneChannelButton.getY(), redstoneChannelButton.getWidth(), redstoneChannelButton.getHeight(), mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.redstonechannel").append(String.valueOf(this.currentRedstoneChannel)), mouseX, mouseY);
        }
        if (MiscTools.inBounds((sneakyButton = this.buttons.get("sneaky")).getX(), sneakyButton.getY(), sneakyButton.getWidth(), sneakyButton.getHeight(), mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)String.valueOf(this.sneakyNames[this.currentSneaky + 1])), mouseX, mouseY);
        }
        if (MiscTools.inBounds((amountButton = this.buttons.get("amount")).getX(), amountButton.getY(), amountButton.getWidth(), amountButton.getHeight(), mouseX, mouseY)) {
            if (this.showExtractAmt()) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.extractamt"), mouseX, mouseY);
            }
            if (this.showPriority()) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.priority"), mouseX, mouseY);
            }
        }
        if (MiscTools.inBounds((regulate = this.buttons.get("regulate")).getX(), regulate.getY(), regulate.getWidth(), regulate.getHeight(), mouseX, mouseY) && this.showRegulate()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.regulate"), mouseX, mouseY);
        }
        if (MiscTools.inBounds((roundrobin = this.buttons.get("roundrobin")).getX(), roundrobin.getY(), roundrobin.getWidth(), roundrobin.getHeight(), mouseX, mouseY) && this.showRoundRobin()) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.translatable((String)"screen.laserio.false"), Component.translatable((String)"screen.laserio.true"), Component.translatable((String)"screen.laserio.enforced")};
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.roundrobin").append((Component)translatableComponents[this.currentRoundRobin]), mouseX, mouseY);
        }
        if (MiscTools.inBounds((redstoneMode = this.buttons.get("redstoneMode")).getX(), redstoneMode.getY(), redstoneMode.getWidth(), redstoneMode.getHeight(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.translatable((String)"screen.laserio.ignored"), Component.translatable((String)"screen.laserio.low"), Component.translatable((String)"screen.laserio.high")};
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.redstoneMode").append((Component)translatableComponents[this.currentRedstoneMode]), mouseX, mouseY);
        }
        if (MiscTools.inBounds((exact = this.buttons.get("exact")).getX(), exact.getY(), exact.getWidth(), exact.getHeight(), mouseX, mouseY) && this.showExactAmt()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.exact"), mouseX, mouseY);
        }
        if (MiscTools.inBounds((speedButton = this.buttons.get("speed")).getX(), speedButton.getY(), speedButton.getWidth(), speedButton.getHeight(), mouseX, mouseY) && !this.showPriority()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.tickSpeed"), mouseX, mouseY);
        }
        if (this.showAllow && MiscTools.inBounds((allowList = this.buttons.get("allowList")).getX(), allowList.getY(), allowList.getWidth(), allowList.getHeight(), mouseX, mouseY)) {
            if (this.isAllowList == 1) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.allowlist"), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.denylist"), mouseX, mouseY);
            }
        }
        if (this.showNBT && MiscTools.inBounds((nbtButton = this.buttons.get("nbt")).getX(), nbtButton.getY(), nbtButton.getWidth(), nbtButton.getHeight(), mouseX, mouseY)) {
            if (this.isCompareNBT == 1) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.nbttrue"), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.nbtfalse"), mouseX, mouseY);
            }
        }
        if (BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.SENSOR && MiscTools.inBounds((andButton = this.buttons.get("and")).getX(), andButton.getY(), andButton.getWidth(), andButton.getHeight(), mouseX, mouseY)) {
            if (this.currentAndMode) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.and"), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.or"), mouseX, mouseY);
            }
        }
    }

    public boolean validateHolder() {
        Inventory playerInventory = this.container.playerEntity.getInventory();
        for (int i = 0; i < playerInventory.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)playerInventory.items.get(i);
            if (!(itemStack.getItem() instanceof CardHolder) || !CardHolder.getUUID(itemStack).equals(this.container.cardHolderUUID)) continue;
            this.showCardHolderUI = true;
            this.toggleHolderSlots();
            return true;
        }
        this.showCardHolderUI = false;
        this.toggleHolderSlots();
        return false;
    }

    public void toggleHolderSlots() {
        for (int i = 17; i < 32; ++i) {
            Slot slot;
            if (i >= this.container.slots.size() || !((slot = this.container.getSlot(i)) instanceof CardHolderSlot)) continue;
            ((CardHolderSlot)slot).setEnabled(this.showCardHolderUI);
        }
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        if (this.showCardHolderUI) {
            return mouseX < (double)guiLeftIn - 100.0 || mouseY < (double)guiTopIn || mouseX >= (double)(guiLeftIn + this.imageWidth) || mouseY >= (double)(guiTopIn + this.imageHeight);
        }
        return super.hasClickedOutside(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton);
    }

    public void updateItemCounts() {
        FilterBasicHandler handler = this.container.filterHandler;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            stack.setCount(this.container.getStackSize(i + 2));
        }
    }

    public void addAmtButton() {
        this.buttons.put("amount", new NumberButton(this.getGuiLeft() + 147, this.getGuiTop() + 25, 24, 12, this.currentMode == 0 ? this.currentPriority : (short)this.currentItemExtractAmt, button -> this.changeAmount(-1)));
    }

    public void addModeButton() {
        ResourceLocation[] modeTextures = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/modeinserter.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/modeextractor.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/modestocker.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/modesensor.png")};
        this.buttons.put("mode", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 5, 16, 16, modeTextures, this.currentMode, button -> {
            this.currentMode = BaseCard.nextTransferMode(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentMode);
            ((NumberButton)this.buttons.get("amount")).setValue(this.currentMode == 0 ? this.currentPriority : (short)this.currentItemExtractAmt);
            this.modeChange();
        }));
    }

    public void addRedstoneButton() {
        ResourceLocation[] redstoneTextures = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/redstoneignore.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/redstonelow.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/redstonehigh.png")};
        this.buttons.put("redstoneMode", new ToggleButton(this.getGuiLeft() + 105, this.getGuiTop() + 5, 16, 16, redstoneTextures, this.currentRedstoneMode, button -> {
            this.currentRedstoneMode = (byte)(this.currentRedstoneMode == 2 ? 0 : this.currentRedstoneMode + 1);
            ((ToggleButton)button).setTexturePosition(this.currentRedstoneMode);
        }));
    }

    public void addRedstoneChannelButton() {
        this.buttons.put("redstoneChannel", new ChannelButton(this.getGuiLeft() + 125, this.getGuiTop() + 5, 16, 16, this.currentRedstoneChannel, button -> {
            this.currentRedstoneChannel = CardRedstone.nextRedstoneChannel(this.card);
            ((ChannelButton)button).setChannel(this.currentRedstoneChannel);
        }));
    }

    public void init() {
        super.init();
        Minecraft minecraft = Minecraft.getInstance();
        BlockEntityWithoutLevelRenderer blockentitywithoutlevelrenderer = new BlockEntityWithoutLevelRenderer(minecraft.getBlockEntityRenderDispatcher(), minecraft.getEntityModels());
        this.currentMode = BaseCard.getTransferMode(this.card);
        this.currentChannel = BaseCard.getChannel(this.card);
        this.currentItemExtractAmt = CardItem.getItemExtractAmt(this.card);
        this.currentPriority = BaseCard.getPriority(this.card);
        this.currentSneaky = BaseCard.getSneaky(this.card);
        this.currentTicks = BaseCard.getExtractSpeed(this.card);
        this.currentExact = BaseCard.getExact(this.card);
        this.currentRoundRobin = BaseCard.getRoundRobin(this.card);
        this.currentRegulate = BaseCard.getRegulate(this.card);
        this.currentRedstoneMode = BaseCard.getRedstoneMode(this.card);
        this.currentRedstoneChannel = BaseCard.getRedstoneChannel(this.card);
        this.currentAndMode = BaseCard.getAnd(this.card);
        boolean bl = this.showFilter = this.filter != null && !this.filter.isEmpty() && !(this.filter.getItem() instanceof FilterTag);
        if (this.showFilter) {
            this.isAllowList = BaseFilter.getAllowList(this.filter) ? 1 : 0;
            int n = this.isCompareNBT = BaseFilter.getCompareNBT(this.filter) ? 1 : 0;
            if (this.filter.getItem() instanceof FilterMod) {
                this.showAllow = true;
                this.showNBT = false;
            } else if (this.filter.getItem() instanceof FilterBasic) {
                this.showAllow = true;
                this.showNBT = true;
            } else if (this.filter.getItem() instanceof FilterCount) {
                this.showAllow = false;
                this.showNBT = true;
            } else if (this.filter.getItem() instanceof FilterNBT) {
                this.showAllow = true;
                this.showNBT = false;
            }
            if (BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.SENSOR) {
                this.showAllow = false;
            }
        } else {
            this.isAllowList = -1;
            this.isCompareNBT = -1;
        }
        ResourceLocation[] allowListTextures = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/allowlistfalse.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/allowlisttrue.png")};
        this.buttons.put("allowList", new ToggleButton(this.getGuiLeft() + 135, this.getGuiTop() + 61, 16, 16, allowListTextures, this.isAllowList == 1 ? 1 : 0, button -> {
            this.isAllowList = this.isAllowList == 1 ? 0 : 1;
            ((ToggleButton)button).setTexturePosition(this.isAllowList == 1 ? 1 : 0);
        }));
        ResourceLocation[] nbtTextures = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/matchnbtfalse.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/matchnbttrue.png")};
        this.buttons.put("nbt", new ToggleButton(this.getGuiLeft() + 153, this.getGuiTop() + 61, 16, 16, nbtTextures, this.isCompareNBT == 1 ? 1 : 0, button -> {
            this.isCompareNBT = this.isCompareNBT == 1 ? 0 : 1;
            ((ToggleButton)button).setTexturePosition(this.isCompareNBT == 1 ? 1 : 0);
        }));
        this.addAmtButton();
        this.buttons.put("speed", new NumberButton(this.getGuiLeft() + 147, this.getGuiTop() + 39, 24, 12, this.currentTicks, button -> this.changeTick(-1)));
        ResourceLocation[] exactTextures = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/exactfalse.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/exacttrue.png")};
        this.buttons.put("exact", new ToggleButton(this.getGuiLeft() + 25, this.getGuiTop() + 25, 16, 16, exactTextures, this.currentExact ? 1 : 0, button -> {
            this.currentExact = !this.currentExact;
            ((ToggleButton)button).setTexturePosition(this.currentExact ? 1 : 0);
        }));
        ResourceLocation[] roundRobinTextures = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/roundrobinfalse.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/roundrobintrue.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/roundrobinenforced.png")};
        this.buttons.put("roundrobin", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, roundRobinTextures, this.currentRoundRobin, button -> {
            this.currentRoundRobin = this.currentRoundRobin == 2 ? 0 : this.currentRoundRobin + 1;
            ((ToggleButton)button).setTexturePosition(this.currentRoundRobin);
        }));
        ResourceLocation[] regulateTextures = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/regulatefalse.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/regulatetrue.png")};
        this.buttons.put("regulate", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, regulateTextures, this.currentRegulate ? 1 : 0, button -> {
            this.currentRegulate = !this.currentRegulate;
            ((ToggleButton)button).setTexturePosition(this.currentRegulate ? 1 : 0);
        }));
        ResourceLocation[] andTextures = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/or.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/and.png")};
        this.buttons.put("and", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, andTextures, this.currentAndMode ? 1 : 0, button -> {
            this.currentAndMode = !this.currentAndMode;
            ((ToggleButton)button).setTexturePosition(this.currentAndMode ? 1 : 0);
        }));
        this.addModeButton();
        this.addRedstoneButton();
        this.addRedstoneChannelButton();
        this.buttons.put("channel", new ChannelButton(this.getGuiLeft() + 5, this.getGuiTop() + 65, 16, 16, this.currentChannel, button -> {
            this.currentChannel = BaseCard.nextChannel(this.card);
            ((ChannelButton)button).setChannel(this.currentChannel);
        }));
        ResourceLocation[] sneakyTextures = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/sneaky.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/sneaky-down.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/sneaky-up.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/sneaky-north.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/sneaky-south.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/sneaky-west.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/sneaky-east.png")};
        this.buttons.put("sneaky", new ToggleButton(this.getGuiLeft() + 25, this.getGuiTop() + 5, 16, 16, sneakyTextures, this.currentSneaky + 1, button -> {
            this.currentSneaky = BaseCard.nextSneaky(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentSneaky + 1);
        }));
        if (this.container.direction != -1) {
            this.buttons.put("return", (Button)new ExtendedButton(this.getGuiLeft() - 25, this.getGuiTop() + 1, 25, 20, (Component)Component.literal((String)"<--"), button -> this.openNode()));
        }
        for (Map.Entry<String, Button> button2 : this.buttons.entrySet()) {
            this.addRenderableWidget((GuiEventListener)button2.getValue());
        }
        if (!this.showNBT) {
            this.removeWidget((GuiEventListener)this.buttons.get("nbt"));
        }
        if (!this.showAllow) {
            this.removeWidget((GuiEventListener)this.buttons.get("allowList"));
        }
        if (this.card.getCount() > 1) {
            int i = 0;
            while (true) {
                if (i >= 2) break;
                if (i < this.container.slots.size()) {
                    Slot slot = this.container.getSlot(i);
                    if (slot instanceof CardItemSlot) {
                        CardItemSlot cardItemSlot = (CardItemSlot)slot;
                        cardItemSlot.setEnabled(false);
                    }
                    if (slot instanceof CardOverclockSlot) {
                        CardOverclockSlot cardOverclockSlot = (CardOverclockSlot)slot;
                        cardOverclockSlot.setEnabled(false);
                    }
                }
                ++i;
            }
        }
        this.modeChange();
    }

    public void modeChange() {
        Button speedButton = this.buttons.get("speed");
        Button exactButton = this.buttons.get("exact");
        Button rrButton = this.buttons.get("roundrobin");
        Button regulateButton = this.buttons.get("regulate");
        Button channelButton = this.buttons.get("channel");
        Button amountButton = this.buttons.get("amount");
        Button andButton = this.buttons.get("and");
        Button redstoneModeButton = this.buttons.get("redstoneMode");
        if (this.currentMode == 0) {
            if (!this.renderables.contains(channelButton)) {
                this.addRenderableWidget((GuiEventListener)channelButton);
            }
            if (!this.renderables.contains(amountButton)) {
                this.addRenderableWidget((GuiEventListener)amountButton);
            }
            if (!this.renderables.contains(redstoneModeButton)) {
                this.addRenderableWidget((GuiEventListener)redstoneModeButton);
            }
            this.removeWidget((GuiEventListener)speedButton);
            this.removeWidget((GuiEventListener)exactButton);
            this.removeWidget((GuiEventListener)rrButton);
            this.removeWidget((GuiEventListener)regulateButton);
            this.removeWidget((GuiEventListener)andButton);
        } else if (this.currentMode == 1) {
            if (!this.renderables.contains(channelButton)) {
                this.addRenderableWidget((GuiEventListener)channelButton);
            }
            if (!this.renderables.contains(amountButton)) {
                this.addRenderableWidget((GuiEventListener)amountButton);
            }
            if (!this.renderables.contains(speedButton)) {
                this.addRenderableWidget((GuiEventListener)speedButton);
            }
            if (!this.renderables.contains(exactButton)) {
                this.addRenderableWidget((GuiEventListener)exactButton);
            }
            if (!this.renderables.contains(rrButton)) {
                this.addRenderableWidget((GuiEventListener)rrButton);
            }
            if (!this.renderables.contains(redstoneModeButton)) {
                this.addRenderableWidget((GuiEventListener)redstoneModeButton);
            }
            this.removeWidget((GuiEventListener)regulateButton);
            this.removeWidget((GuiEventListener)andButton);
        } else if (this.currentMode == 2) {
            if (!this.renderables.contains(channelButton)) {
                this.addRenderableWidget((GuiEventListener)channelButton);
            }
            if (!this.renderables.contains(amountButton)) {
                this.addRenderableWidget((GuiEventListener)amountButton);
            }
            if (!this.renderables.contains(speedButton)) {
                this.addRenderableWidget((GuiEventListener)speedButton);
            }
            if (!this.renderables.contains(exactButton)) {
                this.addRenderableWidget((GuiEventListener)exactButton);
            }
            if (!this.renderables.contains(regulateButton)) {
                this.addRenderableWidget((GuiEventListener)regulateButton);
            }
            if (!this.renderables.contains(redstoneModeButton)) {
                this.addRenderableWidget((GuiEventListener)redstoneModeButton);
            }
            this.removeWidget((GuiEventListener)rrButton);
            this.removeWidget((GuiEventListener)andButton);
        } else if (this.currentMode == 3) {
            if (!this.renderables.contains(speedButton)) {
                this.addRenderableWidget((GuiEventListener)speedButton);
            }
            if (!this.renderables.contains(andButton)) {
                this.addRenderableWidget((GuiEventListener)andButton);
            }
            this.removeWidget((GuiEventListener)rrButton);
            this.removeWidget((GuiEventListener)regulateButton);
            this.removeWidget((GuiEventListener)channelButton);
            this.removeWidget((GuiEventListener)amountButton);
            this.removeWidget((GuiEventListener)redstoneModeButton);
            if (this.filter.getItem() instanceof FilterCount) {
                if (!this.renderables.contains(exactButton)) {
                    this.addRenderableWidget((GuiEventListener)exactButton);
                }
            } else {
                this.removeWidget((GuiEventListener)exactButton);
            }
        }
    }

    public void changeAmount(int change) {
        if (Screen.hasShiftDown()) {
            change *= 10;
        }
        if (Screen.hasControlDown()) {
            change *= 64;
        }
        if (change < 0) {
            if (this.currentMode == 0) {
                this.currentPriority = (short)Math.max(this.currentPriority + change, -4096);
            } else {
                this.currentItemExtractAmt = (byte)Math.max(this.currentItemExtractAmt + change, 1);
            }
        } else if (this.currentMode == 0) {
            this.currentPriority = (short)Math.min(this.currentPriority + change, 4096);
        } else {
            this.currentItemExtractAmt = (byte)Math.min(this.currentItemExtractAmt + change, Math.max(this.container.getSlot(1).getItem().getCount() * 16, 8));
        }
    }

    public void changeTick(int change) {
        if (Screen.hasShiftDown()) {
            change *= 10;
        }
        if (Screen.hasControlDown()) {
            change *= 64;
        }
        this.currentTicks = change < 0 ? Math.max(this.currentTicks + change, Math.max(20 - this.container.getSlot(1).getItem().getCount() * 5, 1)) : Math.min(this.currentTicks + change, 1200);
    }

    public void toggleFilterSlots() {
        this.filter = ((Slot)this.container.slots.get(0)).getItem();
        this.showFilter = !this.filter.isEmpty() && !(this.filter.getItem() instanceof FilterTag) && !(this.filter.getItem() instanceof FilterNBT);
        Button exactButton = this.buttons.get("exact");
        if (this.showFilter) {
            if (this.filter.getItem() instanceof FilterMod) {
                this.showNBT = false;
                if (this.currentMode == 2) {
                    this.showAllow = true;
                } else {
                    this.showAllow = true;
                    if (!this.renderables.contains(this.buttons.get("allowList"))) {
                        this.addRenderableWidget((GuiEventListener)this.buttons.get("allowList"));
                    }
                }
            } else if (this.filter.getItem() instanceof FilterBasic) {
                this.showNBT = true;
                if (this.currentMode == 2) {
                    this.showAllow = true;
                } else {
                    this.showAllow = true;
                    if (!this.renderables.contains(this.buttons.get("allowList"))) {
                        this.addRenderableWidget((GuiEventListener)this.buttons.get("allowList"));
                    }
                }
            } else if (this.filter.getItem() instanceof FilterCount) {
                this.showAllow = false;
                this.showNBT = true;
                this.removeWidget((GuiEventListener)this.buttons.get("allowList"));
            }
            if (BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.SENSOR) {
                this.showAllow = false;
                this.removeWidget((GuiEventListener)this.buttons.get("allowList"));
                if (this.filter.getItem() instanceof FilterCount) {
                    if (!this.renderables.contains(exactButton)) {
                        this.addRenderableWidget((GuiEventListener)exactButton);
                    }
                } else {
                    this.removeWidget((GuiEventListener)exactButton);
                }
            }
            if (this.isAllowList == -1) {
                this.isAllowList = BaseFilter.getAllowList(this.filter) ? 1 : 0;
                ((ToggleButton)this.buttons.get("allowList")).setTexturePosition(this.isAllowList == 1 ? 1 : 0);
                this.isCompareNBT = BaseFilter.getCompareNBT(this.filter) ? 1 : 0;
                ((ToggleButton)this.buttons.get("nbt")).setTexturePosition(this.isCompareNBT == 1 ? 1 : 0);
                if (this.showAllow) {
                    this.addRenderableWidget((GuiEventListener)this.buttons.get("allowList"));
                }
                if (this.showNBT) {
                    this.addRenderableWidget((GuiEventListener)this.buttons.get("nbt"));
                }
            }
        } else {
            this.isAllowList = -1;
            this.isCompareNBT = -1;
            this.removeWidget((GuiEventListener)this.buttons.get("allowList"));
            this.removeWidget((GuiEventListener)this.buttons.get("nbt"));
            this.showAllow = false;
            this.showNBT = false;
            if (BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.SENSOR) {
                this.removeWidget((GuiEventListener)exactButton);
            }
        }
        int i = 2;
        while (true) {
            Slot slot;
            if (i >= 2 + 15) break;
            if (i < this.container.slots.size() && (slot = this.container.getSlot(i)) instanceof FilterBasicSlot) {
                ((FilterBasicSlot)slot).setEnabled(this.showFilter);
            }
            ++i;
        }
    }

    private boolean showExtractAmt() {
        return this.card.getItem() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) != BaseCard.TransferMode.INSERT && BaseCard.getNamedTransferMode(this.card) != BaseCard.TransferMode.SENSOR;
    }

    private boolean showExactAmt() {
        if (BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.SENSOR) {
            return this.filter.getItem() instanceof FilterCount;
        }
        return this.card.getItem() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) != BaseCard.TransferMode.INSERT;
    }

    private boolean showPriority() {
        return this.card.getItem() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.INSERT;
    }

    private boolean showRegulate() {
        return this.card.getItem() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.STOCK;
    }

    private boolean showRoundRobin() {
        return this.card.getItem() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.EXTRACT;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        this.filter = ((Slot)this.container.slots.get(0)).getItem();
        if (this.showFilter) {
            int slotsWidth = 90;
            int slotsHeight = 54;
            guiGraphics.blit(this.GUI, relX += 43, relY += 24, 0, 167, slotsWidth, slotsHeight);
        }
        if (this.showCardHolderUI) {
            ResourceLocation CardHolderGUI = ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/cardholder_node.png");
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CardHolderGUI);
            guiGraphics.blit(CardHolderGUI, this.getGuiLeft() - 100, this.getGuiTop() + 24, 0, 0, this.imageWidth, this.imageHeight);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.saveSettings();
        super.onClose();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double deltaY) {
        if (this.hoveredSlot == null) {
            return super.mouseScrolled(mouseX, mouseY, delta, deltaY);
        }
        if (this.hoveredSlot instanceof FilterBasicSlot && this.filter.getItem() instanceof FilterCount) {
            this.filterSlot(delta == 1.0 ? 0 : -1);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, delta, deltaY);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.translatable((String)("laserio." + key), (Object[])args);
    }

    public void setExtract(NumberButton amountButton, int btn) {
        if (btn == 0) {
            this.changeAmount(1);
        } else if (btn == 1) {
            this.changeAmount(-1);
        }
        amountButton.setValue(this.currentMode == 0 ? this.currentPriority : (short)this.currentItemExtractAmt);
        amountButton.playDownSound(Minecraft.getInstance().getSoundManager());
    }

    public void saveSettings() {
        if (this.showFilter) {
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFilterPayload(this.isAllowList == 1, this.isCompareNBT == 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateCardPayload(this.currentMode, this.currentChannel, this.currentItemExtractAmt, this.currentPriority, this.currentSneaky, (short)this.currentTicks, this.currentExact, this.currentRegulate, (byte)this.currentRoundRobin, 0, 0, this.currentRedstoneMode, this.currentRedstoneChannel, this.currentAndMode), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean filterSlot(int btn) {
        int amt;
        ItemStack slotStack = this.hoveredSlot.getItem();
        if (slotStack.isEmpty()) {
            return true;
        }
        if (btn == 2) {
            slotStack.setCount(0);
            PacketDistributor.sendToServer((CustomPacketPayload)new GhostSlotPayload(this.hoveredSlot.index, slotStack, slotStack.getCount(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        int n = amt = btn == 0 ? 1 : -1;
        if (Screen.hasShiftDown()) {
            amt *= 10;
        }
        if (Screen.hasControlDown()) {
            amt *= 64;
        }
        if (amt + slotStack.getCount() > 4096) {
            amt = 4096 - slotStack.getCount();
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new GhostSlotPayload(this.hoveredSlot.index, slotStack, slotStack.getCount() + amt, -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    public void openNode() {
        this.saveSettings();
        PacketDistributor.sendToServer((CustomPacketPayload)new OpenNodePayload(this.container.sourceContainer, this.container.direction), (CustomPacketPayload[])new CustomPacketPayload[0]);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public boolean mouseClicked(double x, double y, int btn) {
        ChannelButton channelButton = (ChannelButton)this.buttons.get("channel");
        if (this.currentMode != 3 && MiscTools.inBounds(channelButton.getX(), channelButton.getY(), channelButton.getWidth(), channelButton.getHeight(), x, y)) {
            if (btn == 0) {
                this.currentChannel = BaseCard.nextChannel(this.card);
            } else if (btn == 1) {
                this.currentChannel = BaseCard.previousChannel(this.card);
            }
            channelButton.setChannel(this.currentChannel);
            channelButton.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        ChannelButton redstoneChannelButton = (ChannelButton)this.buttons.get("redstoneChannel");
        if (MiscTools.inBounds(redstoneChannelButton.getX(), redstoneChannelButton.getY(), redstoneChannelButton.getWidth(), redstoneChannelButton.getHeight(), x, y)) {
            if (btn == 0) {
                this.currentRedstoneChannel = BaseCard.nextRedstoneChannel(this.card);
            } else if (btn == 1) {
                this.currentRedstoneChannel = BaseCard.previousRedstoneChannel(this.card);
            }
            redstoneChannelButton.setChannel(this.currentRedstoneChannel);
            redstoneChannelButton.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        ToggleButton sneakyButton = (ToggleButton)this.buttons.get("sneaky");
        if (MiscTools.inBounds(sneakyButton.getX(), sneakyButton.getY(), sneakyButton.getWidth(), sneakyButton.getHeight(), x, y)) {
            if (btn == 0) {
                this.currentSneaky = BaseCard.nextSneaky(this.card);
                sneakyButton.setTexturePosition(this.currentSneaky + 1);
            } else if (btn == 1) {
                this.currentSneaky = BaseCard.previousSneaky(this.card);
                sneakyButton.setTexturePosition(this.currentSneaky + 1);
            }
            sneakyButton.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        NumberButton amountButton = (NumberButton)this.buttons.get("amount");
        if (MiscTools.inBounds(amountButton.getX(), amountButton.getY(), amountButton.getWidth(), amountButton.getHeight(), x, y)) {
            this.setExtract(amountButton, btn);
            return true;
        }
        NumberButton speedButton = (NumberButton)this.buttons.get("speed");
        if (MiscTools.inBounds(speedButton.getX(), speedButton.getY(), speedButton.getWidth(), speedButton.getHeight(), x, y)) {
            if (btn == 0) {
                this.changeTick(1);
            } else if (btn == 1) {
                this.changeTick(-1);
            }
            speedButton.setValue(this.currentTicks);
            speedButton.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        if (this.hoveredSlot == null) {
            return super.mouseClicked(x, y, btn);
        }
        if (this.hoveredSlot instanceof FilterBasicSlot) {
            if (this.filter.getItem() instanceof FilterBasic) {
                ItemStack stack = ((CardItemContainer)this.menu).getCarried();
                if (ItemStack.isSameItemSameComponents((ItemStack)(stack = stack.copy().split(this.hoveredSlot.getMaxStackSize())), (ItemStack)this.container.cardItem)) {
                    return true;
                }
                this.hoveredSlot.set(stack);
                PacketDistributor.sendToServer((CustomPacketPayload)new GhostSlotPayload(this.hoveredSlot.index, stack, stack.getCount(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (this.filter.getItem() instanceof FilterCount) {
                ItemStack stack = ((CardItemContainer)this.menu).getCarried();
                if (!stack.isEmpty()) {
                    if (ItemStack.isSameItemSameComponents((ItemStack)(stack = stack.copy()), (ItemStack)this.container.cardItem)) {
                        return true;
                    }
                    this.hoveredSlot.set(stack);
                    PacketDistributor.sendToServer((CustomPacketPayload)new GhostSlotPayload(this.hoveredSlot.index, stack, stack.getCount(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    this.filterSlot(btn);
                }
            }
            return true;
        }
        if (this.hoveredSlot instanceof CardItemSlot) {
            if (btn == 0) {
                if (this.filter.getItem() instanceof BaseFilter && !(this.filter.getItem() instanceof FilterTag) && !(this.filter.getItem() instanceof FilterNBT)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFilterPayload(this.isAllowList == 1, this.isCompareNBT == 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else if (btn == 1) {
                int slot = this.hoveredSlot.getSlotIndex();
                this.saveSettings();
                PacketDistributor.sendToServer((CustomPacketPayload)new OpenFilterPayload(slot), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        return super.mouseClicked(x, y, btn);
    }
}

