/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.predicate;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.core.helper.NbtHelpers;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;

public class IngredientPredicateItemStackNbt
extends IngredientPredicate<ItemStack, Integer> {
    private final boolean blacklist;
    private final boolean requireNbt;
    private final boolean subset;
    private final Optional<CompoundTag> tag;
    private final boolean recursive;
    private final boolean superset;

    public IngredientPredicateItemStackNbt(boolean blacklist, int amount, boolean exactAmount, boolean requireNbt, boolean subset, Optional<Tag> tag, boolean recursive, boolean superset) {
        super(IngredientComponent.ITEMSTACK, blacklist, false, amount, exactAmount);
        this.blacklist = blacklist;
        this.requireNbt = requireNbt;
        this.subset = subset;
        this.tag = tag.filter(t -> t instanceof CompoundTag).map(t -> (CompoundTag)t);
        this.recursive = recursive;
        this.superset = superset;
    }

    @Override
    public boolean test(@Nullable ItemStack input) {
        boolean ret;
        if (input.getComponents().isEmpty() && this.requireNbt) {
            return this.isBlacklist();
        }
        CompoundTag itemTag = (CompoundTag)DataComponentPatch.CODEC.encodeStart((DynamicOps)ServerLifecycleHooks.getCurrentServer().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)input.getComponentsPatch()).getOrThrow();
        boolean bl = ret = !this.subset || this.tag.map(t -> NbtHelpers.nbtMatchesSubset((CompoundTag)t, (CompoundTag)itemTag, (boolean)this.recursive)).orElse(false) != false && (!this.superset || this.tag.map(t -> NbtHelpers.nbtMatchesSubset((CompoundTag)itemTag, (CompoundTag)t, (boolean)this.recursive)).orElse(false) != false);
        if (this.blacklist) {
            ret = !ret;
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IngredientPredicateItemStackNbt)) {
            return false;
        }
        IngredientPredicateItemStackNbt that = (IngredientPredicateItemStackNbt)obj;
        return super.equals(obj) && this.blacklist == that.blacklist && this.requireNbt == that.requireNbt && this.subset == that.subset && this.tag.equals(that.tag) && this.recursive == that.recursive && this.superset == that.superset;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.blacklist ? 1 : 0) << 1 ^ (this.requireNbt ? 1 : 0) << 2 ^ (this.subset ? 1 : 0) << 3 ^ this.tag.hashCode() << 4 ^ (this.recursive ? 1 : 0) << 5 ^ (this.superset ? 1 : 0) << 6;
    }
}

