/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.core;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.utils.VanillaTagWrapper;
import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public final class TagReloadHandler {
    private static final Object LOCK = new Object();
    @Nullable
    private static VanillaTagWrapper<Item> VANILLA_ITEM_TAGS;
    @Nullable
    private static VanillaTagWrapper<Block> VANILLA_BLOCK_TAGS;

    private TagReloadHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initItemTags(Map<ResourceLocation, Collection<Holder<Item>>> rawItemTags) {
        Object object = LOCK;
        synchronized (object) {
            VANILLA_ITEM_TAGS = VanillaTagWrapper.of(BuiltInRegistries.ITEM, rawItemTags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initBlockTags(Map<ResourceLocation, Collection<Holder<Block>>> rawBlockTags) {
        Object object = LOCK;
        synchronized (object) {
            VANILLA_BLOCK_TAGS = VanillaTagWrapper.of(BuiltInRegistries.BLOCK, rawBlockTags);
        }
    }

    public static void run() {
        if (VANILLA_ITEM_TAGS == null || VANILLA_BLOCK_TAGS == null) {
            return;
        }
        AlmostUnifiedCommon.onTagLoaderReload(VANILLA_ITEM_TAGS, VANILLA_BLOCK_TAGS);
        VANILLA_ITEM_TAGS.seal();
        VANILLA_BLOCK_TAGS.seal();
        VANILLA_ITEM_TAGS = null;
        VANILLA_BLOCK_TAGS = null;
    }

    public static void applyCustomTags(Map<ResourceLocation, Set<ResourceLocation>> customTags, VanillaTagWrapper<Item> itemTags) {
        HashMultimap changedItemTags = HashMultimap.create();
        for (Map.Entry<ResourceLocation, Set<ResourceLocation>> entry : customTags.entrySet()) {
            ResourceLocation tag2 = entry.getKey();
            Set<ResourceLocation> itemIds = entry.getValue();
            for (ResourceLocation itemId : itemIds) {
                if (!BuiltInRegistries.ITEM.containsKey(itemId)) {
                    AlmostUnifiedCommon.LOGGER.warn("[CustomTags] Custom tag '{}' contains invalid item '{}'", (Object)tag2, (Object)itemId);
                    continue;
                }
                ResourceKey itemKey = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)itemId);
                Holder itemHolder = BuiltInRegistries.ITEM.getHolder(itemKey).orElse(null);
                if (itemHolder == null) continue;
                Collection<Holder<Item>> currentHolders = itemTags.get(tag2);
                if (!currentHolders.isEmpty() && currentHolders.contains(itemHolder)) {
                    AlmostUnifiedCommon.LOGGER.warn("[CustomTags] Custom tag '{}' already contains item '{}'", (Object)tag2, (Object)itemId);
                    continue;
                }
                itemTags.add(tag2, (Holder<Item>)itemHolder);
                changedItemTags.put((Object)tag2, (Object)itemId);
            }
        }
        if (!changedItemTags.isEmpty()) {
            changedItemTags.asMap().forEach((tag, items) -> AlmostUnifiedCommon.LOGGER.info("[CustomTags] Modified tag '#{}', added {}", tag, items));
        }
    }
}

