/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat.unification;

import com.almostreliable.unified.api.unification.bundled.GenericRecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.RecipeJson;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.UnificationHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class OccultismRecipeUnifier
implements RecipeUnifier {
    static final String TYPE = "type";
    private static final String ACTIVATION_ITEM = "activation_item";
    private static final String ITEM_TO_USE = "item_to_use";
    private static final String STACK = "stack";

    @Override
    public void unify(UnificationHelper helper, RecipeJson recipe) {
        JsonObject result;
        GenericRecipeUnifier.INSTANCE.unifyInputs(helper, recipe);
        helper.unifyInputs(recipe, ACTIVATION_ITEM, ITEM_TO_USE);
        JsonElement jsonElement = recipe.getProperty("result");
        if (jsonElement instanceof JsonObject && (result = (JsonObject)jsonElement).has(TYPE)) {
            OccultismRecipeUnifier.unifyTypedOutput(helper, recipe, result);
            return;
        }
        GenericRecipeUnifier.INSTANCE.unifyOutputs(helper, recipe);
    }

    static void unifyTypedOutput(UnificationHelper helper, RecipeJson recipe, JsonObject result) {
        helper.unifyOutputs(recipe, "result", true, STACK, "id");
        String type = result.get(TYPE).getAsString();
        if (!type.contains("tag") || result.has("tag")) {
            return;
        }
        result.add("id", result.get("item"));
        result.remove("item");
        result.addProperty(TYPE, type.replace("tag", "item"));
        if (type.contains("weighted_tag")) {
            JsonObject stack = new JsonObject();
            stack.add("count", result.get("count"));
            stack.add("id", result.get("id"));
            result.add(STACK, (JsonElement)stack);
            result.remove("count");
            result.remove("id");
        }
    }
}

