/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.api.screens;

import com.mojang.serialization.Codec;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum BarMode implements StringRepresentable
{
    MODE_TEXT("Text"),
    MODE_PERTICK("PerTick"),
    MODE_PERCENTAGE("Percentage"),
    MODE_NONE("None");

    private final String name;
    public static final Codec<BarMode> CODEC;
    public static final StreamCodec<FriendlyByteBuf, BarMode> STREAM_CODEC;

    private BarMode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static BarMode getMode(String name) {
        for (BarMode style : BarMode.values()) {
            if (!name.equals(style.getName())) continue;
            return style;
        }
        return MODE_TEXT;
    }

    public boolean hideText() {
        return this == MODE_NONE;
    }

    public boolean showPerTick() {
        return this == MODE_PERTICK;
    }

    public boolean showPercentage() {
        return this == MODE_PERCENTAGE;
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(BarMode::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(BarMode.class);
    }
}

