/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.network;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.network.SyncBlockHighlightsPayload;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;

public record RequestControllerTargetHighlightsPayload(ItemStack stack, List<BlockPos> controllerPositions) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestControllerTargetHighlightsPayload> TYPE = new CustomPacketPayload.Type(SophisticatedStorage.getRL("request_controller_target_highlights"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestControllerTargetHighlightsPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, RequestControllerTargetHighlightsPayload::stack, (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), RequestControllerTargetHighlightsPayload::controllerPositions, RequestControllerTargetHighlightsPayload::new);
    public static final int MATCHING_STACK_HIGHLIGHT_COLOR = 5025616;
    public static final int MATCHING_ITEM_HIGHLIGHT_COLOR = 4367861;
    public static final int EMPTY_TARGET_HIGHLIGHT_COLOR = 16771899;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(RequestControllerTargetHighlightsPayload payload, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ArrayList stackStorages = new ArrayList();
            ArrayList itemStorages = new ArrayList();
            ArrayList emptyTargetSlotStorages = new ArrayList();
            ItemStackKey stackKey = ItemStackKey.of((ItemStack)payload.stack());
            payload.controllerPositions().forEach(pos -> {
                Level level = player.level();
                WorldHelper.getLoadedBlockEntity((Level)level, (BlockPos)pos, ControllerBlockEntity.class).ifPresent(controller -> {
                    stackStorages.addAll(controller.getStackStorages(stackKey));
                    itemStorages.addAll(controller.getItemStorages(stackKey));
                    emptyTargetSlotStorages.addAll(controller.getEmptyTargetSlotStorages(stackKey));
                });
            });
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncBlockHighlightsPayload(Map.of(5025616, stackStorages, 4367861, itemStorages, 16771899, emptyTargetSlotStorages)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

