/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.spawndata.collector.general;

import com.cobblemon.mod.common.api.spawning.condition.MoonPhase;
import com.cobblemon.mod.common.api.spawning.condition.SpawningCondition;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.metacontent.cobblenav.api.platform.SpawnDataContext;
import com.metacontent.cobblenav.spawndata.collector.general.GeneralConditionCollector;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\u000e\u001a\u0004\u0018\u00010\r2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u00108\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/metacontent/cobblenav/spawndata/collector/general/MoonPhaseCollector;", "Lcom/metacontent/cobblenav/spawndata/collector/general/GeneralConditionCollector;", "<init>", "()V", "Lcom/cobblemon/mod/common/api/spawning/condition/SpawningCondition;", "condition", "", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "spawnablePositions", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lcom/metacontent/cobblenav/api/platform/SpawnDataContext$Builder;", "builder", "Lnet/minecraft/network/chat/MutableComponent;", "collect", "(Lcom/cobblemon/mod/common/api/spawning/condition/SpawningCondition;Ljava/util/List;Lnet/minecraft/server/level/ServerPlayer;Lcom/metacontent/cobblenav/api/platform/SpawnDataContext$Builder;)Lnet/minecraft/network/chat/MutableComponent;", "", "configName", "Ljava/lang/String;", "getConfigName", "()Ljava/lang/String;", "cobblenav-common"})
public final class MoonPhaseCollector
extends GeneralConditionCollector {
    @NotNull
    private final String configName;

    public MoonPhaseCollector() {
        this.configName = "moon_phase";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return this.configName;
    }

    @Override
    @Nullable
    public MutableComponent collect(@NotNull SpawningCondition<?> condition, @NotNull List<? extends SpawnablePosition> spawnablePositions, @NotNull ServerPlayer player, @NotNull SpawnDataContext.Builder builder) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter(spawnablePositions, (String)"spawnablePositions");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (condition.getMoonPhase() != null) {
            MutableComponent mutableComponent = Component.translatable((String)"gui.cobblenav.spawn_data.moon");
            Level level = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            String string = MoonPhase.Companion.ofWorld(level).name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return mutableComponent.append((Component)Component.translatable((String)("moon.cobblenav." + string)));
        }
        return null;
    }
}

