/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.simpleweather;

import java.time.LocalDate;
import java.time.Month;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.joml.Random;
import org.joml.Vector3f;
import tv.soaryn.simpleweather.BiomeUtils;
import tv.soaryn.simpleweather.ParticleContent;
import tv.soaryn.simpleweather.SimpleWeatherConfig;
import tv.soaryn.simpleweather.particles.RainParticle;
import tv.soaryn.simpleweather.particles.SnowParticle;

@Mod(value="simple_weather", dist={Dist.CLIENT})
public class SimpleWeather {
    public static final String ModId = "simple_weather";
    public static LocalDate Now = LocalDate.now();
    private static final Random random = new Random(1L);
    public static boolean IsFools = false;
    public static final SimpleWeatherConfig ClientConfig = new SimpleWeatherConfig();

    public SimpleWeather(IEventBus bus) {
        ParticleContent.Map.register(bus);
        ClientConfig.register(ModLoadingContext.get());
    }

    @EventBusSubscriber(modid="simple_weather", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    private static interface NeoBus {
        @SubscribeEvent
        private static void updateTime(LevelEvent.Load event) {
            Now = LocalDate.now();
            IsFools = Now.getDayOfMonth() == 1 && Now.getMonth() == Month.APRIL;
        }

        @SubscribeEvent
        public static void renderWeather(ClientTickEvent.Pre event) {
            Minecraft minecraft = Minecraft.getInstance();
            ClientLevel level = minecraft.level;
            LocalPlayer player = minecraft.player;
            if (level == null || player == null) {
                return;
            }
            boolean isEnabled = (Boolean)SimpleWeather.ClientConfig.OverrideWeather.get();
            if (!isEnabled) {
                return;
            }
            if (minecraft.isPaused() || !level.tickRateManager().runsNormally()) {
                return;
            }
            float partialTick = minecraft.getTimer().getGameTimeDeltaPartialTick(false);
            if (level.getRainLevel(partialTick) <= 0.001f) {
                return;
            }
            BlockPos pos = minecraft.gameRenderer.getMainCamera().getBlockPosition();
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            int rainRange = (Integer)SimpleWeather.ClientConfig.RainRange.get();
            int snowRange = (Integer)SimpleWeather.ClientConfig.SnowRange.get();
            int snowOuterRange = (Integer)SimpleWeather.ClientConfig.SnowOuterRange.get();
            Integer targetAmount = level.getThunderLevel(partialTick) <= 0.1f ? (Integer)SimpleWeather.ClientConfig.WeatherParticleAmount.get() : (Integer)SimpleWeather.ClientConfig.WeatherParticleThunderAmount.get();
            int n = targetAmount;
            int amount = n / (switch ((ParticleStatus)minecraft.options.particles().get()) {
                default -> throw new MatchException(null, null);
                case ParticleStatus.ALL -> 1;
                case ParticleStatus.DECREASED -> 2;
                case ParticleStatus.MINIMAL -> 4;
            });
            Vector3f velocity = player.getDeltaMovement().toVector3f().mul(32.0f);
            int vx = (int)((float)x + velocity.x);
            int vz = (int)((float)z + velocity.z);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int j = 0; j < amount; ++j) {
                NeoBus.addRain(level, vx, y, vz, mutablePos, rainRange);
                NeoBus.addSnowflake(level, vx, y, vz, mutablePos, snowRange);
                NeoBus.addSnowflake(level, vx, y, vz, mutablePos, snowOuterRange);
            }
        }

        public static void addRain(ClientLevel level, int x, int y, int z, BlockPos.MutableBlockPos pos, int range) {
            if (random.nextFloat() > 0.00625f) {
                return;
            }
            pos.setX(x + NeoBus.nextIntInclusive(-range, range));
            pos.setY(y);
            pos.setZ(z + NeoBus.nextIntInclusive(-range, range));
            int field = 3;
            if (Mth.abs((int)(pos.getX() - x)) < field && Mth.abs((int)(pos.getZ() - z)) < field) {
                return;
            }
            if (NeoBus.shouldNotPrecipitateAt(level, pos, Biome.Precipitation.RAIN)) {
                if (NeoBus.shouldNotPrecipitateAt(level, pos.move(0, 24, 0), Biome.Precipitation.RAIN)) {
                    return;
                }
            } else {
                pos.move(0, 24, 0);
            }
            level.addParticle((ParticleOptions)ParticleContent.Rain.get(), true, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
        }

        private static boolean shouldNotPrecipitateAt(ClientLevel level, BlockPos.MutableBlockPos pos, Biome.Precipitation precipitation) {
            if (level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, (BlockPos)pos).getY() > pos.getY()) {
                return true;
            }
            if (!level.canSeeSky((BlockPos)pos)) {
                return true;
            }
            if (level.getBlockState((BlockPos)pos).isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)pos)) {
                return true;
            }
            return ((Biome)BiomeUtils.getBiome(level, (BlockPos)pos).value()).getPrecipitationAt((BlockPos)pos) != precipitation;
        }

        public static void addSnowflake(ClientLevel level, int x, int y, int z, BlockPos.MutableBlockPos pos, int range) {
            if (random.nextFloat() > 0.00625f) {
                return;
            }
            pos.setX(x + NeoBus.nextIntInclusive(-range, range));
            pos.setY(y + NeoBus.nextIntInclusive(-range, range));
            pos.setZ(z + NeoBus.nextIntInclusive(-range, range));
            if (NeoBus.shouldNotPrecipitateAt(level, pos, Biome.Precipitation.SNOW)) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleContent.Snow.get(), true, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
        }

        private static int nextIntInclusive(int min, int max) {
            return random.nextInt(max - min + 1) + min;
        }
    }

    @EventBusSubscriber(modid="simple_weather", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    private static interface ModBus {
        @SubscribeEvent
        public static void setup(FMLClientSetupEvent event) {
            ModLoadingContext.get().getActiveContainer().registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }

        @SubscribeEvent
        private static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ParticleContent.Snow.get(), SnowParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleContent.Rain.get(), RainParticle.Provider::new);
        }
    }
}

