/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.portal.AetherPortalBlock;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.ai.attribute.AetherAttributes;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.mixin.mixins.client.accessor.GuiAccessor;
import com.aetherteam.aether.mixin.mixins.client.accessor.HeartTypeAccessor;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import org.jetbrains.annotations.Nullable;

public class AetherOverlays {
    private static final ResourceLocation TEXTURE_INEBRIATION_VIGNETTE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/blur/inebriation_vignette.png");
    private static final ResourceLocation TEXTURE_REMEDY_VIGNETTE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/blur/remedy_vignette.png");
    private static final ResourceLocation TEXTURE_SHIELD_OF_REPULSION_VIGNETTE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/blur/shield_of_repulsion_vignette.png");
    private static final ResourceLocation TEXTURE_COOLDOWN_BAR = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/cooldown");
    private static final ResourceLocation TEXTURE_COOLDOWN_BAR_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/cooldown_background");
    public static final ResourceLocation TEXTURE_DEFAULT_JUMPS = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/jumps");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_FULL = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_full");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_HALF = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_half");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_FULL_BLINKING = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_full_blinking");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_HALF_BLINKING = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_half_blinkin");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_POISONED_FULL = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_poisoned_full");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_POISONED_HALF = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_poisoned_half");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_POISONED_FULL_BLINKING = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_poisoned_full_blinking");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_POISONED_HALF_BLINKING = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_poisoned_half_blinking");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_WITHERED_FULL = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_withered_full");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_WITHERED_HALF = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_withered_half");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_WITHERED_FULL_BLINKING = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_withered_full_blinking");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_WITHERED_HALF_BLINKING = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_withered_half_blinking");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_ABSORBING_FULL = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_absorbing_full");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_ABSORBING_HALF = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_absorbing_half");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_FROZEN_FULL = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_frozen_full");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_FROZEN_HALF = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hud/heart/shard_frozen_half");

    public static void registerOverlays(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"aether_portal_overlay"), (guiGraphics, partialTicks) -> {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (player != null) {
                AetherOverlays.renderAetherPortalOverlay(guiGraphics, minecraft, (AetherPlayerAttachment)player.getData((AttachmentType)AetherDataAttachments.AETHER_PLAYER.get()), partialTicks);
            }
        });
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"inebriation_vignette"), (guiGraphics, partialTicks) -> {
            Minecraft minecraft = Minecraft.getInstance();
            Window window = minecraft.getWindow();
            LocalPlayer player = minecraft.player;
            if (player != null) {
                AetherOverlays.renderInebriationOverlay(guiGraphics, minecraft, window, (Player)player);
            }
        });
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"remedy_vignette"), (guiGraphics, partialTicks) -> {
            Minecraft minecraft = Minecraft.getInstance();
            Window window = minecraft.getWindow();
            LocalPlayer player = minecraft.player;
            if (player != null) {
                AetherOverlays.renderRemedyOverlay(guiGraphics, minecraft, window, (Player)player);
            }
        });
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"shield_of_repulsion_vignette"), (guiGraphics, partialTicks) -> {
            Minecraft minecraft = Minecraft.getInstance();
            Window window = minecraft.getWindow();
            LocalPlayer player = minecraft.player;
            if (player != null) {
                AetherOverlays.renderRepulsionOverlay(guiGraphics, minecraft, window, (Player)player);
            }
        });
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hammer_cooldown"), (guiGraphics, partialTicks) -> {
            Minecraft minecraft = Minecraft.getInstance();
            Window window = minecraft.getWindow();
            LocalPlayer player = minecraft.player;
            if (player != null) {
                AetherOverlays.renderHammerCooldownOverlay(guiGraphics, minecraft, window, player);
            }
        });
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"moa_jumps"), (guiGraphics, partialTicks) -> {
            Minecraft minecraft = Minecraft.getInstance();
            Window window = minecraft.getWindow();
            LocalPlayer player = minecraft.player;
            if (player != null) {
                AetherOverlays.renderMoaJumps(guiGraphics, window, player);
            }
        });
        event.registerAbove(ResourceLocation.withDefaultNamespace((String)"player_health"), ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"silver_life_shard_hearts"), (guiGraphics, partialTicks) -> {
            Minecraft minecraft = Minecraft.getInstance();
            Window window = minecraft.getWindow();
            Gui gui = minecraft.gui;
            LocalPlayer player = minecraft.player;
            if (player != null) {
                AetherOverlays.renderSilverLifeShardHearts(guiGraphics, minecraft, window, gui, player);
            }
        });
    }

    private static void renderAetherPortalOverlay(GuiGraphics guiGraphics, Minecraft minecraft, AetherPlayerAttachment handler, DeltaTracker partialTicks) {
        if (minecraft.options.hideGui) {
            return;
        }
        float timeInPortal = Mth.lerp((float)partialTicks.getGameTimeDeltaPartialTick(false), (float)handler.getOldPortalIntensity(), (float)handler.getPortalIntensity());
        if (timeInPortal > 0.0f) {
            if (timeInPortal < 1.0f) {
                timeInPortal *= timeInPortal;
                timeInPortal *= timeInPortal;
                timeInPortal = timeInPortal * 0.8f + 0.2f;
            }
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, timeInPortal);
            TextureAtlasSprite textureatlassprite = minecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon(((AetherPortalBlock)((Object)AetherBlocks.AETHER_PORTAL.get())).defaultBlockState());
            guiGraphics.blit(0, 0, -90, guiGraphics.guiWidth(), guiGraphics.guiHeight(), textureatlassprite);
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private static void renderInebriationOverlay(GuiGraphics guiGraphics, Minecraft minecraft, Window window, Player player) {
        if (minecraft.options.hideGui) {
            return;
        }
        MobEffectInstance inebriation = player.getEffect(AetherEffects.INEBRIATION);
        double effectScale = (Double)minecraft.options.screenEffectScale().get();
        if (inebriation != null) {
            float inebriationDuration = (float)(inebriation.getDuration() % 50) / 50.0f;
            float alpha = inebriationDuration * inebriationDuration / 5.0f + 0.4f;
            AetherOverlays.renderVignette(guiGraphics, window, effectScale, alpha, TEXTURE_INEBRIATION_VIGNETTE);
        }
    }

    private static void renderRemedyOverlay(GuiGraphics guiGraphics, Minecraft minecraft, Window window, Player player) {
        if (minecraft.options.hideGui) {
            return;
        }
        MobEffectInstance remedy = player.getEffect(AetherEffects.REMEDY);
        double effectScale = (Double)minecraft.options.screenEffectScale().get();
        if (remedy != null) {
            int remedyStartDuration = ((AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER)).getRemedyStartDuration();
            int remedyDuration = remedy.getDuration();
            if (remedyStartDuration > 0 && remedyDuration > 0) {
                float alpha = (float)remedyDuration / (float)remedyStartDuration / 1.5f;
                AetherOverlays.renderVignette(guiGraphics, window, effectScale, alpha, TEXTURE_REMEDY_VIGNETTE);
            }
        }
    }

    private static void renderRepulsionOverlay(GuiGraphics guiGraphics, Minecraft minecraft, Window window, Player player) {
        if (minecraft.options.hideGui) {
            return;
        }
        AetherPlayerAttachment handler = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
        int projectileImpactedMaximum = handler.getProjectileImpactedMaximum();
        int projectileImpactedTimer = handler.getProjectileImpactedTimer();
        double effectScale = (Double)minecraft.options.screenEffectScale().get();
        if (projectileImpactedTimer > 0) {
            float alpha = (float)projectileImpactedTimer / (float)projectileImpactedMaximum;
            AetherOverlays.renderVignette(guiGraphics, window, effectScale, alpha, TEXTURE_SHIELD_OF_REPULSION_VIGNETTE);
        }
    }

    private static void renderVignette(GuiGraphics guiGraphics, Window window, double effectScale, float alpha, ResourceLocation resource) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, alpha *= (float)Math.sqrt(effectScale));
        guiGraphics.blit(resource, 0, 0, -90, 0.0f, 0.0f, window.getGuiScaledWidth(), window.getGuiScaledHeight(), window.getGuiScaledWidth(), window.getGuiScaledHeight());
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        poseStack.popPose();
    }

    private static void renderHammerCooldownOverlay(GuiGraphics guiGraphics, Minecraft minecraft, Window window, LocalPlayer player) {
        Inventory inventory;
        if (((Boolean)AetherConfig.CLIENT.enable_hammer_cooldown_overlay.get()).booleanValue() && !minecraft.options.hideGui && (inventory = player.getInventory()).contains(itemStack -> itemStack.is((Item)AetherItems.HAMMER_OF_KINGBDOGZ.get()))) {
            ArrayList items = new ArrayList(inventory.items);
            items.addAll(inventory.offhand);
            for (ItemStack itemStack2 : items) {
                float cooldownPercent;
                Item item = itemStack2.getItem();
                if (item != AetherItems.HAMMER_OF_KINGBDOGZ.get() || !((cooldownPercent = player.getCooldowns().getCooldownPercent(item, 0.0f)) > 0.0f)) continue;
                if (player.getMainHandItem().getItem() == item) {
                    itemStack2 = player.getMainHandItem();
                } else if (player.getOffhandItem().getItem() == item) {
                    itemStack2 = player.getOffhandItem();
                }
                String text = itemStack2.getHoverName().getString().concat(" ").concat(Component.translatable((String)"aether.hammer_of_kingbdogz_cooldown").getString());
                guiGraphics.drawString(minecraft.font, text, (int)((float)window.getGuiScaledWidth() / 2.0f - (float)minecraft.font.width(text) / 2.0f), 32, 0xFFFFFF);
                guiGraphics.blitSprite(TEXTURE_COOLDOWN_BAR_BACKGROUND, 128, 8, 0, 0, window.getGuiScaledWidth() / 2 - 64, 42, 128, 8);
                guiGraphics.blitSprite(TEXTURE_COOLDOWN_BAR, 128, 8, 0, 0, window.getGuiScaledWidth() / 2 - 64, 42, (int)(cooldownPercent * 128.0f), 8);
                break;
            }
        }
    }

    private static void renderMoaJumps(GuiGraphics guiGraphics, Window window, LocalPlayer player) {
        Entity entity = player.getVehicle();
        if (entity instanceof Moa) {
            Moa moa = (Moa)entity;
            if (!Minecraft.getInstance().options.hideGui) {
                for (int jumpCount = 0; jumpCount < moa.getMaxJumps(); ++jumpCount) {
                    int xPos = window.getGuiScaledWidth() / 2 + jumpCount * 8 - moa.getMaxJumps() * 8 / 2;
                    int yPos = 18;
                    guiGraphics.blitSprite(AetherOverlays.appendBackground(jumpCount >= moa.getRemainingJumps(), AetherOverlays.getMoaJumpTexture(moa, jumpCount)), xPos, yPos, 9, 11);
                }
            }
        }
    }

    private static ResourceLocation getMoaJumpTexture(Moa moa, double count) {
        AttributeInstance instance = moa.getAttribute((Holder)AetherAttributes.MOA_MAX_JUMPS);
        if (instance != null) {
            if (count < instance.getBaseValue()) {
                return AetherOverlays.getDefaultJumpsTexture(moa.getMoaType());
            }
            Set modifiers = instance.getModifiers();
            double currentCount = instance.getBaseValue();
            for (AttributeModifier modifier : modifiers) {
                currentCount = modifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE ? (currentCount += instance.getBaseValue() * modifier.amount()) : (currentCount += modifier.amount());
                if (!(currentCount >= count)) continue;
                return moa.getOverlayTexture(modifier.id());
            }
        }
        return TEXTURE_DEFAULT_JUMPS;
    }

    public static ResourceLocation getDefaultJumpsTexture(@Nullable MoaType type) {
        if (type == null) {
            return TEXTURE_DEFAULT_JUMPS;
        }
        return type.jumpsTexture().isPresent() ? type.jumpsTexture().get() : TEXTURE_DEFAULT_JUMPS;
    }

    private static ResourceLocation appendBackground(boolean background, ResourceLocation location) {
        if (background) {
            return location.withSuffix("_background");
        }
        return location;
    }

    private static void renderSilverLifeShardHearts(GuiGraphics guiGraphics, Minecraft minecraft, Window window, Gui gui, LocalPlayer player) {
        AttributeInstance attributeInstance;
        AetherPlayerAttachment aetherPlayer;
        GuiAccessor guiAccessor = (GuiAccessor)gui;
        if (((Boolean)AetherConfig.CLIENT.enable_silver_hearts.get()).booleanValue() && minecraft.gameMode.canHurtPlayer() && !minecraft.options.hideGui && (aetherPlayer = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER)).getLifeShardCount() > 0 && (attributeInstance = player.getAttribute(Attributes.MAX_HEALTH)) != null) {
            boolean highlight;
            int lastLifeShardHealth = 0;
            int lastOverallHealth = 0;
            RenderSystem.enableBlend();
            double overallHealth = attributeInstance.getValue();
            double maxLifeShardHealth = aetherPlayer.getLifeShardHealthAttributeModifier().amount();
            int maxDefaultHealth = Mth.ceil((double)(overallHealth - maxLifeShardHealth));
            int currentOverallHealth = Mth.ceil((float)player.getHealth());
            int currentLifeShardHealth = Mth.ceil((double)(maxDefaultHealth > 20 ? Mth.clamp((double)(currentOverallHealth - 20), (double)0.0, (double)maxLifeShardHealth) : (double)Math.min(player.getHealth(), (float)(currentOverallHealth - maxDefaultHealth))));
            boolean bl = highlight = guiAccessor.aether$getHealthBlinkTime() > (long)gui.getGuiTicks() && (guiAccessor.aether$getHealthBlinkTime() - (long)gui.getGuiTicks()) / 3L % 2L == 1L;
            if (Util.getMillis() - guiAccessor.aether$getLastHealthTime() > 1000L) {
                lastOverallHealth = currentOverallHealth;
                lastLifeShardHealth = currentLifeShardHealth;
            }
            guiAccessor.aether$getRandom().setSeed((long)gui.getGuiTicks() * 312871L);
            float displayOverallHealth = Math.max((float)overallHealth, (float)Math.max(lastOverallHealth, currentOverallHealth));
            float displayLifeShardHealth = Math.max((float)maxLifeShardHealth, (float)Math.max(lastLifeShardHealth, currentLifeShardHealth));
            int absorption = Mth.ceil((float)player.getAbsorptionAmount());
            int healthRows = Mth.ceil((float)((displayOverallHealth + (float)absorption) / 2.0f / 10.0f));
            int rowHeight = Math.max(10 - (healthRows - 2), 3);
            int left = window.getGuiScaledWidth() / 2 - 91;
            int top = window.getGuiScaledHeight() - 39;
            int regen = Integer.MIN_VALUE;
            if (player.hasEffect(MobEffects.REGENERATION)) {
                regen = gui.getGuiTicks() % Mth.ceil((float)(displayOverallHealth + 5.0f));
            }
            AetherOverlays.renderHearts(guiGraphics, (Player)player, gui, left, top, regen, displayOverallHealth, displayLifeShardHealth, maxDefaultHealth, currentLifeShardHealth, rowHeight, absorption, highlight);
            RenderSystem.disableBlend();
        }
    }

    private static void renderHearts(GuiGraphics guiGraphics, Player player, Gui gui, int left, int top, int regen, float displayOverallHealth, float displayLifeShardHealth, int maxDefaultHealth, int lifeShardHealth, int rowHeight, int absorption, boolean highlight) {
        GuiAccessor guiAccessor = (GuiAccessor)gui;
        Gui.HeartType heartType = HeartTypeAccessor.callForPlayer(player);
        int overallHearts = Mth.ceil((double)((double)displayOverallHealth / 2.0));
        int lifeShardHearts = Mth.ceil((double)((double)displayLifeShardHealth / 2.0));
        int maxDefaultHearts = Mth.ceil((double)((double)maxDefaultHealth / 2.0));
        boolean tooManyHearts = overallHearts > 50;
        boolean tooLittleHearts = maxDefaultHearts < 10 && maxDefaultHearts > 0;
        for (int currentHeart = Math.min(overallHearts, lifeShardHearts - 1); currentHeart >= 0; --currentHeart) {
            boolean halfHeart;
            int x = left + (currentHeart + (tooLittleHearts ? overallHearts - lifeShardHearts : 0)) % 10 * 8;
            int y = top - (currentHeart + (tooManyHearts ? 0 : (maxDefaultHearts + currentHeart < 10 ? 0 : 10))) / 10 * rowHeight;
            if (Mth.ceil((float)player.getHealth()) + absorption <= 4) {
                y += guiAccessor.aether$getRandom().nextInt(2);
            }
            if (currentHeart + (maxDefaultHearts > 10 ? overallHearts - 10 : maxDefaultHearts) < overallHearts && currentHeart + Math.min(maxDefaultHearts, 10) - (tooManyHearts ? overallHearts : 0) == regen) {
                y -= 2;
            }
            int selectedContainer = currentHeart * 2;
            if (highlight && (float)selectedContainer < displayLifeShardHealth) {
                halfHeart = (float)(selectedContainer + 1) == displayLifeShardHealth;
                guiGraphics.blitSprite(AetherOverlays.getSprite(heartType, halfHeart, true), x, y, 9, 9);
            }
            if (selectedContainer >= lifeShardHealth) continue;
            halfHeart = selectedContainer + 1 == lifeShardHealth;
            guiGraphics.blitSprite(AetherOverlays.getSprite(heartType, halfHeart, false), x, y, 9, 9);
        }
    }

    private static ResourceLocation getSprite(Gui.HeartType heartType, boolean halfHeart, boolean blinking) {
        if (heartType == Gui.HeartType.NORMAL) {
            if (!halfHeart) {
                return !blinking ? TEXTURE_LIFE_SHARD_FULL : TEXTURE_LIFE_SHARD_FULL_BLINKING;
            }
            return !blinking ? TEXTURE_LIFE_SHARD_HALF : TEXTURE_LIFE_SHARD_HALF_BLINKING;
        }
        if (heartType == Gui.HeartType.POISIONED) {
            if (!halfHeart) {
                return !blinking ? TEXTURE_LIFE_SHARD_POISONED_FULL : TEXTURE_LIFE_SHARD_POISONED_FULL_BLINKING;
            }
            return !blinking ? TEXTURE_LIFE_SHARD_POISONED_HALF : TEXTURE_LIFE_SHARD_POISONED_HALF_BLINKING;
        }
        if (heartType == Gui.HeartType.WITHERED) {
            if (!halfHeart) {
                return !blinking ? TEXTURE_LIFE_SHARD_WITHERED_FULL : TEXTURE_LIFE_SHARD_WITHERED_FULL_BLINKING;
            }
            return !blinking ? TEXTURE_LIFE_SHARD_WITHERED_HALF : TEXTURE_LIFE_SHARD_WITHERED_HALF_BLINKING;
        }
        if (heartType == Gui.HeartType.ABSORBING) {
            return !halfHeart ? TEXTURE_LIFE_SHARD_ABSORBING_FULL : TEXTURE_LIFE_SHARD_ABSORBING_HALF;
        }
        if (heartType == Gui.HeartType.FROZEN) {
            return !halfHeart ? TEXTURE_LIFE_SHARD_FROZEN_FULL : TEXTURE_LIFE_SHARD_FROZEN_HALF;
        }
        return Gui.HeartType.CONTAINER.getSprite(false, halfHeart, blinking);
    }
}

