/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.client.AetherAtlases;
import com.aetherteam.aether.client.AetherColorResolvers;
import com.aetherteam.aether.client.AetherKeys;
import com.aetherteam.aether.client.AetherRecipeCategories;
import com.aetherteam.aether.client.event.listeners.AudioListener;
import com.aetherteam.aether.client.event.listeners.DimensionClientListener;
import com.aetherteam.aether.client.event.listeners.GuiListener;
import com.aetherteam.aether.client.event.listeners.LevelClientListener;
import com.aetherteam.aether.client.event.listeners.MenuListener;
import com.aetherteam.aether.client.event.listeners.abilities.AccessoryAbilityClientListener;
import com.aetherteam.aether.client.event.listeners.capability.AetherPlayerClientListener;
import com.aetherteam.aether.client.gui.screen.inventory.SunAltarScreen;
import com.aetherteam.aether.client.gui.screen.menu.AetherReceivingLevelScreen;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.client.renderer.AetherOverlays;
import com.aetherteam.aether.client.renderer.AetherRenderers;
import com.aetherteam.aether.client.renderer.level.AetherRenderEffects;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.event.hooks.AbilityHooks;
import com.aetherteam.aether.inventory.menu.AetherMenuTypes;
import com.aetherteam.aether.inventory.menu.LoreBookMenu;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.perk.CustomizationsOptions;
import com.aetherteam.nitrogen.event.listeners.TooltipListeners;
import com.google.common.reflect.Reflection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionTransitionScreenEvent;
import net.neoforged.neoforge.client.event.RegisterEntitySpectatorShadersEvent;
import net.neoforged.neoforge.common.NeoForge;

public class AetherClient {
    public static void clientInit(IEventBus bus) {
        bus.addListener(AetherClient::clientSetup);
        bus.addListener(AetherClient::registerSpectatorShaders);
        bus.addListener(AetherClient::registerDimensionTransitionScreens);
        AetherClient.eventSetup(bus);
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        Reflection.initialize((Class[])new Class[]{CustomizationsOptions.class});
        AetherRenderers.registerAccessoryRenderers();
        event.enqueueWork(() -> {
            AetherAtlases.registerTreasureChestAtlases();
            AetherAtlases.registerWoodTypeAtlases();
            AetherClient.registerItemModelProperties();
            AetherClient.registerTooltipOverrides();
        });
        AetherClient.registerLoreOverrides();
    }

    public static void registerItemModelProperties() {
        ItemProperties.register((Item)((Item)AetherItems.PHOENIX_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (stack, world, living, i) -> living != null && living.isUsingItem() && living.getUseItem() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)AetherItems.PHOENIX_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (stack, world, living, i) -> living != null ? (living.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(living) - living.getUseItemRemainingTicks()) / 20.0f) : 0.0f);
        ItemProperties.register((Item)((Item)AetherItems.CANDY_CANE_SWORD.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"named"), (stack, world, living, i) -> stack.getHoverName().getString().equalsIgnoreCase("green candy cane sword") ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)AetherItems.HAMMER_OF_KINGBDOGZ.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"named"), (stack, world, living, i) -> stack.getHoverName().getString().equalsIgnoreCase("hammer of jeb") ? 1.0f : 0.0f);
    }

    public static void registerTooltipOverrides() {
        TooltipListeners.PREDICATES.put(AetherItems.BLUE_GUMMY_SWET, (player, stack, components, context, component) -> {
            TranslatableContents contents;
            ComponentContents patt0$temp;
            if (((Boolean)AetherConfig.SERVER.healing_gummy_swets.get()).booleanValue() && (patt0$temp = component.getContents()) instanceof TranslatableContents && (contents = (TranslatableContents)patt0$temp).getKey().endsWith(".1")) {
                return Component.translatable((String)(contents.getKey() + ".health"));
            }
            return component;
        });
        TooltipListeners.PREDICATES.put(AetherItems.GOLDEN_GUMMY_SWET, (player, stack, components, context, component) -> {
            TranslatableContents contents;
            ComponentContents patt0$temp;
            if (((Boolean)AetherConfig.SERVER.healing_gummy_swets.get()).booleanValue() && (patt0$temp = component.getContents()) instanceof TranslatableContents && (contents = (TranslatableContents)patt0$temp).getKey().endsWith(".1")) {
                return Component.translatable((String)(contents.getKey() + ".health"));
            }
            return component;
        });
        TooltipListeners.PREDICATES.put(AetherItems.LIFE_SHARD, (player, stack, components, context, component) -> {
            TranslatableContents contents;
            ComponentContents patt0$temp = component.getContents();
            if (patt0$temp instanceof TranslatableContents && (contents = (TranslatableContents)patt0$temp).getKey().endsWith(".1")) {
                return Component.translatable((String)contents.getKey(), (Object[])new Object[]{AetherConfig.SERVER.maximum_life_shards.get()});
            }
            return component;
        });
    }

    public static void registerLoreOverrides() {
        LoreBookMenu.addLoreEntryOverride(registryAccess -> stack -> stack.is((Item)AetherItems.HAMMER_OF_KINGBDOGZ.get()) && stack.getHoverName().getString().equalsIgnoreCase("hammer of jeb"), "lore.item.aether.hammer_of_jeb");
        LoreBookMenu.addLoreEntryOverride(registryAccess -> stack -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)AetherItems.createSwetBannerItemStack((HolderGetter<BannerPattern>)registryAccess.registryOrThrow(Registries.BANNER_PATTERN).asLookup())), "lore.item.aether.swet_banner");
    }

    public static void eventSetup(IEventBus neoBus) {
        IEventBus bus = NeoForge.EVENT_BUS;
        AccessoryAbilityClientListener.listen(bus);
        AetherPlayerClientListener.listen(bus);
        AudioListener.listen(bus);
        DimensionClientListener.listen(bus);
        GuiListener.listen(bus);
        LevelClientListener.listen(bus);
        MenuListener.listen(bus);
        bus.addListener(event -> AbilityHooks.ToolHooks.resetDebuffToolsState());
        neoBus.addListener(AetherMenuTypes::registerMenuScreens);
        neoBus.addListener(AetherColorResolvers::registerBlockColor);
        neoBus.addListener(AetherColorResolvers::registerItemColor);
        neoBus.addListener(AetherKeys::registerKeyMappings);
        neoBus.addListener(AetherRecipeCategories::registerRecipeCategories);
        neoBus.addListener(AetherParticleTypes::registerParticleFactories);
        neoBus.addListener(AetherOverlays::registerOverlays);
        neoBus.addListener(AetherRenderers::registerEntityRenderers);
        neoBus.addListener(AetherRenderers::registerLayerDefinitions);
        neoBus.addListener(AetherRenderers::addEntityLayers);
        neoBus.addListener(AetherRenderers::bakeModels);
        neoBus.addListener(AetherRenderEffects::registerRenderEffects);
    }

    public static void registerSpectatorShaders(RegisterEntitySpectatorShadersEvent event) {
        event.register((EntityType)AetherEntityTypes.SUN_SPIRIT.get(), ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"shaders/post/sun_spirit.json"));
    }

    public static void registerDimensionTransitionScreens(RegisterDimensionTransitionScreenEvent event) {
        event.registerIncomingEffect(AetherDimensions.AETHER_LEVEL, AetherReceivingLevelScreen::new);
        event.registerOutgoingEffect(AetherDimensions.AETHER_LEVEL, AetherReceivingLevelScreen::new);
    }

    public static void setToSunAltarScreen(Component name, int timeScale) {
        Minecraft.getInstance().setScreen((Screen)new SunAltarScreen(name, timeScale));
    }
}

