/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import java.util.HashMap;
import java.util.Map;

public class MobAccessoryAttachment {
    private final Map<String, Float> accessoryDropChances;
    public static final Codec<MobAccessoryAttachment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT).fieldOf("drop_chances").forGetter(MobAccessoryAttachment::getAccessoryDropChances)).apply((Applicative)instance, MobAccessoryAttachment::new));

    public MobAccessoryAttachment() {
        this.accessoryDropChances = new HashMap<String, Float>(Map.ofEntries(Map.entry("hand", Float.valueOf(0.085f)), Map.entry("necklace", Float.valueOf(0.085f)), Map.entry("aether:gloves_slot", Float.valueOf(0.085f)), Map.entry("aether:pendant_slot", Float.valueOf(0.085f))));
    }

    private MobAccessoryAttachment(Map<String, Float> dropChances) {
        this.accessoryDropChances = new HashMap<String, Float>(dropChances);
    }

    public void setGuaranteedDrop(SlotTypeReference identifier) {
        if (this.accessoryDropChances.containsKey(identifier.slotName())) {
            this.getAccessoryDropChances().put(identifier.slotName(), Float.valueOf(2.0f));
        }
    }

    public float getEquipmentDropChance(SlotTypeReference identifier) {
        if (this.accessoryDropChances.containsKey(identifier.slotName())) {
            return this.getAccessoryDropChances().get(identifier.slotName()).floatValue();
        }
        return 0.0f;
    }

    public void setDropChance(SlotTypeReference identifier, float chance) {
        if (this.accessoryDropChances.containsKey(identifier.slotName())) {
            this.getAccessoryDropChances().put(identifier.slotName(), Float.valueOf(chance));
        }
    }

    public Map<String, Float> getAccessoryDropChances() {
        return this.accessoryDropChances;
    }
}

