/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.mehvahdjukaar.amendments.common.recipe.CauldronCraftingContainer;
import net.mehvahdjukaar.amendments.common.recipe.CompactItemSet;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemCraftResult;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemsCraftResult;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CauldronRecipeUtils {
    @Nullable
    public static FluidAndItemsCraftResult craftMultiple(Level level, boolean boiling, int tankCapacity, SoftFluidStack currentFluid, List<ItemStack> inputItems) {
        FluidAndItemCraftResult currentResult;
        boolean success = false;
        CompactItemSet craftedItems = new CompactItemSet();
        do {
            if ((currentResult = CauldronRecipeUtils.craft(level, boiling, tankCapacity, currentFluid, inputItems)) == null) continue;
            success = true;
            currentFluid = currentResult.resultFluid();
            craftedItems.add(currentResult.craftedItem());
        } while (currentResult != null);
        if (!success) {
            return null;
        }
        return FluidAndItemsCraftResult.of(craftedItems.toList(), currentFluid);
    }

    @Nullable
    public static FluidAndItemCraftResult craft(Level level, boolean boiling, int tankCapacity, SoftFluidStack fluidStack, List<ItemStack> items) {
        if (fluidStack.isEmpty()) {
            return null;
        }
        FluidAndItemCraftResult crafted = CauldronRecipeUtils.craftFluidSpecial(level, boiling, tankCapacity, fluidStack, items);
        if (crafted != null) {
            return crafted;
        }
        if (boiling || !fluidStack.is(MLBuiltinSoftFluids.WATER)) {
            crafted = CauldronRecipeUtils.craftItemSingle(level, boiling, tankCapacity, fluidStack, items);
            if (crafted != null) {
                return crafted;
            }
            crafted = CauldronRecipeUtils.craftItemSplit(level, boiling, tankCapacity, fluidStack, items);
            if (crafted != null) {
                return crafted;
            }
            if (items.size() == 1) {
                crafted = CauldronRecipeUtils.craftItemSurround(level, boiling, tankCapacity, fluidStack, items.getFirst());
                return crafted;
            }
        }
        return null;
    }

    private static List<ItemStack> expandItems(List<ItemStack> items) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (ItemStack stack : items) {
            int count = stack.getCount();
            for (int i = 0; i < count; ++i) {
                itemList.add(stack.copyWithCount(1));
            }
        }
        return itemList;
    }

    @Nullable
    private static FluidAndItemCraftResult craftItemSingle(Level level, boolean boiling, int tankCapacity, SoftFluidStack fluid, Collection<ItemStack> item) {
        CauldronCraftingContainer container = CauldronCraftingContainer.of(boiling, tankCapacity, fluid, item);
        FluidAndItemCraftResult result = container.craftWithCraftingRecipes(level);
        if (result != null) {
            for (ItemStack i : item) {
                if (i.isEmpty()) continue;
                i.shrink(1);
            }
            return result;
        }
        return null;
    }

    @Nullable
    private static FluidAndItemCraftResult craftItemSplit(Level level, boolean boiling, int tankCapacity, SoftFluidStack fluid, Collection<ItemStack> item) {
        List<ItemStack> expandedItems = CauldronRecipeUtils.expandItems(new ArrayList<ItemStack>(item));
        CauldronCraftingContainer container = CauldronCraftingContainer.of(boiling, tankCapacity, fluid, expandedItems);
        FluidAndItemCraftResult result = container.craftWithCraftingRecipes(level);
        if (result != null) {
            block0: for (ItemStack i : expandedItems) {
                if (i.isEmpty()) continue;
                for (ItemStack orig : item) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)i, (ItemStack)orig)) continue;
                    orig.shrink(1);
                    continue block0;
                }
            }
            return result;
        }
        return null;
    }

    @Nullable
    private static FluidAndItemCraftResult craftItemSurround(Level level, boolean boiling, int tankCapacity, SoftFluidStack fluid, ItemStack item) {
        if (item.getCount() < 8) {
            return null;
        }
        CauldronCraftingContainer container = CauldronCraftingContainer.surround8(boiling, tankCapacity, fluid, item);
        FluidAndItemCraftResult result8x = container.craftWithCraftingRecipes(level);
        if (result8x != null) {
            item.shrink(8);
            return result8x;
        }
        return null;
    }

    @Nullable
    public static FluidAndItemCraftResult craftFluidSpecial(Level level, boolean boiling, int tankCapacity, SoftFluidStack softFluidStack, Collection<ItemStack> items) {
        CauldronCraftingContainer container = CauldronCraftingContainer.of(boiling, tankCapacity, softFluidStack, items);
        FluidAndItemCraftResult crafted = container.craftWithCauldronRecipes(level);
        if (crafted != null) {
            for (ItemStack i : items) {
                if (i.isEmpty()) continue;
                i.shrink(1);
            }
            return crafted;
        }
        return null;
    }
}

