/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.markerhandler;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import twilightforest.init.custom.TemplateMarkerHandlers;
import twilightforest.util.Codecs;
import twilightforest.world.components.structures.markerhandler.TemplateMarkerHandler;
import twilightforest.world.components.structures.markerhandler.TemplateMarkerHandlerType;

public record SwitchMarkerHandler(char groupDelimiter, String safeGroupSplitter, char entryDelimiter, String safeEntrySplitter, Map<String, Holder<TemplateMarkerHandler>> handlers) implements TemplateMarkerHandler
{
    public static final MapCodec<SwitchMarkerHandler> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codecs.CHARACTER_CODEC.optionalFieldOf("group_character_delimiter", (Object)Character.valueOf('|')).forGetter(SwitchMarkerHandler::groupDelimiter), (App)Codecs.CHARACTER_CODEC.optionalFieldOf("entry_character_delimiter", (Object)Character.valueOf(':')).forGetter(SwitchMarkerHandler::entryDelimiter), (App)Codec.unboundedMap((Codec)Codec.STRING, TemplateMarkerHandlers.HOLDER_CODEC).fieldOf("element_processor").forGetter(SwitchMarkerHandler::handlers)).apply((Applicative)instance, SwitchMarkerHandler::new));

    public SwitchMarkerHandler(char groupDelimiter, char entryDelimiter, Map<String, Holder<TemplateMarkerHandler>> elementProcessor) {
        this(groupDelimiter, Pattern.quote(String.valueOf(groupDelimiter)), entryDelimiter, Pattern.quote(String.valueOf(entryDelimiter)), elementProcessor);
    }

    public SwitchMarkerHandler(Map<String, Holder<TemplateMarkerHandler>> elementProcessor) {
        this('|', ':', elementProcessor);
    }

    @Override
    public boolean handleDataMarker(String label, BlockPos pos, WorldGenLevel level, RandomSource random, BoundingBox chunkBounds, ChunkGenerator chunkGen, Rotation rotation) {
        String[] groups = label.split(this.safeGroupSplitter);
        if (groups.length < 1) {
            return false;
        }
        for (int i = 0; i < groups.length; ++i) {
            int newIndex = random.nextInt(groups.length);
            groups[i] = groups[newIndex];
        }
        for (String group : groups) {
            String substring;
            Holder<TemplateMarkerHandler> templateMarkerHandlerHolder = this.handlers.get(group);
            if (templateMarkerHandlerHolder == null) continue;
            String[] entrySplit = group.split(this.safeEntrySplitter, 2);
            String string = substring = entrySplit.length < 2 ? "" : entrySplit[1];
            if (!((TemplateMarkerHandler)templateMarkerHandlerHolder.value()).handleDataMarker(substring, pos, level, random, chunkBounds, chunkGen, rotation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TemplateMarkerHandlerType getType() {
        return (TemplateMarkerHandlerType)TemplateMarkerHandlers.HANDLER_SWITCH.value();
    }
}

