/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.markerhandler;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.loot.LootTable;
import twilightforest.block.DryingRackBlock;
import twilightforest.block.entity.DryingRackBlockEntity;
import twilightforest.init.custom.TemplateMarkerHandlers;
import twilightforest.world.components.structures.markerhandler.TemplateMarkerHandler;
import twilightforest.world.components.structures.markerhandler.TemplateMarkerHandlerType;

public record DryingRackMarkerHandler(BlockStateProvider provider, ResourceKey<LootTable> lootTable) implements TemplateMarkerHandler
{
    public static final MapCodec<DryingRackMarkerHandler> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("drying_rack_block").forGetter(DryingRackMarkerHandler::provider), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(DryingRackMarkerHandler::lootTable)).apply((Applicative)instance, DryingRackMarkerHandler::new));

    @Override
    public boolean handleDataMarker(String label, BlockPos pos, WorldGenLevel level, RandomSource random, BoundingBox chunkBounds, ChunkGenerator chunkGen, Rotation rotation) {
        BlockState state = this.provider.getState(random, pos).rotate(rotation);
        if (!(state.getBlock() instanceof DryingRackBlock) || !level.setBlock(pos, state, 3)) {
            return false;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof DryingRackBlockEntity)) {
            return false;
        }
        DryingRackBlockEntity dryingRackBlock = (DryingRackBlockEntity)blockEntity;
        return dryingRackBlock.fillFromLootTable(this.lootTable, random.nextLong(), level.getLevel());
    }

    @Override
    public TemplateMarkerHandlerType getType() {
        return (TemplateMarkerHandlerType)TemplateMarkerHandlers.DRYING_RACK.value();
    }
}

