/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item.travellers_gear.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import twilightforest.item.travellers_gear.modifiers.InsertableTravellersModifier;
import twilightforest.item.travellers_gear.modifiers.TravellersModifier;

public record TravellersEntryModifier(EquipmentSlotGroup group, List<ItemAttributeModifiers.Entry> modifiers, DataComponentType<Unit> markerComponent, List<Component> description, boolean builtin) implements InsertableTravellersModifier
{
    public static final MapCodec<TravellersEntryModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EquipmentSlotGroup.CODEC.fieldOf("equipment_slots").validate(TravellersModifier::validateEquipment).forGetter(TravellersEntryModifier::group), (App)ItemAttributeModifiers.Entry.CODEC.listOf().fieldOf("attribute_modifiers").forGetter(TravellersEntryModifier::modifiers), (App)DataComponentType.CODEC.fieldOf("component").xmap(component -> component, object -> object).forGetter(TravellersEntryModifier::markerComponent), (App)ComponentSerialization.CODEC.listOf().optionalFieldOf("description", List.of()).forGetter(TravellersEntryModifier::description), (App)Codec.BOOL.fieldOf("builtin_modifier").orElse((Object)false).forGetter(TravellersEntryModifier::builtin)).apply((Applicative)instance, TravellersEntryModifier::new));

    public TravellersEntryModifier(EquipmentSlotGroup group, List<ItemAttributeModifiers.Entry> modifiers, Supplier<DataComponentType<Unit>> markerComponent, List<Component> description, boolean builtin) {
        this(group, modifiers, markerComponent.get(), description, builtin);
    }

    public TravellersEntryModifier(EquipmentSlotGroup group, List<ItemAttributeModifiers.Entry> modifiers, Supplier<DataComponentType<Unit>> markerComponent, boolean builtin) {
        this(group, modifiers, markerComponent, List.of(), builtin);
    }

    @Override
    public MapCodec<? extends TravellersModifier> codec() {
        return CODEC;
    }

    @Override
    public boolean addModifier(ItemStack stack) {
        if (!this.builtin()) {
            ItemAttributeModifiers modifiers = stack.getAttributeModifiers();
            for (ItemAttributeModifiers.Entry entry : this.modifiers()) {
                modifiers = modifiers.withModifierAdded(entry.attribute(), entry.modifier(), entry.slot());
            }
            stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)modifiers);
        }
        stack.set(this.markerComponent(), (Object)Unit.INSTANCE);
        return true;
    }

    @Override
    public void removeModifier(ItemStack stack) {
        if (!this.builtin()) {
            ArrayList newEntries = new ArrayList();
            ItemAttributeModifiers modifiers = stack.getAttributeModifiers();
            modifiers.modifiers().forEach(entry -> {
                if (!this.modifiers().contains(entry)) {
                    newEntries.add(entry);
                }
            });
            stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)new ItemAttributeModifiers(newEntries, modifiers.showInTooltip()));
            stack.remove(this.markerComponent());
        }
    }

    @Override
    public boolean isAbility() {
        return this.builtin();
    }

    @Override
    public boolean hasModifier(ItemStack stack) {
        return stack.has(this.markerComponent());
    }

    @Override
    public List<Component> getDescription() {
        return this.description;
    }
}

