/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFBiomes;
import twilightforest.world.components.structures.type.AuroraPalaceStructure;
import twilightforest.world.components.structures.type.CampStructure;
import twilightforest.world.components.structures.type.DarkTowerStructure;
import twilightforest.world.components.structures.type.FallenTrunkStructure;
import twilightforest.world.components.structures.type.FinalCastleStructure;
import twilightforest.world.components.structures.type.GiantHouseStructure;
import twilightforest.world.components.structures.type.HedgeMazeStructure;
import twilightforest.world.components.structures.type.HollowHillStructure;
import twilightforest.world.components.structures.type.HollowTreeStructure;
import twilightforest.world.components.structures.type.HydraLairStructure;
import twilightforest.world.components.structures.type.KnightStrongholdStructure;
import twilightforest.world.components.structures.type.LabyrinthStructure;
import twilightforest.world.components.structures.type.LichTowerStructure;
import twilightforest.world.components.structures.type.MushroomTowerStructure;
import twilightforest.world.components.structures.type.NagaCourtyardStructure;
import twilightforest.world.components.structures.type.QuestGroveStructure;
import twilightforest.world.components.structures.type.TrollCaveStructure;
import twilightforest.world.components.structures.type.YetiCaveStructure;

public class TFStructures {
    public static final ResourceKey<Structure> HEDGE_MAZE = TFStructures.registerKey("hedge_maze");
    public static final ResourceKey<Structure> QUEST_GROVE = TFStructures.registerKey("quest_grove");
    public static final ResourceKey<Structure> HOLLOW_HILL_SMALL = TFStructures.registerKey("small_hollow_hill");
    public static final ResourceKey<Structure> HOLLOW_HILL_MEDIUM = TFStructures.registerKey("medium_hollow_hill");
    public static final ResourceKey<Structure> HOLLOW_HILL_LARGE = TFStructures.registerKey("large_hollow_hill");
    public static final ResourceKey<Structure> NAGA_COURTYARD = TFStructures.registerKey("naga_courtyard");
    public static final ResourceKey<Structure> LICH_TOWER = TFStructures.registerKey("lich_tower");
    public static final ResourceKey<Structure> LABYRINTH = TFStructures.registerKey("labyrinth");
    public static final ResourceKey<Structure> HYDRA_LAIR = TFStructures.registerKey("hydra_lair");
    public static final ResourceKey<Structure> KNIGHT_STRONGHOLD = TFStructures.registerKey("knight_stronghold");
    public static final ResourceKey<Structure> DARK_TOWER = TFStructures.registerKey("dark_tower");
    public static final ResourceKey<Structure> YETI_CAVE = TFStructures.registerKey("yeti_cave");
    public static final ResourceKey<Structure> AURORA_PALACE = TFStructures.registerKey("aurora_palace");
    public static final ResourceKey<Structure> TROLL_CAVE = TFStructures.registerKey("troll_cave");
    public static final ResourceKey<Structure> GIANT_HOUSE = TFStructures.registerKey("giant_house");
    public static final ResourceKey<Structure> FINAL_CASTLE = TFStructures.registerKey("final_castle");
    public static final ResourceKey<Structure> FALLEN_TRUNK = TFStructures.registerKey("fallen_trunk");
    public static final ResourceKey<Structure> HOLLOW_TREE = TFStructures.registerKey("hollow_tree");
    public static final ResourceKey<Structure> SWAMP_HOLLOW_TREE = TFStructures.registerKey("swamp_hollow_tree");
    public static final ResourceKey<Structure> CAMP = TFStructures.registerKey("camp");
    public static final ResourceKey<Structure> MUSHROOM_TOWER = TFStructures.registerKey("mushroom_tower");
    public static final ResourceKey<Structure> QUEST_ISLAND = TFStructures.registerKey("quest_island");
    public static final ResourceKey<Structure> DRUID_GROVE = TFStructures.registerKey("druid_grove");
    public static final ResourceKey<Structure> FLOATING_RUINS = TFStructures.registerKey("floating_ruins");
    public static final ResourceKey<Structure> WORLD_TREE = TFStructures.registerKey("world_tree");

    public static ResourceKey<Structure> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static void bootstrap(BootstrapContext<Structure> context) {
        context.register(FALLEN_TRUNK, (Object)FallenTrunkStructure.buildStructureConfig((HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(BiomeTagGenerator.VALID_HOLLOW_TREE_BIOMES)));
        context.register(HOLLOW_TREE, (Object)HollowTreeStructure.buildStructureConfig(false, (HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(BiomeTagGenerator.VALID_HOLLOW_TREE_BIOMES)));
        context.register(SWAMP_HOLLOW_TREE, (Object)HollowTreeStructure.buildStructureConfig(true, (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(TFBiomes.SWAMP)})));
        context.register(CAMP, (Object)CampStructure.buildStructureConfig(context));
        context.register(HEDGE_MAZE, (Object)HedgeMazeStructure.buildStructureConfig(context));
        context.register(QUEST_GROVE, (Object)QuestGroveStructure.buildStructureConfig(context));
        context.register(HOLLOW_HILL_SMALL, (Object)HollowHillStructure.buildSmallHillConfig(context));
        context.register(HOLLOW_HILL_MEDIUM, (Object)HollowHillStructure.buildMediumHillConfig(context));
        context.register(HOLLOW_HILL_LARGE, (Object)HollowHillStructure.buildLargeHillConfig(context));
        context.register(NAGA_COURTYARD, (Object)NagaCourtyardStructure.buildStructureConfig(context));
        context.register(LICH_TOWER, (Object)LichTowerStructure.buildLichTowerConfig(context));
        context.register(LABYRINTH, (Object)LabyrinthStructure.buildLabyrinthConfig(context));
        context.register(HYDRA_LAIR, (Object)HydraLairStructure.buildHydraLairConfig(context));
        context.register(KNIGHT_STRONGHOLD, (Object)KnightStrongholdStructure.buildKnightStrongholdConfig(context));
        context.register(DARK_TOWER, (Object)DarkTowerStructure.buildDarkTowerConfig(context));
        context.register(YETI_CAVE, (Object)YetiCaveStructure.buildYetiCaveConfig(context));
        context.register(AURORA_PALACE, (Object)AuroraPalaceStructure.buildAuroraPalaceConfig(context));
        context.register(TROLL_CAVE, (Object)TrollCaveStructure.buildTrollCaveConfig(context));
        context.register(GIANT_HOUSE, (Object)GiantHouseStructure.buildGiantHouseConfig(context));
        context.register(FINAL_CASTLE, (Object)FinalCastleStructure.buildFinalCastleConfig(context));
        context.register(MUSHROOM_TOWER, (Object)MushroomTowerStructure.buildStructureConfig(context));
    }
}

