/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredItem;
import twilightforest.TwilightForestMod;
import twilightforest.beanification.Component;
import twilightforest.beanification.PostConstruct;
import twilightforest.block.KeepsakeCasketBlock;
import twilightforest.block.entity.SkullChestBlockEntity;
import twilightforest.compat.curios.CuriosCompat;
import twilightforest.config.TFConfig;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.enums.BlockLoggingEnum;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStats;
import twilightforest.network.SpawnCharmPacket;
import twilightforest.util.TFItemStackUtils;

@Component
public class CharmEvents {
    public static final String CHARM_INV_TAG = "TFCharmInventory";
    public static final String CASKET_DAMAGE_TAG = "CasketDamage";
    public static final String CONSUMED_CHARM_TAG = "CharmStack";

    @PostConstruct
    private void setup() {
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::applyCharmOfLife);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, this::applyKeepingAndCasket);
        NeoForge.EVENT_BUS.addListener(this::returnItemsOnRespawn);
    }

    private void applyCharmOfLife(LivingDeathEvent event) {
        Player player;
        block5: {
            block4: {
                LivingEntity living = event.getEntity();
                if (event.isCanceled() || living.level().isClientSide() || !(living instanceof Player)) break block4;
                player = (Player)living;
                if (!(living instanceof FakePlayer) && !player.isCreative() && !player.isSpectator()) break block5;
            }
            return;
        }
        if (CharmEvents.handleCharmOfLife(player)) {
            event.setCanceled(true);
        }
    }

    private void applyKeepingAndCasket(LivingDeathEvent event) {
        Player player;
        LivingEntity living;
        block5: {
            block4: {
                living = event.getEntity();
                if (event.isCanceled() || living.level().isClientSide() || !(living instanceof Player)) break block4;
                player = (Player)living;
                if (!(living instanceof FakePlayer) && !player.isCreative() && !player.isSpectator()) break block5;
            }
            return;
        }
        if (!living.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            CharmEvents.handleCharmOfKeeping(player);
            CharmEvents.stockKeepsakeCasket(player);
        }
    }

    private void returnItemsOnRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!event.isEndConquered()) {
            CharmEvents.returnStoredItems((Player)serverPlayer);
        }
    }

    private static boolean handleCharmOfLife(Player player) {
        boolean charm1;
        boolean charm2 = TFItemStackUtils.consumeInventoryItem(player, (ItemLike)TFItems.CHARM_OF_LIFE_2.get(), CharmEvents.getPlayerData(player), false) || CharmEvents.hasCharmCurio((Item)TFItems.CHARM_OF_LIFE_2.get(), player);
        boolean bl = charm1 = !charm2 && (TFItemStackUtils.consumeInventoryItem(player, (ItemLike)TFItems.CHARM_OF_LIFE_1.get(), CharmEvents.getPlayerData(player), false) || CharmEvents.hasCharmCurio((Item)TFItems.CHARM_OF_LIFE_1.get(), player));
        if (charm2 || charm1) {
            if (charm1) {
                player.setHealth(8.0f);
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 0));
            }
            if (charm2) {
                player.setHealth(player.getMaxHealth());
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 600, 3));
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 600, 0));
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 600, 0));
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SpawnCharmPacket(new ItemStack(charm1 ? (ItemLike)TFItems.CHARM_OF_LIFE_1.get() : (ItemLike)TFItems.CHARM_OF_LIFE_2.get()), (ResourceKey<SoundEvent>)TFSounds.CHARM_LIFE.getKey()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                serverPlayer.awardStat((ResourceLocation)TFStats.LIFE_CHARMS_ACTIVATED.get());
            }
            return true;
        }
        return false;
    }

    private static void handleCharmOfKeeping(Player player) {
        int i;
        Inventory keepInventory = new Inventory(player);
        ListTag tagList = new ListTag();
        if (!CharmEvents.applyCharm(TFItems.CHARM_OF_KEEPING_3, keepInventory, player, (List<ItemStack>)player.getInventory().items) && !CharmEvents.applyCharm(TFItems.CHARM_OF_KEEPING_2, keepInventory, player, player.getInventory().items.subList(0, 9)) && Inventory.isHotbarSlot((int)(i = player.getInventory().selected))) {
            CharmEvents.applyCharm(TFItems.CHARM_OF_KEEPING_1, keepInventory, player, (List<ItemStack>)NonNullList.of((Object)((ItemStack)player.getInventory().items.get(i)), (Object[])new ItemStack[0]));
        }
        for (i = 0; i < player.getInventory().items.size(); ++i) {
            ItemStack stack = (ItemStack)player.getInventory().items.get(i);
            if (!stack.is(ItemTagGenerator.KEPT_ON_DEATH)) continue;
            keepInventory.items.set(i, (Object)stack.copy());
            player.getInventory().items.set(i, (Object)ItemStack.EMPTY);
        }
        for (i = 0; i < player.getInventory().armor.size(); ++i) {
            ItemStack armor = (ItemStack)player.getInventory().armor.get(i);
            if (!armor.is(ItemTagGenerator.KEPT_ON_DEATH)) continue;
            keepInventory.armor.set(i, (Object)armor.copy());
            player.getInventory().armor.set(i, (Object)ItemStack.EMPTY);
        }
        if (((ItemStack)player.getInventory().offhand.getFirst()).is(ItemTagGenerator.KEPT_ON_DEATH)) {
            keepInventory.offhand.set(0, (Object)((ItemStack)player.getInventory().offhand.getFirst()).copy());
            player.getInventory().offhand.set(0, (Object)ItemStack.EMPTY);
        }
        if (!keepInventory.isEmpty()) {
            keepInventory.save(tagList);
            CharmEvents.getPlayerData(player).put(CHARM_INV_TAG, (Tag)tagList);
        }
    }

    private static boolean applyCharm(DeferredItem<Item> charm, Inventory keptInventory, Player player, List<ItemStack> inventorySlots) {
        ArrayList<ItemStack> mergedCheck = new ArrayList<ItemStack>(inventorySlots);
        mergedCheck.addAll((Collection<ItemStack>)player.getInventory().armor);
        mergedCheck.addAll((Collection<ItemStack>)player.getInventory().offhand);
        if (mergedCheck.stream().filter(stack -> !stack.is((Holder)charm)).allMatch(ItemStack::isEmpty)) {
            return false;
        }
        if (!TFItemStackUtils.consumeInventoryItem(player, charm, CharmEvents.getPlayerData(player), true) && !CharmEvents.hasCharmCurio((Item)charm.value(), player)) {
            return false;
        }
        boolean keptACasket = CharmEvents.keepWholeListAndCheckCasket((NonNullList<ItemStack>)keptInventory.items, inventorySlots, charm == TFItems.CHARM_OF_KEEPING_3);
        keptACasket = CharmEvents.keepWholeListAndCheckCasket((NonNullList<ItemStack>)keptInventory.armor, (List<ItemStack>)player.getInventory().armor, keptACasket);
        CharmEvents.keepWholeListAndCheckCasket((NonNullList<ItemStack>)keptInventory.offhand, (List<ItemStack>)player.getInventory().offhand, keptACasket);
        return true;
    }

    private static void stockKeepsakeCasket(Player player) {
        if (player.getInventory().hasAnyMatching(stack -> !stack.isEmpty() && !stack.is(TFItems.KEEPSAKE_CASKET))) {
            boolean casketConsumed = TFItemStackUtils.consumeInventoryItem(player, TFBlocks.KEEPSAKE_CASKET, CharmEvents.getPlayerData(player), false);
            if (!casketConsumed) {
                return;
            }
            Level level = player.level();
            BlockPos.MutableBlockPos pos = player.blockPosition().mutable();
            if (pos.getY() < level.dimensionType().minY() + 2) {
                pos.setY(level.dimensionType().minY() + 2);
            } else {
                int logicalHeight = player.level().dimensionType().logicalHeight();
                if (pos.getY() > logicalHeight) {
                    pos.setY(logicalHeight - 1);
                }
            }
            pos.move(0, -1, 0);
            do {
                pos.move(0, 1, 0);
            } while (!level.getBlockState((BlockPos)pos).canBeReplaced());
            BlockPos immutablePos = pos.immutable();
            FluidState fluidState = level.getFluidState(immutablePos);
            int damage = CharmEvents.getPlayerData(player).contains(CASKET_DAMAGE_TAG) ? CharmEvents.getPlayerData(player).getInt(CASKET_DAMAGE_TAG) : 0;
            BlockState setState = (BlockState)((BlockState)((BlockState)((Block)TFBlocks.KEEPSAKE_CASKET.get()).defaultBlockState().setValue(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.getFromFluid(fluidState.getType())))).setValue((Property)KeepsakeCasketBlock.BREAKAGE, (Comparable)Integer.valueOf(damage))).setValue((Property)KeepsakeCasketBlock.FACING, (Comparable)Direction.from2DDataValue((int)level.getRandom().nextInt(3)));
            if (player.getRandom().nextFloat() <= 0.15f) {
                if (damage >= 2) {
                    setState = ((Block)TFBlocks.SKULL_CHEST.get()).withPropertiesOf(setState);
                    TwilightForestMod.LOGGER.debug("{}'s Casket damage value was too high, placing Skull Chest instead", (Object)player.getName().getString());
                } else {
                    setState = (BlockState)((Block)TFBlocks.KEEPSAKE_CASKET.get()).withPropertiesOf(setState).setValue((Property)KeepsakeCasketBlock.BREAKAGE, (Comparable)Integer.valueOf(++damage));
                    TwilightForestMod.LOGGER.debug("{}'s Casket was randomly damaged, applying new damage", (Object)player.getName().getString());
                }
            }
            if (!level.setBlockAndUpdate(immutablePos, setState)) {
                TwilightForestMod.LOGGER.error("Could not place Keepsake Casket at {}", (Object)pos);
                return;
            }
            BlockEntity blockEntity = level.getBlockEntity(immutablePos);
            if (!(blockEntity instanceof SkullChestBlockEntity)) {
                TwilightForestMod.LOGGER.error("Failed to set Keepsake Casket data at {}", (Object)pos);
                return;
            }
            SkullChestBlockEntity casket = (SkullChestBlockEntity)blockEntity;
            casket.owner = TFConfig.casketUUIDLocking ? new ResolvableProfile(player.getGameProfile()) : null;
            String modifiedName = player.getName().getString().substring(0, Math.min(12, player.getName().getString().length()));
            casket.name = net.minecraft.network.chat.Component.literal((String)(modifiedName + "'s " + (level.getRandom().nextInt(1000) == 0 ? "Costco Casket" : casket.getDisplayName().getString())));
            int casketCapacity = casket.getContainerSize();
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(casketCapacity);
            NonNullList filler = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
            list.addAll((Collection<ItemStack>)TFItemStackUtils.sortArmorForCasket(player));
            player.getInventory().armor.clear();
            list.addAll((Collection<ItemStack>)filler);
            list.addAll((Collection<ItemStack>)player.getInventory().offhand);
            player.getInventory().offhand.clear();
            list.addAll((Collection<ItemStack>)TFItemStackUtils.sortInvForCasket(player));
            player.getInventory().items.clear();
            casket.setItems((NonNullList<ItemStack>)NonNullList.of((Object)ItemStack.EMPTY, (Object[])list.toArray(new ItemStack[casketCapacity])));
            CharmEvents.getPlayerData(player).remove(CASKET_DAMAGE_TAG);
        } else {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                if (!player.getInventory().getItem(i).is(TFItems.KEEPSAKE_CASKET)) continue;
                Inventory tmp = new Inventory(player);
                tmp.load(CharmEvents.getPlayerData(player).getList(CHARM_INV_TAG, 10));
                tmp.add(player.getInventory().getItem(i).copy());
                player.getInventory().setItem(i, ItemStack.EMPTY);
                CharmEvents.getPlayerData(player).put(CHARM_INV_TAG, (Tag)tmp.save(new ListTag()));
            }
        }
    }

    private static void returnStoredItems(Player player) {
        TwilightForestMod.LOGGER.debug("Player {} ({}) respawned and received items held in storage", (Object)player.getName().getString(), (Object)player.getUUID());
        CompoundTag playerData = CharmEvents.getPlayerData(player);
        if (!player.level().isClientSide() && playerData.contains(CHARM_INV_TAG)) {
            ListTag tagList = playerData.getList(CHARM_INV_TAG, 10);
            TFItemStackUtils.loadNoClear(player.registryAccess(), tagList, player.getInventory());
            CharmEvents.getPlayerData(player).getList(CHARM_INV_TAG, 10).clear();
            CharmEvents.getPlayerData(player).remove(CHARM_INV_TAG);
        }
        if (CharmEvents.getPlayerData(player).contains(CONSUMED_CHARM_TAG)) {
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)player.registryAccess(), (CompoundTag)((CompoundTag)CharmEvents.getPlayerData(player).get(CONSUMED_CHARM_TAG)));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SpawnCharmPacket(stack, (ResourceKey<SoundEvent>)TFSounds.CHARM_KEEP.getKey()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                serverPlayer.awardStat((ResourceLocation)TFStats.KEEPING_CHARMS_ACTIVATED.get());
            }
            CharmEvents.getPlayerData(player).remove(CONSUMED_CHARM_TAG);
        }
    }

    public static CompoundTag getPlayerData(Player player) {
        if (!player.getPersistentData().contains("PlayerPersisted")) {
            player.getPersistentData().put("PlayerPersisted", (Tag)new CompoundTag());
        }
        return player.getPersistentData().getCompound("PlayerPersisted");
    }

    private static boolean keepWholeListAndCheckCasket(NonNullList<ItemStack> transferTo, List<ItemStack> transferFrom, boolean skipCasketCheck) {
        boolean keptCasket = false;
        for (int i = 0; i < transferFrom.size(); ++i) {
            ItemStack item = transferFrom.get(i).copy();
            if (skipCasketCheck || !item.is(TFItems.KEEPSAKE_CASKET) || keptCasket) {
                transferTo.set(i, (Object)item);
                transferFrom.set(i, ItemStack.EMPTY);
                continue;
            }
            keptCasket = true;
            if (item.getCount() <= 1) continue;
            item.shrink(1);
            transferTo.set(i, (Object)item);
            transferFrom.set(i, item.copyWithCount(1));
        }
        return keptCasket || skipCasketCheck;
    }

    private static boolean hasCharmCurio(Item item, Player player) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.findAndConsumeCurio(item, player);
        }
        return false;
    }
}

