/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.projectile.ITFProjectile;

public abstract class TFArrow
extends AbstractArrow
implements ITFProjectile {
    @Nullable
    protected final AbstractArrow parentArrow;

    public TFArrow(EntityType<? extends TFArrow> type, Level level) {
        super(type, level);
        this.parentArrow = null;
    }

    public TFArrow(EntityType<? extends TFArrow> type, Level level, @Nullable LivingEntity shooter, ItemStack stack, ItemStack weapon) {
        super(type, shooter, level, stack, weapon);
        this.setOwner((Entity)shooter);
        if (shooter != null) {
            this.setPos(shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ());
        }
        this.parentArrow = null;
    }

    public TFArrow(EntityType<? extends TFArrow> type, AbstractArrow parentArrow, ItemStack stack, ItemStack weapon) {
        super(type, (LivingEntity)parentArrow.getOwner(), parentArrow.level(), stack, weapon);
        LivingEntity shooter = (LivingEntity)parentArrow.getOwner();
        this.setOwner((Entity)shooter);
        if (shooter != null) {
            this.setPos(shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ());
        }
        this.parentArrow = parentArrow;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    public void doPostHurtEffects(LivingEntity target) {
        if (this.parentArrow != null) {
            this.parentArrow.doPostHurtEffects(target);
        }
        super.doPostHurtEffects(target);
    }
}

