/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import twilightforest.init.TFEntities;

public class ProtectionBox
extends Entity {
    public int lifeTime;
    public final int sizeX;
    public final int sizeY;
    public final int sizeZ;
    private final BoundingBox sbb;

    public ProtectionBox(EntityType<?> type, Level world) {
        super(type, world);
        this.sizeZ = 0;
        this.sizeY = 0;
        this.sizeX = 0;
        this.sbb = null;
    }

    public ProtectionBox(Level world, BoundingBox sbb) {
        super((EntityType)TFEntities.PROTECTION_BOX.get(), world);
        this.sbb = sbb;
        this.moveTo(sbb.minX(), sbb.minY(), sbb.minZ(), 0.0f, 0.0f);
        this.sizeX = sbb.getXSpan();
        this.sizeY = sbb.getYSpan();
        this.sizeZ = sbb.getZSpan();
        this.dimensions = EntityDimensions.fixed((float)Math.max(this.sizeX, this.sizeZ), (float)this.sizeY);
        this.lifeTime = 60;
    }

    public void tick() {
        super.tick();
        if (this.lifeTime <= 1) {
            this.discard();
        } else {
            --this.lifeTime;
        }
    }

    public boolean matches(BoundingBox sbb) {
        return this.sbb.minX() == sbb.minX() && this.sbb.minY() == sbb.minY() && this.sbb.minZ() == sbb.minZ() && this.sbb.maxX() == sbb.maxX() && this.sbb.maxY() == sbb.maxY() && this.sbb.maxZ() == sbb.maxZ();
    }

    public void resetLifetime() {
        this.lifeTime = 60;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    public boolean displayFireAnimation() {
        return false;
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }
}

