/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import twilightforest.item.recipe.travellers.TravellersGearModifierRecipe;
import twilightforest.item.recipe.travellers.TravellersGearModifierShapedRecipe;
import twilightforest.item.recipe.travellers.TravellersGearModifierShapelessRecipe;
import twilightforest.item.travellers_gear.modifiers.TravellersModifier;

public class TravellersGearComponentModifierBuilder {
    List<TravellersGearModifierRecipe> recipes = new ArrayList<TravellersGearModifierRecipe>();

    private TravellersGearComponentModifierBuilder(Iterable<ShapedRecipePattern> pattern, ResourceKey<TravellersModifier> travellersModifierKey, boolean isRotated) {
        pattern.forEach(shapedRecipePattern -> this.recipes.add(new TravellersGearModifierShapedRecipe((ShapedRecipePattern)shapedRecipePattern, travellersModifierKey, isRotated)));
    }

    private TravellersGearComponentModifierBuilder(Iterable<NonNullList<Ingredient>> ingredients, ResourceKey<TravellersModifier> travellersModifierKey) {
        ingredients.forEach(recipeIngredients -> this.recipes.add(new TravellersGearModifierShapelessRecipe((NonNullList<Ingredient>)recipeIngredients, travellersModifierKey)));
    }

    public static TravellersGearComponentModifierBuilder buildShaped(Iterable<ShapedRecipePattern> pattern, ResourceKey<TravellersModifier> travellersModifier) {
        return TravellersGearComponentModifierBuilder.buildShaped(pattern, travellersModifier, false);
    }

    public static TravellersGearComponentModifierBuilder buildShaped(Iterable<ShapedRecipePattern> pattern, ResourceKey<TravellersModifier> travellersModifier, boolean isRotated) {
        return new TravellersGearComponentModifierBuilder(pattern, travellersModifier, isRotated);
    }

    public static TravellersGearComponentModifierBuilder buildShapeless(Iterable<NonNullList<Ingredient>> ingredients, ResourceKey<TravellersModifier> travellersModifier) {
        return new TravellersGearComponentModifierBuilder(ingredients, travellersModifier);
    }

    public void save(RecipeOutput output) {
        for (TravellersGearModifierRecipe recipe : this.recipes) {
            output.accept(recipe.getId(), (Recipe)recipe, null);
        }
    }
}

