/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import twilightforest.item.recipe.DryingRecipe;

public class DryingRecipeBuilder
implements RecipeBuilder {
    private final Ingredient input;
    private final ItemStack result;
    private final int time;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private DryingRecipeBuilder(Ingredient input, ItemStack result, int dryingTime) {
        this.input = input;
        this.result = result;
        this.time = dryingTime;
    }

    public static DryingRecipeBuilder drying(ItemLike input, ItemLike result) {
        return DryingRecipeBuilder.drying(Ingredient.of((ItemLike[])new ItemLike[]{input}), new ItemStack(result));
    }

    public static DryingRecipeBuilder drying(ItemLike input, ItemLike result, float dryingMinutes) {
        return DryingRecipeBuilder.drying(Ingredient.of((ItemLike[])new ItemLike[]{input}), new ItemStack(result), dryingMinutes);
    }

    public static DryingRecipeBuilder drying(Ingredient input, ItemStack result) {
        return DryingRecipeBuilder.drying(input, result, 5.0f);
    }

    public static DryingRecipeBuilder drying(Ingredient input, ItemStack result, float dryingMinutes) {
        return new DryingRecipeBuilder(input, result, (int)(1200.0f * dryingMinutes));
    }

    public DryingRecipeBuilder unlockedBy(String key, Criterion<?> criterion) {
        this.criteria.put(key, criterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String groupName) {
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        this.ensureValid(id);
        Advancement.Builder builder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        DryingRecipe recipe = new DryingRecipe(this.input, this.result, this.time);
        output.accept(id, (Recipe)recipe, builder.build(id.withPrefix("recipes/drying/")));
    }

    private void ensureValid(ResourceLocation location) {
        if (this.criteria.isEmpty() && !location.getPath().equals("stale_bread")) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(location));
        }
    }
}

