/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.jade;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;
import twilightforest.TwilightForestMod;
import twilightforest.block.entity.DryingRackBlockEntity;
import twilightforest.compat.RecipeViewerConstants;

public enum DryingRackProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (data.contains("progress")) {
            int progress = data.getInt("progress");
            IElementHelper helper = IElementHelper.get();
            int total = data.getInt("total");
            tooltip.add(helper.text((Component)Component.translatable((String)"jade.drying_rack.remaining", (Object[])new Object[]{RecipeViewerConstants.getDryingTime(total - progress)})).translate(new Vec2(10.0f, 0.0f)));
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        DryingRackBlockEntity rack;
        BlockEntity entity = accessor.getBlockEntity();
        if (entity instanceof DryingRackBlockEntity && (rack = (DryingRackBlockEntity)entity).isDrying()) {
            CompoundTag tag = rack.saveWithoutMetadata((HolderLookup.Provider)accessor.getLevel().registryAccess());
            data.putInt("progress", tag.getInt("dry_time"));
            data.putInt("total", tag.getInt("total_dry_time"));
        }
    }

    public ResourceLocation getUid() {
        return TwilightForestMod.prefix("drying_rack");
    }
}

