/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.library.plugins.vanilla.crafting.JeiShapedRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import twilightforest.config.TFConfig;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFDataMaps;
import twilightforest.init.TFItems;
import twilightforest.init.TFRecipes;
import twilightforest.inventory.UncraftingMenu;
import twilightforest.util.datamaps.CrumbledBlock;
import twilightforest.util.datamaps.EntityTransformation;

public class RecipeViewerConstants {
    public static final int GENERIC_RECIPE_WIDTH = 116;
    public static final int GENERIC_RECIPE_HEIGHT = 54;
    public static final Component MOONWORM_QUEEN_TOOLTIP = Component.translatable((String)"item.twilightforest.moonworm_queen.jei_info_message").withStyle(ChatFormatting.GREEN);
    public static final ItemStack DAMAGED_MOONWORM_QUEEN = (ItemStack)Util.make((Object)new ItemStack((ItemLike)TFItems.MOONWORM_QUEEN.get()), stack -> stack.setDamageValue(256));
    public static final List<ItemStack> BERRY_2_LIST = List.of(ItemStack.EMPTY, new ItemStack((ItemLike)TFItems.TORCHBERRIES.get()), new ItemStack((ItemLike)TFItems.TORCHBERRIES.get()), new ItemStack((ItemLike)TFItems.TORCHBERRIES.get()));
    public static final List<ItemStack> BERRY_3_LIST = List.of(ItemStack.EMPTY, ItemStack.EMPTY, new ItemStack((ItemLike)TFItems.TORCHBERRIES.get()), new ItemStack((ItemLike)TFItems.TORCHBERRIES.get()));
    public static final List<ItemStack> BERRY_4_LIST = List.of(ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, new ItemStack((ItemLike)TFItems.TORCHBERRIES.get()));
    public static final List<ItemStack> MOONWORM_QUEEN_LIST = List.of((ItemStack)Util.make((Object)new ItemStack((ItemLike)TFItems.MOONWORM_QUEEN.get()), stack -> stack.setDamageValue(192)), (ItemStack)Util.make((Object)new ItemStack((ItemLike)TFItems.MOONWORM_QUEEN.get()), stack -> stack.setDamageValue(128)), (ItemStack)Util.make((Object)new ItemStack((ItemLike)TFItems.MOONWORM_QUEEN.get()), stack -> stack.setDamageValue(64)), new ItemStack((ItemLike)TFItems.MOONWORM_QUEEN.get()));

    public static List<RecipeHolder<? extends CraftingRecipe>> getAllUncraftingRecipes(RecipeManager manager) {
        if (!TFConfig.disableUncraftingOnly) {
            List<Object> recipes = new ArrayList(manager.getAllRecipesFor(RecipeType.CRAFTING));
            recipes = recipes.stream().filter(recipe -> !((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).isEmpty() && !((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).is(ItemTagGenerator.BANNED_UNCRAFTABLES) && TFConfig.reverseRecipeBlacklist == TFConfig.disableUncraftingRecipes.contains(recipe.id().toString()) && TFConfig.flipUncraftingModIdList == TFConfig.blacklistedUncraftingModIds.contains(recipe.id().getNamespace())).collect(Collectors.toList());
            recipes.removeIf(recipe -> recipe.value() instanceof ShapelessRecipe && !TFConfig.allowShapelessUncrafting);
            recipes.addAll(manager.getAllRecipesFor((RecipeType)TFRecipes.UNCRAFTING_RECIPE.get()));
            return recipes;
        }
        return new ArrayList<RecipeHolder<? extends CraftingRecipe>>(manager.getAllRecipesFor((RecipeType)TFRecipes.UNCRAFTING_RECIPE.get()));
    }

    public static List<TransformationPowderInfo> getTransformationPowderRecipes() {
        ArrayList<EntityType> inputs = new ArrayList<EntityType>();
        ArrayList<TransformationPowderInfo> info = new ArrayList<TransformationPowderInfo>();
        for (EntityType type : BuiltInRegistries.ENTITY_TYPE) {
            if (type.builtInRegistryHolder().getData(TFDataMaps.TRANSFORMATION_POWDER) == null) continue;
            inputs.add(type);
        }
        for (EntityType input : new ArrayList(inputs)) {
            TransformationPowderInfo dummy;
            EntityTransformation output = (EntityTransformation)input.builtInRegistryHolder().getData(TFDataMaps.TRANSFORMATION_POWDER);
            if (output == null || info.contains(dummy = new TransformationPowderInfo(output.result(), input, true))) continue;
            if (inputs.contains(output.result())) {
                info.add(new TransformationPowderInfo(input, output.result(), true));
                continue;
            }
            info.add(new TransformationPowderInfo(input, output.result(), false));
        }
        return info;
    }

    public static List<OminousFireInfo> getOminousFireRecipes() {
        ArrayList<EntityType> inputs = new ArrayList<EntityType>();
        ArrayList<OminousFireInfo> info = new ArrayList<OminousFireInfo>();
        for (EntityType type : BuiltInRegistries.ENTITY_TYPE) {
            if (type.builtInRegistryHolder().getData(TFDataMaps.OMINOUS_FIRE) == null) continue;
            inputs.add(type);
        }
        for (EntityType input : new ArrayList(inputs)) {
            OminousFireInfo dummy;
            EntityTransformation output = (EntityTransformation)input.builtInRegistryHolder().getData(TFDataMaps.OMINOUS_FIRE);
            if (output == null || info.contains(dummy = new OminousFireInfo(output.result(), input))) continue;
            info.add(new OminousFireInfo(input, output.result()));
        }
        return info;
    }

    public static List<Pair<Block, Block>> getCrumbleHornRecipes() {
        ArrayList<Pair<Block, Block>> info = new ArrayList<Pair<Block, Block>>();
        for (Block input : BuiltInRegistries.BLOCK) {
            CrumbledBlock output = (CrumbledBlock)input.builtInRegistryHolder().getData(TFDataMaps.CRUMBLE_HORN);
            if (output == null) continue;
            info.add((Pair<Block, Block>)Pair.of((Object)input, (Object)output.result()));
        }
        return info;
    }

    public static int getRecipeCost(List<ItemStack> inputs) {
        int cost = 0;
        for (ItemStack stack : inputs) {
            if (!UncraftingMenu.isDamageableComponent(stack) || UncraftingMenu.isIngredientProblematic(stack) || UncraftingMenu.isMarked(stack)) continue;
            ++cost;
        }
        return cost;
    }

    public static int getXPColor(int cost) {
        if (Minecraft.getInstance().player.experienceLevel < cost && !Minecraft.getInstance().player.getAbilities().instabuild) {
            return 0xA00000;
        }
        return 8453920;
    }

    public static Component getDryingTime(int dryingTicks) {
        int dryingMinutes = dryingTicks / 60 / 20;
        int dryingSeconds = dryingTicks / 20 % 60;
        MutableComponent time = dryingMinutes > 0 ? (dryingSeconds > 0 ? Component.translatable((String)"gui.twilightforest.drying_time", (Object[])new Object[]{dryingMinutes, dryingSeconds}) : (dryingMinutes == 1 ? Component.translatable((String)"gui.twilightforest.drying_minute", (Object[])new Object[]{dryingMinutes}) : Component.translatable((String)"gui.twilightforest.drying_minutes", (Object[])new Object[]{dryingMinutes}))) : (dryingSeconds == 1 ? Component.translatable((String)"gui.twilightforest.drying_second", (Object[])new Object[]{dryingSeconds}) : Component.translatable((String)"gui.twilightforest.drying_seconds", (Object[])new Object[]{dryingSeconds}));
        return time;
    }

    public static void renderFlatBlock(PoseStack stack, BlockState state, Vec3 location, float scale) {
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        stack.pushPose();
        Lighting.setupForFlatItems();
        stack.translate(location.x(), location.y(), location.z());
        stack.scale(scale, -scale, scale);
        minecraft.getBlockRenderer().renderSingleBlock(state, stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
        stack.popPose();
        bufferSource.endBatch();
        Lighting.setupFor3DItems();
    }

    public static int getCraftingIndex(CraftingRecipe recipe, int i) {
        int index;
        int width = RecipeViewerConstants.getRecipeWidth(recipe);
        int height = RecipeViewerConstants.getRecipeHeight(recipe);
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    public static int getRecipeWidth(CraftingRecipe recipe) {
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            return shapedRecipe.getWidth();
        }
        if (recipe instanceof JeiShapedRecipe) {
            JeiShapedRecipe shapedRecipe = (JeiShapedRecipe)recipe;
            return shapedRecipe.getWidth();
        }
        return 0;
    }

    public static int getRecipeHeight(CraftingRecipe recipe) {
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            return shapedRecipe.getHeight();
        }
        if (recipe instanceof JeiShapedRecipe) {
            JeiShapedRecipe shapedRecipe = (JeiShapedRecipe)recipe;
            return shapedRecipe.getHeight();
        }
        return 0;
    }

    public record TransformationPowderInfo(EntityType<?> input, EntityType<?> output, boolean reversible) {
    }

    public record OminousFireInfo(EntityType<?> input, EntityType<?> output) {
    }
}

