/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.init.custom.Enforcements;
import twilightforest.util.IntervalUtils;
import twilightforest.util.Restriction;
import twilightforest.util.landmarks.LandmarkUtil;

public class TFWeatherRenderer {
    public static final ResourceLocation RAIN_TEXTURES = ResourceLocation.withDefaultNamespace((String)"textures/environment/rain.png");
    public static final ResourceLocation SNOW_TEXTURES = ResourceLocation.withDefaultNamespace((String)"textures/environment/snow.png");
    private static final ResourceLocation SPARKLES_TEXTURE = TwilightForestMod.getEnvTexture("sparkles.png");
    public static final float[] rainxs = new float[1024];
    public static final float[] rainzs = new float[1024];
    @Nullable
    private static List<Pair<BoundingBox, Boolean>> boxData;
    @Nullable
    private static HashMap<Pair<Integer, Integer>, List<Pair<Integer, Integer>>> rainIntervals;
    @Nullable
    private static BoundingBox pBoxOld;
    private static final RandomSource random;
    private static float urGhastRain;
    public static boolean urGhastAlive;

    public static boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTicks, LightTexture lightmap, Vec3 camera) {
        Minecraft mc = Minecraft.getInstance();
        if (LandmarkUtil.isProgressionEnforced((Level)level) && mc.player != null && !mc.player.isCreative() && !mc.player.isSpectator()) {
            TFWeatherRenderer.renderLockedBiome(ticks, partialTicks, level, lightmap, mc.player, camera);
            TFWeatherRenderer.renderLockedStructure(ticks, partialTicks, lightmap, camera);
        }
        return false;
    }

    private static void renderLockedBiome(int ticks, float partialTicks, ClientLevel level, LightTexture lightmap, LocalPlayer player, Vec3 camera) {
        if (TFWeatherRenderer.isNearLockedBiome((Level)level, (Entity)player)) {
            lightmap.turnOnLightLayer();
            int px = Mth.floor((double)camera.x());
            int py = Mth.floor((double)camera.y());
            int pz = Mth.floor((double)camera.z());
            Tesselator tessellator = Tesselator.getInstance();
            BufferBuilder bufferBuilder = null;
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int range = 5;
            if (Minecraft.useFancyGraphics()) {
                range = 10;
            }
            RenderSystem.depthMask((boolean)Minecraft.useShaderTransparency());
            RenderType currentType = null;
            float combinedTicks = (float)ticks + partialTicks;
            RenderSystem.setShader(GameRenderer::getParticleShader);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int dz = pz - range; dz <= pz + range; ++dz) {
                block8: for (int dx = px - range; dx <= px + range; ++dx) {
                    int rainIndex = (dz - pz + 16) * 32 + dx - px + 16;
                    double rainX = (double)rainxs[rainIndex] * 0.5;
                    double rainZ = (double)rainzs[rainIndex] * 0.5;
                    pos.set(dx, 0, dz);
                    Biome biome = (Biome)level.getBiome((BlockPos)pos).value();
                    Optional<Restriction> restriction = Restriction.getRestrictionForBiome(biome, (Entity)player);
                    if (!restriction.isPresent()) continue;
                    int groundY = level.getMinBuildHeight();
                    int minY = py - range;
                    int maxY = py + range;
                    if (minY < groundY) {
                        minY = groundY;
                    }
                    if (maxY < groundY) {
                        maxY = groundY;
                    }
                    if (minY == maxY) continue;
                    random.setSeed((long)dx * (long)dx * 3121L + (long)dx * 45238971L ^ (long)dz * (long)dz * 418711L + (long)dz * 13761L);
                    RenderType nextType = TFWeatherRenderer.getRenderType(restriction.get());
                    if (nextType == null) continue;
                    if (currentType != nextType) {
                        if (currentType != null) {
                            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
                        }
                        currentType = nextType;
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)nextType.getTextureLocation());
                        bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                    }
                    double xRange = (double)((float)dx + 0.5f) - camera.x();
                    double zRange = (double)((float)dz + 0.5f) - camera.z();
                    float distanceToPlayer = Mth.sqrt((float)((float)(xRange * xRange + zRange * zRange))) / (float)range;
                    float alpha = (1.0f - distanceToPlayer * distanceToPlayer) * 0.3f + 0.5f;
                    int worldBrightness = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos);
                    int fullbright = 0xF000F0;
                    switch (currentType.ordinal()) {
                        case 0: {
                            float countFactor = ((float)(ticks & 0x1FF) + partialTicks) / 512.0f;
                            float uFactor = random.nextFloat() + combinedTicks * 0.05f * (float)random.nextGaussian();
                            float vFactor = random.nextFloat() + combinedTicks * 0.0025f * (float)random.nextGaussian();
                            TFWeatherRenderer.renderEffect(bufferBuilder, rainX, rainZ, minY, maxY, camera, dx, dz, countFactor, uFactor, vFactor, new float[]{1.0f, 1.0f, 1.0f, alpha}, fullbright);
                            continue block8;
                        }
                        case 1: {
                            float countFactor = 0.0f;
                            float uFactor = random.nextFloat() + combinedTicks * 0.03f * (float)random.nextGaussian();
                            float vFactor = random.nextFloat() + combinedTicks * 0.003f * (float)random.nextGaussian();
                            float red = random.nextFloat() * 0.3f;
                            float green = random.nextFloat() * 0.3f;
                            float blue = random.nextFloat() * 0.3f;
                            TFWeatherRenderer.renderEffect(bufferBuilder, rainX, rainZ, minY, maxY, camera, dx, dz, countFactor, uFactor, vFactor, new float[]{red, green, blue, 1.0f}, fullbright);
                            continue block8;
                        }
                        case 2: {
                            float countFactor = -((float)(ticks & 0x3FF) + partialTicks) / 1024.0f;
                            float uFactor = random.nextFloat() + combinedTicks * 0.0025f * (float)random.nextGaussian();
                            float vFactor = random.nextFloat() + combinedTicks * 0.005f * (float)random.nextGaussian();
                            float color = random.nextFloat() * 0.2f + 0.8f;
                            TFWeatherRenderer.renderEffect(bufferBuilder, rainX, rainZ, minY, maxY, camera, dx, dz, countFactor, uFactor, vFactor, new float[]{color, color, color, alpha}, fullbright);
                            continue block8;
                        }
                        case 3: {
                            float countFactor = -((float)(ticks & 0x1FF) + partialTicks) / 512.0f;
                            float uFactor = 0.0f;
                            float vFactor = random.nextFloat() + combinedTicks * 0.005f * (float)random.nextGaussian();
                            TFWeatherRenderer.renderEffect(bufferBuilder, rainX, rainZ, minY, maxY, camera, dx, dz, countFactor, uFactor, vFactor, new float[]{1.0f, 1.0f, 1.0f, alpha}, fullbright);
                            continue block8;
                        }
                        case 4: {
                            float countFactor = ((float)(ticks + dx * dx * 3121 + dx * 45238971 + dz * dz * 418711 + dz * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                            float uFactor = random.nextFloat();
                            float vFactor = random.nextFloat();
                            TFWeatherRenderer.renderEffect(bufferBuilder, rainX, rainZ, minY, maxY, camera, dx, dz, countFactor, uFactor, vFactor, new float[]{1.0f, 1.0f, 1.0f, alpha}, worldBrightness);
                        }
                    }
                }
            }
            if (currentType != null) {
                BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightmap.turnOffLightLayer();
        }
    }

    private static void renderLockedStructure(int ticks, float partialTicks, LightTexture lightmap, Vec3 camera) {
        int pz;
        int py;
        int range = Minecraft.useFancyGraphics() ? 10 : 5;
        int px = Mth.floor((double)camera.x());
        BoundingBox pBox = new BoundingBox(px - range, (py = Mth.floor((double)camera.y())) - range, (pz = Mth.floor((double)camera.z())) - range, px + range, py + 2 * range, pz + range);
        if (!TFWeatherRenderer.isNearLockedPiece(pBox)) {
            return;
        }
        if (!pBox.equals((Object)pBoxOld)) {
            TFWeatherRenderer.updateRainIntervals(pBox);
            pBoxOld = pBox;
        }
        lightmap.turnOnLightLayer();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = null;
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        float combinedTicks = (float)ticks + partialTicks;
        int drawFlag = -1;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int x = pBox.minX(); x <= pBox.maxX(); ++x) {
            for (int z = pBox.minZ(); z <= pBox.maxZ(); ++z) {
                for (Pair<Integer, Integer> segment : rainIntervals.get(Pair.of((Object)x, (Object)z))) {
                    int rainMax;
                    int rainMin = (Integer)segment.getFirst();
                    if (rainMin >= (rainMax = ((Integer)segment.getSecond()).intValue())) continue;
                    random.setSeed((long)x * (long)x * 3121L + (long)x * 45238971L ^ (long)z * (long)z * 418711L + (long)z * 13761L);
                    if (drawFlag != 0) {
                        drawFlag = 0;
                        RenderSystem.setShader(GameRenderer::getParticleShader);
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SPARKLES_TEXTURE);
                        bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                    }
                    float countFactor = ((float)(ticks & 0x1FF) + partialTicks) / 512.0f;
                    float uFactor = random.nextFloat() + combinedTicks * 0.02f * (float)random.nextGaussian();
                    float vFactor = random.nextFloat() + combinedTicks * 0.02f * (float)random.nextGaussian();
                    double xRange = (double)x + 0.5 - camera.x();
                    double zRange = (double)z + 0.5 - camera.z();
                    float distanceFromPlayer = Mth.sqrt((float)((float)(xRange * xRange + zRange * zRange))) / (float)range;
                    float alpha = ((1.0f - distanceFromPlayer * distanceFromPlayer) * 0.3f + 0.5f) * random.nextFloat();
                    TFWeatherRenderer.renderEffect(bufferbuilder, (double)rainxs[(z - pz + 16) * 32 + x - px + 16] * 0.5, (double)rainzs[(z - pz + 16) * 32 + x - px + 16] * 0.5, rainMin, rainMax, camera, x, z, countFactor, uFactor, vFactor, new float[]{1.0f, 1.0f, 1.0f, alpha}, 0xF000F0);
                }
            }
        }
        if (drawFlag == 0) {
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        lightmap.turnOffLightLayer();
    }

    private static void updateRainIntervals(BoundingBox pBox) {
        if (TFWeatherRenderer.boxData == null) {
            rainIntervals = null;
            return;
        }
        List<Pair> intersectingBoxesData = TFWeatherRenderer.boxData.stream().filter(boxData -> ((BoundingBox)boxData.getFirst()).intersects(pBox)).toList();
        ArrayList<BoundingBox> protectedBoxes = new ArrayList<BoundingBox>();
        ArrayList<BoundingBox> unprotectedBoxes = new ArrayList<BoundingBox>();
        for (Pair pair : intersectingBoxesData) {
            if (((Boolean)pair.getSecond()).booleanValue()) {
                protectedBoxes.add((BoundingBox)pair.getFirst());
                continue;
            }
            unprotectedBoxes.add((BoundingBox)pair.getFirst());
        }
        rainIntervals = new HashMap();
        for (int x = pBox.minX(); x <= pBox.maxX(); ++x) {
            for (int z = pBox.minZ(); z <= pBox.maxZ(); ++z) {
                List<Pair<Integer, Integer>> unprotectedIntervals = TFWeatherRenderer.getRainIntervals(x, z, pBox, unprotectedBoxes);
                List<Pair<Integer, Integer>> protectedIntervals = TFWeatherRenderer.getRainIntervals(x, z, pBox, protectedBoxes);
                List<Pair<Integer, Integer>> mergedUnprotected = IntervalUtils.mergeAndSortIntervals(unprotectedIntervals);
                List<Pair<Integer, Integer>> mergedProtected = IntervalUtils.mergeAndSortIntervals(protectedIntervals);
                rainIntervals.put((Pair<Integer, Integer>)Pair.of((Object)x, (Object)z), IntervalUtils.subtractIntervals(mergedProtected, mergedUnprotected));
            }
        }
    }

    private static List<Pair<Integer, Integer>> getRainIntervals(int x, int z, BoundingBox pBox, List<BoundingBox> boxes) {
        ArrayList<Pair<Integer, Integer>> intervals = new ArrayList<Pair<Integer, Integer>>();
        for (BoundingBox box : boxes) {
            int rainMax;
            int rainMin;
            if (!box.intersects(x, z, x, z) || (rainMin = Math.max(pBox.minY(), box.minY())) >= (rainMax = Math.min(pBox.maxY(), box.maxY() + 1))) continue;
            intervals.add((Pair<Integer, Integer>)Pair.of((Object)rainMin, (Object)rainMax));
        }
        return intervals;
    }

    private static void renderEffect(BufferBuilder bufferBuilder, double rainX, double rainZ, int minY, int maxY, Vec3 camera, int dx, int dz, float countFactor, float uFactor, float vFactor, float[] color, int light) {
        int blockLight = light >> 16 & 0xFFFF;
        int skyLight = light & 0xFFFF;
        bufferBuilder.addVertex((float)((double)dx - camera.x() - rainX + 0.5), (float)((double)minY - camera.y()), (float)((double)dz - camera.z() - rainZ + 0.5)).setUv(0.0f + uFactor, (float)minY * 0.25f + countFactor + vFactor).setColor(color[0], color[1], color[2], color[3]).setUv2(blockLight, skyLight);
        bufferBuilder.addVertex((float)((double)dx - camera.x() + rainX + 0.5), (float)((double)minY - camera.y()), (float)((double)dz - camera.z() + rainZ + 0.5)).setUv(1.0f + uFactor, (float)minY * 0.25f + countFactor + vFactor).setColor(color[0], color[1], color[2], color[3]).setUv2(blockLight, skyLight);
        bufferBuilder.addVertex((float)((double)dx - camera.x() + rainX + 0.5), (float)((double)maxY - camera.y()), (float)((double)dz - camera.z() + rainZ + 0.5)).setUv(1.0f + uFactor, (float)maxY * 0.25f + countFactor + vFactor).setColor(color[0], color[1], color[2], color[3]).setUv2(blockLight, skyLight);
        bufferBuilder.addVertex((float)((double)dx - camera.x() - rainX + 0.5), (float)((double)maxY - camera.y()), (float)((double)dz - camera.z() - rainZ + 0.5)).setUv(0.0f + uFactor, (float)maxY * 0.25f + countFactor + vFactor).setColor(color[0], color[1], color[2], color[3]).setUv2(blockLight, skyLight);
    }

    private static boolean isNearLockedBiome(Level level, Entity viewEntity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int range = 15;
        int px = Mth.floor((double)viewEntity.getX());
        int pz = Mth.floor((double)viewEntity.getZ());
        for (int z = pz - 15; z <= pz + 15; ++z) {
            for (int x = px - 15; x <= px + 15; ++x) {
                Biome biome = (Biome)level.getBiome((BlockPos)pos.set(x, 0, z)).value();
                if (Restriction.isBiomeSafeFor(biome, viewEntity)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isNearLockedPiece(BoundingBox pBox) {
        return TFWeatherRenderer.boxData != null && TFWeatherRenderer.boxData.stream().anyMatch(boxData -> ((BoundingBox)boxData.getFirst()).intersects(pBox));
    }

    public static void setProtectedBoxes(@Nullable List<Pair<BoundingBox, Boolean>> protectedBoxes) {
        boxData = protectedBoxes;
    }

    @Nullable
    private static RenderType getRenderType(Restriction restriction) {
        if (restriction.enforcement().equals((Object)Enforcements.FROST.getKey())) {
            return RenderType.BLIZZARD;
        }
        if (restriction.enforcement().equals((Object)Enforcements.HUNGER.getKey())) {
            return RenderType.MOSQUITO;
        }
        if (restriction.enforcement().equals((Object)Enforcements.FIRE.getKey())) {
            return RenderType.ASHES;
        }
        if (restriction.enforcement().equals((Object)Enforcements.DARKNESS.getKey())) {
            return random.nextBoolean() ? RenderType.DARK_STREAM : null;
        }
        if (restriction.enforcement().equals((Object)Enforcements.ACID_RAIN.getKey())) {
            return RenderType.BIG_RAIN;
        }
        return null;
    }

    public static boolean tickRain(ClientLevel level, int partialTicks, BlockPos blockpos) {
        if (urGhastAlive) {
            urGhastRain = Math.min(1.0f, urGhastRain + 0.1f);
            urGhastAlive = false;
        } else {
            urGhastRain = Math.max(0.0f, urGhastRain - 0.02f);
        }
        float rainLevel = Math.max(level.getRainLevel(1.0f), urGhastRain) / (Minecraft.useFancyGraphics() ? 1.0f : 2.0f);
        if (rainLevel > 0.0f) {
            RandomSource randomsource = RandomSource.create((long)((long)partialTicks * 312987231L));
            BlockPos blockpos1 = null;
            int i = (int)(100.0f * rainLevel * rainLevel) / (Minecraft.getInstance().options.particles().get() == ParticleStatus.DECREASED ? 2 : 1);
            for (int j = 0; j < i; ++j) {
                int k = randomsource.nextInt(21) - 10;
                int l = randomsource.nextInt(21) - 10;
                BlockPos blockpos2 = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos.offset(k, 0, l));
                Biome biome = (Biome)level.getBiome(blockpos2).value();
                if (blockpos2.getY() <= level.getMinBuildHeight() || blockpos2.getY() > blockpos.getY() + 10 || blockpos2.getY() < blockpos.getY() - 10 || !biome.hasPrecipitation() || !biome.warmEnoughToRain(blockpos2)) continue;
                blockpos1 = blockpos2.below();
                if (Minecraft.getInstance().options.particles().get() == ParticleStatus.MINIMAL) break;
                double d0 = randomsource.nextDouble();
                double d1 = randomsource.nextDouble();
                BlockState blockstate = level.getBlockState(blockpos1);
                FluidState fluidstate = level.getFluidState(blockpos1);
                VoxelShape voxelshape = blockstate.getCollisionShape((BlockGetter)level, blockpos1);
                double d2 = voxelshape.max(Direction.Axis.Y, d0, d1);
                double d3 = fluidstate.getHeight((BlockGetter)level, blockpos1);
                double d4 = Math.max(d2, d3);
                SimpleParticleType particleoptions = !fluidstate.is(FluidTags.LAVA) && !blockstate.is(Blocks.MAGMA_BLOCK) && !CampfireBlock.isLitCampfire((BlockState)blockstate) ? ParticleTypes.RAIN : ParticleTypes.SMOKE;
                level.addParticle((ParticleOptions)particleoptions, (double)blockpos1.getX() + d0, (double)blockpos1.getY() + d4, (double)blockpos1.getZ() + d1, 0.0, 0.0, 0.0);
            }
            if (blockpos1 != null && randomsource.nextInt(4) < Minecraft.getInstance().levelRenderer.rainSoundTime++) {
                Minecraft.getInstance().levelRenderer.rainSoundTime = 0;
                if (blockpos1.getY() > blockpos.getY() + 1 && level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos).getY() > Mth.floor((float)blockpos.getY())) {
                    level.playLocalSound(blockpos1, SoundEvents.WEATHER_RAIN_ABOVE, SoundSource.WEATHER, 0.1f, 0.5f, false);
                } else {
                    level.playLocalSound(blockpos1, SoundEvents.WEATHER_RAIN, SoundSource.WEATHER, 0.2f, 1.0f, false);
                }
            }
        }
        return true;
    }

    static {
        random = RandomSource.create();
        urGhastRain = 0.0f;
        urGhastAlive = false;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = Mth.sqrt((float)(f * f + f1 * f1));
                TFWeatherRenderer.rainxs[i << 5 | j] = -f1 / f2;
                TFWeatherRenderer.rainzs[i << 5 | j] = f / f2;
            }
        }
    }

    private static enum RenderType {
        BLIZZARD("blizzard.png"),
        MOSQUITO("mosquitoes.png"),
        ASHES("ashes.png"),
        DARK_STREAM("darkstream.png"),
        BIG_RAIN("bigrain.png");

        private final ResourceLocation textureLocation;

        private RenderType(String textureName) {
            this.textureLocation = TwilightForestMod.getEnvTexture(textureName);
        }

        public ResourceLocation getTextureLocation() {
            return this.textureLocation;
        }
    }
}

