/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.entity.player.Player;
import twilightforest.block.TFPortalBlock;
import twilightforest.components.entity.TFPortalAttachment;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDataAttachments;

public class PortalOverlay {
    public static void render(GuiGraphics graphics, Minecraft minecraft, Player player) {
        TFPortalAttachment portal;
        Window window = minecraft.getWindow();
        if (player != null && (portal = (TFPortalAttachment)player.getData(TFDataAttachments.TF_PORTAL_COOLDOWN)).getPortalTimer() > 0) {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            graphics.setColor(1.0f, 1.0f, 1.0f, (float)portal.getPortalTimer() / (float)TFPortalAttachment.MAX_TICKS);
            TextureAtlasSprite textureatlassprite = minecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon(((TFPortalBlock)((Object)TFBlocks.TWILIGHT_PORTAL.get())).defaultBlockState());
            graphics.blit(0, 0, -90, window.getGuiScaledWidth(), window.getGuiScaledHeight(), textureatlassprite);
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

