/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.event;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.event.CalculatePlayerTurnEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredHolder;
import twilightforest.beanification.Component;
import twilightforest.beanification.PostConstruct;
import twilightforest.components.entity.TravellersWingsAnimAttachment;
import twilightforest.config.TFConfig;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFAttributeModifiers;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFKeyBinds;
import twilightforest.init.TFSounds;
import twilightforest.init.custom.TravellersModifiersManager;
import twilightforest.item.travellers_gear.TravellersArmorBeltItem;
import twilightforest.item.travellers_gear.TravellersGearLogic;
import twilightforest.item.travellers_gear.modifiers.TravellersModifier;
import twilightforest.network.CycleMapSlotPacket;
import twilightforest.network.GogglesZoomPacket;
import twilightforest.network.GradualGlidePacket;
import twilightforest.network.PerformDoubleJumpPacket;
import twilightforest.network.PerformSidestepPacket;
import twilightforest.network.SwapHotbarPacket;

@Component(dist={Dist.CLIENT})
public class TravellersClientEvents {
    private static boolean isZoomKeyHeld(Player player) {
        return TFKeyBinds.ZOOM_KEY.isDown() && !player.isScoping();
    }

    @PostConstruct
    private void setup() {
        NeoForge.EVENT_BUS.addListener(this::handleDoubleJump);
        NeoForge.EVENT_BUS.addListener(this::handleAgileRanger);
        NeoForge.EVENT_BUS.addListener(this::handleStraightAhead);
        NeoForge.EVENT_BUS.addListener(this::speedUpControlledWhileSneaking);
        NeoForge.EVENT_BUS.addListener(this::handleSidestep);
        NeoForge.EVENT_BUS.addListener(this::handleStealth);
        NeoForge.EVENT_BUS.addListener(this::updateZoomState);
        NeoForge.EVENT_BUS.addListener(this::updateGradualGlideState);
        NeoForge.EVENT_BUS.addListener(this::cycleItemDisplayMap);
        NeoForge.EVENT_BUS.addListener(this::slowZoomSensitivity);
        NeoForge.EVENT_BUS.addListener(this::swapHotbar);
        NeoForge.EVENT_BUS.addListener(this::toggleRedThreadVision);
    }

    private void handleAgileRanger(MovementInputUpdateEvent event) {
        boolean isLegalItem;
        Player player = event.getEntity();
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer localPlayer = (LocalPlayer)player;
        ItemStack leggingsStack = localPlayer.getItemBySlot(EquipmentSlot.LEGS);
        Float agileRangerModifier = (Float)leggingsStack.get(TFDataComponents.AGILE_RANGER_MODIFIER);
        if (!TravellersModifiersManager.isModifierActive((Entity)localPlayer, leggingsStack, TravellersModifiersManager.AGILE_RANGER_MODIFIER) || agileRangerModifier == null) {
            return;
        }
        ItemStack stack = localPlayer.getUseItem();
        boolean bl = isLegalItem = (stack.getItem() instanceof ProjectileWeaponItem || stack.is(ItemTagGenerator.TRAVELLERS_AGILE_RANGER_WHITELISTED)) && !stack.is(ItemTagGenerator.TRAVELLERS_AGILE_RANGER_BLACKLISTED);
        if (localPlayer.isUsingItem() && !localPlayer.isPassenger() && isLegalItem) {
            Input input = event.getInput();
            input.leftImpulse *= agileRangerModifier.floatValue();
            input.forwardImpulse *= agileRangerModifier.floatValue();
        }
    }

    private void handleStraightAhead(MovementInputUpdateEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer localPlayer = (LocalPlayer)player;
        ItemStack bootsStack = localPlayer.getItemBySlot(EquipmentSlot.FEET);
        Double multiplier = (Double)bootsStack.get(TFDataComponents.STRAIGHT_AHEAD_MULTIPLIER);
        AttributeInstance attributeInstance = localPlayer.getAttributes().getInstance(Attributes.MOVEMENT_SPEED);
        if (attributeInstance == null) {
            return;
        }
        Input input = localPlayer.input;
        if (!TravellersModifiersManager.isModifierActive((Entity)localPlayer, bootsStack, TravellersModifiersManager.STRAIGHT_AHEAD_MODIFIER) || multiplier == null || input.forwardImpulse <= 0.0f) {
            multiplier = 1.0;
        }
        attributeInstance.addOrUpdateTransientModifier(new AttributeModifier(TFAttributeModifiers.STRAIGHT_AHEAD_ATTRIBUTE_MODIFIER_LOCATION, multiplier - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        input.leftImpulse = (float)((double)input.leftImpulse / multiplier);
    }

    private void speedUpControlledWhileSneaking(MovementInputUpdateEvent event) {
        LocalPlayer localPlayer;
        Player player = event.getEntity();
        if (!(player instanceof LocalPlayer && ((Boolean)(localPlayer = (LocalPlayer)player).getData(TFDataAttachments.IS_GRADUALLY_GLIDING)).booleanValue() && localPlayer.isShiftKeyDown())) {
            return;
        }
        localPlayer.input.forwardImpulse /= 0.2f;
        localPlayer.input.leftImpulse /= 0.2f;
    }

    private void handleSidestep(MovementInputUpdateEvent event) {
        boolean hasDoubleTapped;
        LocalPlayer localPlayer;
        Player player = event.getEntity();
        if (!(player instanceof LocalPlayer) || !(localPlayer = (LocalPlayer)player).onGround()) {
            return;
        }
        Input input = localPlayer.input;
        boolean lastImpulseZero = ((Float)localPlayer.getData(TFDataAttachments.LAST_HORIZONTAL_IMPULSE)).floatValue() == 0.0f;
        boolean sameImpulseDirection = Math.signum(((Float)localPlayer.getData(TFDataAttachments.LAST_NON_ZERO_HORIZONTAL_IMPULSE)).floatValue()) == Math.signum(input.leftImpulse);
        int currentTime = localPlayer.tickCount;
        int lastWalkingTime = (Integer)localPlayer.getData(TFDataAttachments.LAST_HORIZONTAL_WALKING_TIME);
        boolean bl = hasDoubleTapped = currentTime - lastWalkingTime < 4;
        if (lastImpulseZero && sameImpulseDirection && hasDoubleTapped && input.leftImpulse != 0.0f) {
            boolean isLeftSidestep;
            boolean bl2 = isLeftSidestep = input.leftImpulse > 0.0f;
            if (TravellersGearLogic.tryPerformSidestep((Player)localPlayer, isLeftSidestep)) {
                localPlayer.connection.send((CustomPacketPayload)new PerformSidestepPacket(isLeftSidestep));
            }
        }
        localPlayer.setData(TFDataAttachments.LAST_HORIZONTAL_IMPULSE, (Object)Float.valueOf(input.leftImpulse));
        if (input.leftImpulse != 0.0f) {
            localPlayer.setData(TFDataAttachments.LAST_HORIZONTAL_WALKING_TIME, (Object)currentTime);
            localPlayer.setData(TFDataAttachments.LAST_NON_ZERO_HORIZONTAL_IMPULSE, (Object)Float.valueOf(input.leftImpulse));
        }
    }

    private void handleStealth(RenderFrameEvent.Pre event) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        for (Entity entity : Minecraft.getInstance().level.entitiesForRendering()) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            TravellersGearLogic.travellersStealth(player, player1 -> player1.setInvisible(true));
        }
    }

    private void handleDoubleJump(InputEvent.Key event) {
        boolean avoidCreativeFly;
        boolean pressedKey;
        LocalPlayer localPlayer;
        block6: {
            block5: {
                LocalPlayer localPlayer2 = Minecraft.getInstance().player;
                if (!(localPlayer2 instanceof LocalPlayer)) break block5;
                localPlayer = localPlayer2;
                if (!this.ignoreKeyEvent(event, Minecraft.getInstance().options.keyJump)) break block6;
            }
            return;
        }
        int lastJumpKeyPressTime = (Integer)localPlayer.getData(TFDataAttachments.LAST_JUMP_KEY_PRESS_TIME);
        boolean bl = pressedKey = event.getAction() == 1;
        if (pressedKey) {
            localPlayer.setData(TFDataAttachments.LAST_JUMP_KEY_PRESS_TIME, (Object)localPlayer.tickCount);
        }
        boolean bl2 = avoidCreativeFly = localPlayer.mayFly() && localPlayer.tickCount - lastJumpKeyPressTime <= 6;
        if (pressedKey && !avoidCreativeFly && TravellersModifiersManager.isModifierActive((LivingEntity)localPlayer, TravellersModifiersManager.DOUBLE_JUMP_MODIFIER) && TravellersGearLogic.performDoubleJump((Player)localPlayer)) {
            ((TravellersWingsAnimAttachment)localPlayer.getData(TFDataAttachments.TRAVELLERS_WINGS_ANIM)).doubleJump = true;
            localPlayer.connection.send((CustomPacketPayload)new PerformDoubleJumpPacket());
        }
    }

    private void updateZoomState(ComputeFovModifierEvent event) {
        boolean isUsingZoom;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        boolean wasUsingZoom = (Boolean)player.getData(TFDataAttachments.IS_USING_GOGGLES_ZOOM_MODIFIER);
        ItemStack headStack = player.getItemBySlot(EquipmentSlot.HEAD);
        Float zoomModifier = (Float)headStack.get(TFDataComponents.ZOOM_ABILITY_MODIFIER);
        boolean bl = isUsingZoom = TravellersClientEvents.isZoomKeyHeld((Player)player) && TravellersModifiersManager.isModifierActive((Entity)player, headStack, TravellersModifiersManager.ZOOM_ABILITY) && zoomModifier != null;
        if (isUsingZoom) {
            event.setNewFovModifier(event.getNewFovModifier() * zoomModifier.floatValue());
        }
        if (isUsingZoom == wasUsingZoom) {
            return;
        }
        player.setData(TFDataAttachments.IS_USING_GOGGLES_ZOOM_MODIFIER, (Object)isUsingZoom);
        player.playSound(isUsingZoom ? (SoundEvent)TFSounds.GOGGLES_ZOOM_IN.get() : (SoundEvent)TFSounds.GOGGLES_ZOOM_OUT.get());
        player.connection.send((CustomPacketPayload)new GogglesZoomPacket(isUsingZoom, player.getUUID()));
    }

    private void updateGradualGlideState(RenderFrameEvent.Pre event) {
        boolean isGraduallyGliding;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        boolean wasGraduallyGliding = (Boolean)player.getData(TFDataAttachments.IS_GRADUALLY_GLIDING);
        boolean shiftHeld = player.isShiftKeyDown();
        boolean bl = isGraduallyGliding = TFConfig.manualTravellersWingsGradualGlideDefault == shiftHeld && player.getKnownMovement().y() < 0.0 && !player.onGround();
        if (isGraduallyGliding == wasGraduallyGliding) {
            return;
        }
        player.setData(TFDataAttachments.IS_GRADUALLY_GLIDING, (Object)isGraduallyGliding);
        player.connection.send((CustomPacketPayload)new GradualGlidePacket(isGraduallyGliding, player.getUUID()));
    }

    private void cycleItemDisplayMap(InputEvent.Key event) {
        LocalPlayer localPlayer;
        block3: {
            block2: {
                LocalPlayer localPlayer2 = Minecraft.getInstance().player;
                if (!(localPlayer2 instanceof LocalPlayer)) break block2;
                localPlayer = localPlayer2;
                if (TFKeyBinds.ITEM_DISPLAY_MAP_CYCLE_KEY.consumeClick()) break block3;
            }
            return;
        }
        localPlayer.connection.send((CustomPacketPayload)CycleMapSlotPacket.INSTANCE);
    }

    private void swapHotbar(InputEvent.Key event) {
        if (!TFKeyBinds.SWAP_HOTBAR_KEY.consumeClick()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer localPlayer = player;
        ItemStack legArmor = localPlayer.getItemBySlot(EquipmentSlot.LEGS);
        ItemContainerContents containerContents = (ItemContainerContents)legArmor.get(DataComponents.CONTAINER);
        if (!TravellersArmorBeltItem.hasSwapHotbar((Player)player, legArmor) || containerContents == null) {
            return;
        }
        localPlayer.connection.send((CustomPacketPayload)SwapHotbarPacket.INSTANCE);
    }

    private void toggleRedThreadVision(InputEvent.Key event) {
        this.toggleBooleanDataAttachment(TFKeyBinds.RED_THREAD_VISION_KEY.consumeClick(), TravellersModifiersManager.RED_THREAD_VISION_MODIFIER, TFDataAttachments.TRAVELLERS_GOGGLES_RED_THREAD_VISION);
    }

    private void toggleBooleanDataAttachment(boolean pressed, ResourceKey<TravellersModifier> modifier, DeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> attachment) {
        if (!pressed) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !TravellersModifiersManager.isModifierActive((LivingEntity)player, modifier)) {
            return;
        }
        boolean current = (Boolean)player.getData((AttachmentType)attachment.get());
        player.setData((AttachmentType)attachment.get(), (Object)(!current ? 1 : 0));
    }

    private void slowZoomSensitivity(CalculatePlayerTurnEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (event.getCinematicCameraEnabled() || player == null) {
            return;
        }
        ItemStack headStack = player.getItemBySlot(EquipmentSlot.HEAD);
        Float zoomModifier = (Float)headStack.get(TFDataComponents.ZOOM_ABILITY_MODIFIER);
        if (zoomModifier == null || !TravellersClientEvents.isZoomKeyHeld((Player)player)) {
            return;
        }
        double mouseSensitivity = event.getMouseSensitivity();
        double mod = 0.5 - 1.0 / (6.0 * mouseSensitivity);
        double fovMod = zoomModifier.floatValue() + 0.05f;
        event.setMouseSensitivity(mod * mouseSensitivity / fovMod);
    }

    private boolean ignoreKeyEvent(InputEvent.Key event, KeyMapping key) {
        return !key.matches(event.getKey(), event.getScanCode()) || event.getAction() != 1 || Minecraft.getInstance().screen != null;
    }
}

