/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.entity;

import java.util.EnumSet;
import net.blay09.mods.farmingforblockheads.entity.MerchantEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;

public class MerchantGoal
extends Goal {
    private final MerchantEntity entity;
    private double movePosX;
    private double movePosY;
    private double movePosZ;
    private final double movementSpeed;

    public MerchantGoal(MerchantEntity entity, double movementSpeed) {
        this.entity = entity;
        this.movementSpeed = movementSpeed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.entity.isAtMarket()) {
            this.entity.setToFacingAngle();
            return false;
        }
        BlockPos marketPos = this.entity.getMarketEntityPosition();
        if (marketPos != null && this.entity.getNavigation().isStableDestination(marketPos)) {
            this.movePosX = (double)marketPos.getX() + 0.5;
            this.movePosY = marketPos.getY() + 1;
            this.movePosZ = (double)marketPos.getZ() + 0.5;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.entity.getNavigation().isDone();
    }

    public void start() {
        this.entity.getNavigation().moveTo(this.movePosX, this.movePosY, this.movePosZ, this.movementSpeed);
    }
}

