/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.network.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.swedz.little_big_redstone.entity.stickynote.StickyNoteEntity;
import net.swedz.little_big_redstone.gui.microchip.MicrochipMenu;
import net.swedz.little_big_redstone.gui.stickynote.reference.EntityStickyNoteReference;
import net.swedz.little_big_redstone.gui.stickynote.reference.HeldItemStickyNoteReference;
import net.swedz.little_big_redstone.gui.stickynote.reference.MicrochipStickyNoteReference;
import net.swedz.little_big_redstone.gui.stickynote.reference.StickyNoteReference;
import net.swedz.little_big_redstone.item.stickynote.StickyNoteItem;
import net.swedz.little_big_redstone.microchip.object.note.StickyNoteEntry;
import net.swedz.little_big_redstone.network.LBRCustomPacket;
import net.swedz.little_big_redstone.proxy.LBRProxy;
import net.swedz.tesseract.neoforge.helper.CodecHelper;
import net.swedz.tesseract.neoforge.packet.PacketContext;
import net.swedz.tesseract.neoforge.proxy.Proxies;

public record StickyNotePacket(ReferenceType referenceType, int data, Action action, String text) implements LBRCustomPacket
{
    public static final StreamCodec<ByteBuf, StickyNotePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)CodecHelper.forEnumStream(ReferenceType.class), StickyNotePacket::referenceType, (StreamCodec)ByteBufCodecs.VAR_INT, StickyNotePacket::data, (StreamCodec)CodecHelper.forEnumStream(Action.class), StickyNotePacket::action, (StreamCodec)ByteBufCodecs.STRING_UTF8, StickyNotePacket::text, StickyNotePacket::new);

    public void handle(PacketContext context) {
        if (this.action.isClientbound()) {
            context.assertClientbound();
        } else {
            context.assertServerbound();
        }
        Player player = context.getPlayer();
        StickyNoteReference reference = this.referenceType.create(player, this.data);
        if (reference != null) {
            reference = reference.withText(this.text);
            if (this.action.isClientbound()) {
                ((LBRProxy)Proxies.get(LBRProxy.class)).openStickyNote(reference, this.action == Action.OPEN_EDIT);
            } else if (this.action == Action.DONE_EDIT) {
                reference.saveServer(player.level(), player);
            }
        }
    }

    public static enum ReferenceType {
        ENTITY((player, data) -> {
            EntityStickyNoteReference entityStickyNoteReference;
            Entity patt0$temp = player.level().getEntity(data);
            if (patt0$temp instanceof StickyNoteEntity) {
                StickyNoteEntity entity = (StickyNoteEntity)patt0$temp;
                entityStickyNoteReference = new EntityStickyNoteReference(entity);
            } else {
                entityStickyNoteReference = null;
            }
            return entityStickyNoteReference;
        }),
        HELD_ITEM((player, data) -> {
            InteractionHand hand = data == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            ItemStack stack = player.getItemInHand(hand);
            return stack.getItem() instanceof StickyNoteItem ? new HeldItemStickyNoteReference(hand, stack) : null;
        }),
        MICROCHIP((player, data) -> {
            MicrochipMenu menu;
            StickyNoteEntry entry;
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof MicrochipMenu && (entry = (StickyNoteEntry)(menu = (MicrochipMenu)patt0$temp).microchip().stickyNotes().get(data)) != null) {
                return new MicrochipStickyNoteReference(entry);
            }
            return null;
        });

        private final Factory factory;

        private ReferenceType(Factory factory) {
            this.factory = factory;
        }

        public StickyNoteReference create(Player player, int data) {
            return this.factory.create(player, data);
        }

        private static interface Factory {
            public StickyNoteReference create(Player var1, int var2);
        }
    }

    public static enum Action {
        OPEN_VIEW(true),
        OPEN_EDIT(true),
        DONE_EDIT(false);

        private final boolean clientbound;

        private Action(boolean clientbound) {
            this.clientbound = clientbound;
        }

        public boolean isClientbound() {
            return this.clientbound;
        }
    }
}

