/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.network.packet;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.swedz.little_big_redstone.entity.stickynote.StickyNoteEntity;
import net.swedz.little_big_redstone.entity.stickynote.StickyNoteView;
import net.swedz.little_big_redstone.network.LBRCustomPacket;
import net.swedz.little_big_redstone.network.packet.UpdateStickyNoteWatcherPacket;
import net.swedz.tesseract.neoforge.packet.PacketContext;

public record RequestStickyNoteWatcherPacket(Integer entityId, boolean start) implements LBRCustomPacket
{
    public static final StreamCodec<ByteBuf, RequestStickyNoteWatcherPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT).map(optional -> optional.orElse(null), Optional::ofNullable), RequestStickyNoteWatcherPacket::entityId, (StreamCodec)ByteBufCodecs.BOOL, RequestStickyNoteWatcherPacket::start, RequestStickyNoteWatcherPacket::new);

    public void handle(PacketContext context) {
        Entity entity;
        context.assertServerbound();
        if (this.start && this.entityId != null && (entity = context.getPlayer().level().getEntity(this.entityId.intValue())) instanceof StickyNoteEntity) {
            StickyNoteEntity entity2 = (StickyNoteEntity)entity;
            new UpdateStickyNoteWatcherPacket(new StickyNoteView(entity2.getColor(), entity2.getTextColor(), entity2.getNote().parsed())).sendToClient((ServerPlayer)context.getPlayer());
            context.getPlayer().setWatchedStickyNote(this.entityId);
        } else {
            context.getPlayer().setWatchedStickyNote(null);
        }
    }
}

