/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.wire;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.wire.PortReference;
import net.swedz.little_big_redstone.microchip.wire.Wire;
import net.swedz.little_big_redstone.microchip.wire.WirePort;

public final class MicrochipWires
implements Iterable<Wire> {
    public static final Codec<MicrochipWires> CODEC = Codec.list(Wire.CODEC).xmap(MicrochipWires::new, MicrochipWires::values);
    public static final StreamCodec<ByteBuf, MicrochipWires> STREAM_CODEC = Wire.STREAM_CODEC.apply(ByteBufCodecs.list()).map(MicrochipWires::new, MicrochipWires::values);
    private final Microchip microchip;
    private List<Wire> wires;
    private Map<Integer, Set<Wire>> wiresByOutputSlot;
    private Map<Integer, Set<Wire>> wiresByInputSlot;

    private MicrochipWires(Microchip microchip, List<Wire> wires) {
        this.microchip = microchip;
        this.wires = Lists.newArrayList();
        this.wiresByOutputSlot = Maps.newHashMap();
        this.wiresByInputSlot = Maps.newHashMap();
        wires.forEach(this::add);
    }

    private MicrochipWires(List<Wire> wires) {
        this(null, wires);
    }

    public MicrochipWires(Microchip microchip) {
        this(microchip, Lists.newArrayList());
    }

    public List<Wire> values() {
        return Collections.unmodifiableList(this.wires);
    }

    @Override
    public Iterator<Wire> iterator() {
        return this.values().iterator();
    }

    public List<Wire> getByOutputSlot(int outputSlot) {
        Set<Wire> list = this.wiresByOutputSlot.get(outputSlot);
        return list == null ? List.of() : List.copyOf(list);
    }

    public List<Wire> getByOutputSlot(int outputSlot, int outputPort) {
        return this.getByOutputSlot(outputSlot).stream().filter(wire -> wire.output().index() == outputPort).toList();
    }

    public List<Wire> getByOutputSlot(PortReference port) {
        return this.getByOutputSlot(port.slot(), port.index());
    }

    public List<Wire> getByInputSlot(int inputSlot) {
        Set<Wire> list = this.wiresByInputSlot.get(inputSlot);
        return list == null ? List.of() : List.copyOf(list);
    }

    public Wire getByInputSlot(int inputSlot, int inputPort) {
        return this.getByInputSlot(inputSlot).stream().filter(wire -> wire.input().index() == inputPort).findFirst().orElse(null);
    }

    public Wire getByInputSlot(PortReference port) {
        return this.getByInputSlot(port.slot(), port.index());
    }

    public List<Wire> getInvolvingSlot(int slot) {
        List<Wire> outputs = this.getByOutputSlot(slot);
        List<Wire> inputs = this.getByInputSlot(slot);
        ArrayList combined = Lists.newArrayList();
        combined.addAll(outputs);
        combined.addAll(inputs);
        return Collections.unmodifiableList(combined);
    }

    public Wire get(PortReference output, PortReference input) {
        return this.wires.stream().filter(wire -> wire.output().slot() == output.slot() && wire.output().index() == output.index() && wire.input().slot() == input.slot() && wire.input().index() == input.index()).findFirst().orElse(null);
    }

    public Wire get(int outputSlot, int outputPort, int inputSlot, int inputPort) {
        return this.get(new WirePort(outputSlot, outputPort), new WirePort(inputSlot, inputPort));
    }

    public boolean add(Wire wire) {
        if (this.getByInputSlot(wire.input()) != null) {
            return false;
        }
        if (this.wiresByOutputSlot.computeIfAbsent(wire.output().slot(), __ -> Sets.newHashSet()).add(wire)) {
            this.wiresByInputSlot.computeIfAbsent(wire.input().slot(), __ -> Sets.newHashSet()).add(wire);
            this.wires.add(wire);
            return true;
        }
        return false;
    }

    public boolean add(int outputSlot, int outputPort, int inputSlot, int inputPort) {
        return this.add(new Wire(outputSlot, outputPort, inputSlot, inputPort));
    }

    public boolean add(PortReference output, PortReference input) {
        return this.add(new Wire(output.slot(), output.index(), input.slot(), input.index()));
    }

    public boolean remove(Wire wire) {
        if (this.wires.remove(wire)) {
            int outputSlot = wire.output().slot();
            Set<Wire> outputs = this.wiresByOutputSlot.get(outputSlot);
            outputs.remove(wire);
            if (outputs.isEmpty()) {
                this.wiresByOutputSlot.remove(outputSlot);
            }
            int inputSlot = wire.input().slot();
            Set<Wire> inputs = this.wiresByInputSlot.get(inputSlot);
            inputs.remove(wire);
            if (inputs.isEmpty()) {
                this.wiresByInputSlot.remove(inputSlot);
            }
            return true;
        }
        return false;
    }

    public boolean remove(int outputSlot, int outputPort, int inputSlot, int inputPort) {
        return this.remove(new Wire(outputSlot, outputPort, inputSlot, inputPort));
    }

    public List<Wire> removeAllOutputs(int outputSlot) {
        List<Wire> wires = this.getByOutputSlot(outputSlot);
        wires.forEach(this::remove);
        return wires;
    }

    public List<Wire> removeAllInputs(int inputSlot) {
        List<Wire> wires = this.getByInputSlot(inputSlot);
        wires.forEach(this::remove);
        return wires;
    }

    public int cleanup(LogicEntry entry) {
        int wiresRemoved = 0;
        int slot = entry.slot();
        int totalInputs = entry.component().inputs();
        int totalOutputs = entry.component().outputs();
        for (Wire wire : this.getInvolvingSlot(slot)) {
            if ((wire.input().slot() != slot || wire.input().index() < totalInputs) && (wire.output().slot() != slot || wire.output().index() < totalOutputs)) continue;
            this.remove(wire);
            ++wiresRemoved;
        }
        return wiresRemoved;
    }

    public MicrochipWires with(Microchip microchip) {
        MicrochipWires wires = new MicrochipWires(microchip);
        wires.loadFrom(this);
        return wires;
    }

    public void loadFrom(MicrochipWires other) {
        this.wires = Lists.newArrayList(other.wires);
        this.wiresByOutputSlot = Maps.newHashMap();
        for (Map.Entry<Integer, Set<Wire>> entry : other.wiresByOutputSlot.entrySet()) {
            this.wiresByOutputSlot.put(entry.getKey(), Sets.newHashSet((Iterable)entry.getValue()));
        }
        this.wiresByInputSlot = Maps.newHashMap();
        for (Map.Entry<Integer, Set<Wire>> entry : other.wiresByInputSlot.entrySet()) {
            this.wiresByInputSlot.put(entry.getKey(), Sets.newHashSet((Iterable)entry.getValue()));
        }
    }

    public void clear() {
        this.wires.clear();
        this.wiresByOutputSlot.clear();
        this.wiresByInputSlot.clear();
    }

    public int hashCode() {
        return this.wires.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof MicrochipWires)) return false;
        MicrochipWires other = (MicrochipWires)o;
        if (!this.wires.equals(other.wires)) return false;
        return true;
    }
}

